/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.ElementValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.StringValue;
import org.eclipse.ocl.examples.domain.values.TypeValue;
import org.eclipse.ocl.examples.domain.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValue
implements Value {
    protected final ValueFactory valueFactory;

    protected AbstractValue(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    public BagValue asBagValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Bag", this.getType());
    }

    @Override
    public boolean asBoolean() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Boolean", this.getType());
        return false;
    }

    @Override
    public BooleanValue asBooleanValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Boolean", this.getType());
    }

    @Override
    public CollectionValue asCollectionValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Collection", this.getType());
    }

    @Override
    public Double asDouble() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Double", this.getType());
        return null;
    }

    @Override
    public Object asEcoreObject() {
        return this.asObject();
    }

    @Override
    public DomainElement asElement() {
        return null;
    }

    @Override
    public ElementValue asElementValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Element", this.getType());
    }

    @Override
    public Integer asInteger() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer", this.getType());
        return null;
    }

    @Override
    public IntegerValue asIntegerValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer", this.getType());
    }

    @Override
    public EObject asNavigableObject() throws InvalidValueException {
        Object object = this.asObject();
        if (object instanceof EObject) {
            return (EObject)object;
        }
        return (EObject)this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Object", this.getType());
    }

    @Override
    public ObjectValue asObjectValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Object", this.getType());
    }

    @Override
    public OrderedSetValue asOrderedSetValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "OrderedSet", this.getType());
    }

    @Override
    public RealValue asRealValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Real", this.getType());
    }

    @Override
    public SequenceValue asSequenceValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Sequence", this.getType());
    }

    @Override
    public SetValue asSetValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Set", this.getType());
    }

    @Override
    public String asString() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "String", this.getType());
        return null;
    }

    @Override
    public StringValue asStringValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "String", this.getType());
    }

    @Override
    public TypeValue asTypeValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Type", this.getType());
    }

    @Override
    public UniqueCollectionValue asUniqueCollectionValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.TypedValueRequired, "Unique Collection", this.getType());
    }

    @Override
    public DomainType getActualType() {
        return this.getType();
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Override
    public CollectionValue isCollectionValue() {
        return null;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public IntegerValue isIntegerValue() {
        return null;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public RealValue isRealValue() {
        return null;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isUndefined() {
        return false;
    }

    @Override
    public boolean isUnlimited() {
        return false;
    }

    @Override
    public boolean isUnlimitedNatural() {
        return false;
    }

    @Override
    public String oclToString() {
        return this.toString();
    }

    @Override
    public IntegerValue toIntegerValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Integer");
    }

    @Override
    public Iterator<Value> toIteratorValue() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Integer");
        return null;
    }

    @Override
    public RealValue toRealValue() throws InvalidValueException {
        return this.valueFactory.throwInvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Real");
    }

    @Override
    public void toString(StringBuilder s, int sizeLimit) {
        s.append(this.toString());
    }
}

