/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.ocl.examples.domain.elements.DomainClassifierType;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainEnumeration;
import org.eclipse.ocl.examples.domain.elements.DomainEnumerationLiteral;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.Bag;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.ElementValue;
import org.eclipse.ocl.examples.domain.values.EnumerationLiteralValue;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.InvalidValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.OrderedSet;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.StringValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.TypeValue;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.BagImpl;
import org.eclipse.ocl.examples.domain.values.impl.BagValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.BooleanValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.ClassifierTypeValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.CollectionTypeValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.EObjectValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.ElementValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.EnumerationLiteralValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.EnumerationTypeValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.IntegerIntValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.IntegerLongValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.IntegerRangeImpl;
import org.eclipse.ocl.examples.domain.values.impl.IntegerValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.NullValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.ObjectValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetImpl;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.RealValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SequenceRangeImpl;
import org.eclipse.ocl.examples.domain.values.impl.SequenceValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SimpleTypeValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.StringValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.TupleValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.UnlimitedValueImpl;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValueFactory
implements ValueFactory {
    public static final BigInteger INTEGER_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger INTEGER_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final String maxLongValue = Long.toString(Long.MAX_VALUE);
    private static final int maxLongSize = maxLongValue.length();
    private BooleanValue falseValue;
    private InvalidValue invalidValue;
    private NullValue nullValue;
    private IntegerValue oneValue;
    private BooleanValue trueValue;
    private UnlimitedValue unlimitedValue;
    private IntegerValue zeroValue;
    protected final DomainStandardLibrary standardLibrary;

    public AbstractValueFactory(DomainStandardLibrary standardLibrary) {
        this.standardLibrary = standardLibrary;
    }

    @Override
    public BooleanValue booleanValueOf(boolean value) {
        return value ? this.getTrue() : this.getFalse();
    }

    @Override
    public BagValue createBagOf(Object ... objects) {
        BagImpl<Value> collection = new BagImpl<Value>();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                collection.add(this.valueOf(object));
                ++n2;
            }
        }
        DomainType elementType = this.getElementType(collection);
        return this.createBagValue(this.standardLibrary.getBagType(elementType), (Bag<? extends Value>)collection);
    }

    @Override
    public BagValue createBagOf(Iterable<?> objects) {
        BagImpl<Value> collection = new BagImpl<Value>();
        if (objects != null) {
            for (Object object : objects) {
                collection.add(this.valueOf(object));
            }
        }
        DomainType elementType = this.getElementType(collection);
        return this.createBagValue(this.standardLibrary.getBagType(elementType), (Bag<? extends Value>)collection);
    }

    @Override
    public BagValue createBagValue(DomainCollectionType type, Value ... values) {
        return new BagValueImpl((ValueFactory)this, type, values);
    }

    @Override
    public BagValue createBagValue(DomainCollectionType type, Bag<? extends Value> values) {
        return new BagValueImpl((ValueFactory)this, type, (Collection<? extends Value>)values);
    }

    @Override
    public BagValue createBagValue(DomainCollectionType type, Collection<? extends Value> values) {
        return new BagValueImpl((ValueFactory)this, type, values);
    }

    @Override
    public BagValue createBagValue(Value ... values) {
        DomainType elementType = this.getElementType(values);
        DomainCollectionType collectionType = this.standardLibrary.getBagType(elementType);
        return new BagValueImpl((ValueFactory)this, collectionType, values);
    }

    @Override
    public BooleanValue.Accumulator createBooleanAccumulatorValue() {
        return new BooleanValueImpl.Accumulator(this, false);
    }

    @Override
    public CollectionValue.Accumulator createCollectionAccumulatorValue(DomainCollectionType type) {
        DomainStandardLibrary standardLibrary = this.getStandardLibrary();
        if (type instanceof DomainCollectionType) {
            DomainCollectionType collectionValueType = type;
            boolean isOrdered = collectionValueType.isOrdered();
            boolean isUnique = collectionValueType.isUnique();
            if (isOrdered) {
                if (isUnique) {
                    return new OrderedSetValueImpl.Accumulator(this, collectionValueType);
                }
                return new SequenceValueImpl.Accumulator(this, collectionValueType);
            }
            if (isUnique) {
                return new SetValueImpl.Accumulator(this, collectionValueType);
            }
            return new BagValueImpl.Accumulator(this, collectionValueType);
        }
        return new SetValueImpl.Accumulator(this, standardLibrary.getSetType(type));
    }

    @Override
    public CollectionValue createCollectionValue(boolean isOrdered, boolean isUnique, Value ... values) {
        return this.createCollectionValue(isOrdered, isUnique, this.getElementType(values), values);
    }

    @Override
    public CollectionValue createCollectionValue(boolean isOrdered, boolean isUnique, Collection<Value> values) {
        return this.createCollectionValue(isOrdered, isUnique, this.getElementType(values), values);
    }

    @Override
    public CollectionValue createCollectionValue(boolean isOrdered, boolean isUnique, DomainType elementType, Value ... values) {
        if (isOrdered) {
            if (isUnique) {
                return this.createOrderedSetValue(this.standardLibrary.getOrderedSetType(elementType), values);
            }
            return this.createSequenceValue(this.standardLibrary.getSequenceType(elementType), values);
        }
        if (isUnique) {
            return this.createSetValue(this.standardLibrary.getSetType(elementType), values);
        }
        return this.createBagValue(this.standardLibrary.getBagType(elementType), values);
    }

    @Override
    public CollectionValue createCollectionValue(boolean isOrdered, boolean isUnique, DomainType elementType, Collection<Value> values) {
        if (isOrdered) {
            if (isUnique) {
                return this.createOrderedSetValue(this.standardLibrary.getOrderedSetType(elementType), values);
            }
            return this.createSequenceValue(this.standardLibrary.getSequenceType(elementType), values);
        }
        if (isUnique) {
            return this.createSetValue(this.standardLibrary.getSetType(elementType), values);
        }
        return this.createBagValue(this.standardLibrary.getBagType(elementType), values);
    }

    @Override
    public ObjectValue createEObjectValue(EObject eObject) {
        if (eObject instanceof DomainElement) {
            if (eObject instanceof DomainType) {
                return this.createTypeValue((DomainType)eObject);
            }
            if (eObject instanceof DomainEnumerationLiteral) {
                return this.createEnumerationLiteralValue((DomainEnumerationLiteral)eObject);
            }
            return this.createElementValue((DomainElement)eObject);
        }
        if (eObject instanceof EEnumLiteral) {
            return this.createEnumerationLiteralValue((EEnumLiteral)eObject);
        }
        return null;
    }

    @Override
    public ElementValue createElementValue(DomainElement element) {
        return new ElementValueImpl((ValueFactory)this, element);
    }

    @Override
    public EnumerationLiteralValue createEnumerationLiteralValue(DomainEnumerationLiteral element) {
        return new EnumerationLiteralValueImpl((ValueFactory)this, element);
    }

    @Override
    public EnumerationLiteralValue createEnumerationLiteralValue(EEnumLiteral eEnumLiteral) {
        DomainEnumeration enumeration = (DomainEnumeration)this.standardLibrary.getType((EClassifier)eEnumLiteral.getEEnum());
        DomainEnumerationLiteral enumerationLiteral = enumeration.getEnumerationLiteral(eEnumLiteral.getName());
        return this.createEnumerationLiteralValue(enumerationLiteral);
    }

    @Override
    public EnumerationLiteralValue createEnumerationLiteralValue(Enumerator enumerator, EEnum eEnum) {
        DomainEnumeration enumeration = eEnum == null ? this.standardLibrary.getEnumeration(enumerator) : (DomainEnumeration)this.standardLibrary.getType((EClassifier)eEnum);
        DomainEnumerationLiteral enumerationLiteral = enumeration.getEnumerationLiteral(enumerator.getName());
        return this.createEnumerationLiteralValue(enumerationLiteral);
    }

    @Override
    public InvalidValue createInvalidValue(InvalidEvaluationException exception) {
        return new InvalidValueImpl(this, exception);
    }

    @Override
    public InvalidValue createInvalidValue(InvalidValueException exception) {
        return new InvalidValueImpl(this, new InvalidEvaluationException(null, exception));
    }

    @Override
    public ObjectValue createObjectValue(Object object) {
        return new ObjectValueImpl((ValueFactory)this, object);
    }

    @Override
    public OrderedSetValue createOrderedSetOf(Iterable<?> objects) {
        OrderedSetImpl<Value> collection = new OrderedSetImpl<Value>();
        if (objects != null) {
            for (Object object : objects) {
                collection.add(this.valueOf(object));
            }
        }
        DomainType elementType = this.getElementType(collection);
        return this.createOrderedSetValue(this.standardLibrary.getOrderedSetType(elementType), (OrderedSet<? extends Value>)collection);
    }

    @Override
    public OrderedSetValue createOrderedSetOf(Object ... objects) {
        OrderedSetImpl<Value> collection = new OrderedSetImpl<Value>();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                collection.add(this.valueOf(object));
                ++n2;
            }
        }
        DomainType elementType = this.getElementType(collection);
        return this.createOrderedSetValue(this.standardLibrary.getOrderedSetType(elementType), (OrderedSet<? extends Value>)collection);
    }

    @Override
    public OrderedSetValue createOrderedSetValue(DomainCollectionType type, Value ... values) {
        return new OrderedSetValueImpl((ValueFactory)this, type, values);
    }

    @Override
    public OrderedSetValue createOrderedSetValue(DomainCollectionType type, OrderedSet<? extends Value> values) {
        return new OrderedSetValueImpl((ValueFactory)this, type, (Collection<? extends Value>)values);
    }

    @Override
    public OrderedSetValue createOrderedSetValue(DomainCollectionType type, Collection<? extends Value> values) {
        return new OrderedSetValueImpl((ValueFactory)this, type, values);
    }

    @Override
    public OrderedSetValue createOrderedSetValue(Value ... values) {
        DomainType elementType = this.getElementType(values);
        DomainCollectionType collectionType = this.standardLibrary.getOrderedSetType(elementType);
        return new OrderedSetValueImpl((ValueFactory)this, collectionType, values);
    }

    @Override
    public SequenceValue createSequenceOf(Object ... objects) {
        ArrayList<Value> collection = new ArrayList<Value>();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                collection.add(this.valueOf(object));
                ++n2;
            }
        }
        DomainType elementType = this.getElementType(collection);
        return this.createSequenceValue(this.standardLibrary.getSequenceType(elementType), (List<? extends Value>)collection);
    }

    @Override
    public SequenceValue createSequenceOf(Iterable<?> objects) {
        ArrayList<Value> collection = new ArrayList<Value>();
        if (objects != null) {
            for (Object object : objects) {
                collection.add(this.valueOf(object));
            }
        }
        DomainType elementType = this.getElementType(collection);
        return this.createSequenceValue(this.standardLibrary.getSequenceType(elementType), (List<? extends Value>)collection);
    }

    @Override
    public IntegerRange createRange(IntegerValue firstInteger, IntegerValue lastInteger) throws InvalidValueException {
        return new IntegerRangeImpl(firstInteger, lastInteger);
    }

    @Override
    public SequenceValue createSequenceAccumulatorValue(DomainCollectionType type, List<Value> values) {
        return new SequenceValueImpl.Accumulator((ValueFactory)this, type, values);
    }

    @Override
    public SequenceValue createSequenceRange(DomainCollectionType type, IntegerRange range) {
        return new SequenceRangeImpl((ValueFactory)this, type, range);
    }

    @Override
    public SequenceValue createSequenceValue(DomainCollectionType type, Value ... values) {
        return new SequenceValueImpl((ValueFactory)this, type, values);
    }

    @Override
    public SequenceValue createSequenceValue(DomainCollectionType type, List<? extends Value> values) {
        return new SequenceValueImpl((ValueFactory)this, type, (Collection<? extends Value>)values);
    }

    @Override
    public SequenceValue createSequenceValue(DomainCollectionType type, Collection<? extends Value> values) {
        return new SequenceValueImpl((ValueFactory)this, type, values);
    }

    @Override
    public SequenceValue createSequenceValue(Value ... values) {
        DomainType elementType = this.getElementType(values);
        DomainCollectionType collectionType = this.standardLibrary.getSequenceType(elementType);
        return new SequenceValueImpl((ValueFactory)this, collectionType, values);
    }

    @Override
    public SetValue createSetOf(Object ... objects) {
        HashSet<Value> collection = new HashSet<Value>();
        if (objects != null) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                collection.add(this.valueOf(object));
                ++n2;
            }
        }
        DomainType elementType = this.getElementType(collection);
        return this.createSetValue(this.standardLibrary.getSetType(elementType), (Set<? extends Value>)collection);
    }

    @Override
    public SetValue createSetOf(Iterable<?> objects) {
        HashSet<Value> collection = new HashSet<Value>();
        if (objects != null) {
            for (Object object : objects) {
                collection.add(this.valueOf(object));
            }
        }
        DomainType elementType = this.getElementType(collection);
        return this.createSetValue(this.standardLibrary.getSetType(elementType), (Set<? extends Value>)collection);
    }

    @Override
    public SetValue createSetValue(DomainCollectionType type, Value ... values) {
        return new SetValueImpl((ValueFactory)this, type, values);
    }

    @Override
    public SetValue createSetValue(DomainCollectionType type, Set<? extends Value> values) {
        return new SetValueImpl((ValueFactory)this, type, (Collection<? extends Value>)values);
    }

    @Override
    public SetValue createSetValue(DomainCollectionType type, Collection<? extends Value> values) {
        return new SetValueImpl((ValueFactory)this, type, values);
    }

    @Override
    public SetValue createSetValue(Value ... values) {
        DomainType elementType = this.getElementType(values);
        DomainCollectionType collectionType = this.standardLibrary.getSetType(elementType);
        return new SetValueImpl((ValueFactory)this, collectionType, values);
    }

    @Override
    public TupleValue createTupleValue(DomainTupleType type, Map<? extends DomainTypedElement, Value> values) {
        return new TupleValueImpl(this, type, values);
    }

    @Override
    public TypeValue createTypeValue(DomainType type) {
        if (type instanceof DomainClassifierType) {
            return new ClassifierTypeValueImpl((ValueFactory)this, (DomainClassifierType)type);
        }
        if (type instanceof DomainCollectionType) {
            return new CollectionTypeValueImpl((ValueFactory)this, (DomainCollectionType)type);
        }
        if (type instanceof DomainEnumeration) {
            return new EnumerationTypeValueImpl((ValueFactory)this, (DomainEnumeration)type);
        }
        return new SimpleTypeValueImpl((ValueFactory)this, type);
    }

    @Override
    public void dispose() {
        this.falseValue = null;
        this.invalidValue = null;
        this.nullValue = null;
        this.oneValue = null;
        this.trueValue = null;
        this.unlimitedValue = null;
        this.zeroValue = null;
    }

    @Override
    public DomainType getElementType(Value ... values) {
        DomainType elementType = this.standardLibrary.getOclVoidType();
        Value[] valueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            elementType = elementType.getCommonType(this.standardLibrary, value.getType());
            ++n2;
        }
        return elementType;
    }

    @Override
    public final Object getEcoreValueOf(Value value) {
        return value.asEcoreObject();
    }

    @Override
    public DomainType getElementType(Iterable<Value> values) {
        DomainType elementType = this.standardLibrary.getOclVoidType();
        for (Value value : values) {
            elementType = elementType.getCommonType(this.standardLibrary, value.getType());
        }
        return elementType;
    }

    @Override
    public BooleanValue getFalse() {
        if (this.falseValue == null) {
            this.falseValue = new BooleanValueImpl(this, false);
        }
        return this.falseValue;
    }

    @Override
    public InvalidValue getInvalid() {
        if (this.invalidValue == null) {
            this.invalidValue = new InvalidValueImpl(this);
        }
        return this.invalidValue;
    }

    @Override
    public NullValue getNull() {
        if (this.nullValue == null) {
            this.nullValue = new NullValueImpl(this);
        }
        return this.nullValue;
    }

    @Override
    public IntegerValue getOne() {
        if (this.oneValue == null) {
            this.oneValue = this.integerValueOf(1);
        }
        return this.oneValue;
    }

    @Override
    public final DomainStandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    public BooleanValue getTrue() {
        if (this.trueValue == null) {
            this.trueValue = new BooleanValueImpl(this, true);
        }
        return this.trueValue;
    }

    @Override
    public UnlimitedValue getUnlimited() {
        if (this.unlimitedValue == null) {
            this.unlimitedValue = new UnlimitedValueImpl(this);
        }
        return this.unlimitedValue;
    }

    @Override
    public IntegerValue getZero() {
        if (this.zeroValue == null) {
            this.zeroValue = this.integerValueOf(0);
        }
        return this.zeroValue;
    }

    @Override
    public IntegerValue integerValueOf(int value) {
        return new IntegerIntValueImpl(this, value);
    }

    @Override
    public IntegerValue integerValueOf(long value) {
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return new IntegerIntValueImpl(this, (int)value);
        }
        return new IntegerLongValueImpl(this, value);
    }

    @Override
    public IntegerValue integerValueOf(BigInteger value) {
        if (value.signum() >= 0) {
            if (value.compareTo(INTEGER_MAX_VALUE) <= 0) {
                return new IntegerIntValueImpl(this, value.intValue());
            }
            if (value.compareTo(LONG_MAX_VALUE) <= 0) {
                return new IntegerLongValueImpl(this, value.longValue());
            }
        } else {
            if (value.compareTo(INTEGER_MIN_VALUE) >= 0) {
                return new IntegerIntValueImpl(this, value.intValue());
            }
            if (value.compareTo(LONG_MIN_VALUE) >= 0) {
                return new IntegerLongValueImpl(this, value.longValue());
            }
        }
        return new IntegerValueImpl((ValueFactory)this, value);
    }

    @Override
    public IntegerValue integerValueOf(String aValue) throws InvalidValueException {
        try {
            int len = aValue.length();
            if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
                return this.integerValueOf(BigInteger.valueOf(Long.parseLong(aValue)));
            }
            return this.integerValueOf(new BigInteger(aValue));
        }
        catch (NumberFormatException e) {
            return this.throwInvalidValueException(e, EvaluatorMessages.InvalidInteger, aValue);
        }
    }

    @Override
    public RealValue realValueOf(double value) {
        return new RealValueImpl((ValueFactory)this, value);
    }

    @Override
    public RealValue realValueOf(BigDecimal value) {
        return new RealValueImpl((ValueFactory)this, value);
    }

    @Override
    public RealValue realValueOf(IntegerValue integerValue) {
        return this.realValueOf(integerValue.bigDecimalValue());
    }

    @Override
    public RealValue realValueOf(String aValue) throws InvalidValueException {
        try {
            return new RealValueImpl((ValueFactory)this, new BigDecimal(aValue.trim()));
        }
        catch (NumberFormatException e) {
            return this.throwInvalidValueException(e, EvaluatorMessages.InvalidReal, aValue);
        }
    }

    @Override
    public StringValue stringValueOf(String value) {
        return new StringValueImpl(this, value);
    }

    @Override
    public InvalidValue throwInvalidValueException(String message, Object ... bindings) throws InvalidValueException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidValueException(boundMessage);
    }

    public InvalidValue throwInvalidValueException(Throwable e, String message, Object ... bindings) throws InvalidValueException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidValueException(boundMessage, e);
    }

    @Override
    public DomainType typeOf(Value value, Value ... values) {
        DomainType type = value.getType();
        Value[] valueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Value anotherValue = valueArray[n2];
            type = type.getCommonType(this.standardLibrary, anotherValue.getType());
            ++n2;
        }
        return type;
    }

    @Override
    public Value valueOf(Object object) {
        if (object == null) {
            return this.getNull();
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof EObject) {
            ObjectValue eObjectValue = this.createEObjectValue((EObject)object);
            if (eObjectValue != null) {
                return eObjectValue;
            }
            return new EObjectValueImpl((ValueFactory)this, (EObject)object);
        }
        if (object instanceof Number) {
            if (object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof Byte) {
                return this.integerValueOf(((Number)object).longValue());
            }
            if (object instanceof Float || object instanceof Double) {
                return this.realValueOf(((Number)object).doubleValue());
            }
            if (object instanceof BigDecimal) {
                return this.realValueOf((BigDecimal)object);
            }
            if (object instanceof BigInteger) {
                return this.integerValueOf((BigInteger)object);
            }
        } else {
            if (object instanceof String) {
                return this.stringValueOf((String)object);
            }
            if (object instanceof Character) {
                return this.integerValueOf(((Character)object).charValue());
            }
            if (object instanceof Boolean) {
                return this.booleanValueOf((Boolean)object);
            }
            if (object.getClass().isArray()) {
                try {
                    return this.createSequenceOf((Object[])object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            } else if (object instanceof Iterable) {
                if (object instanceof LinkedHashSet || object instanceof OrderedSet) {
                    return this.createOrderedSetOf((Iterable)object);
                }
                if (object instanceof Bag) {
                    return this.createBagOf((Iterable)object);
                }
                if (object instanceof Set) {
                    return this.createSetOf((Iterable)object);
                }
                return this.createSequenceOf((Iterable)object);
            }
        }
        return this.createObjectValue(object);
    }

    @Override
    public Value valueOf(Object eValue, EClassifier eClassifier) {
        if (eValue instanceof Value) {
            return (Value)eValue;
        }
        if (eClassifier instanceof EEnum) {
            return this.createEnumerationLiteralValue((Enumerator)eValue, (EEnum)eClassifier);
        }
        return this.valueOf(eValue);
    }

    @Override
    public Value valueOf(Object eValue, ETypedElement eFeature) {
        EClassifier eClassifier = eFeature.getEType();
        if (eFeature.isMany()) {
            Collection eValues = (Collection)eValue;
            ArrayList<Value> values = new ArrayList<Value>(eValues.size());
            for (Object eVal : eValues) {
                values.add(this.valueOf(eVal, eClassifier));
            }
            boolean isOrdered = eFeature.isOrdered();
            boolean isUnique = eFeature.isUnique();
            return this.createCollectionValue(isOrdered, isUnique, values);
        }
        return this.valueOf(eValue, eClassifier);
    }
}

