/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.NumericValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractIntegerValue;
import org.eclipse.ocl.examples.domain.values.impl.RealValueImpl;

public class IntegerValueImpl
extends AbstractIntegerValue {
    private final BigInteger value;

    public IntegerValueImpl(ValueFactory valueFactory, long value) {
        this(valueFactory, BigInteger.valueOf(value));
    }

    public IntegerValueImpl(ValueFactory valueFactory, BigInteger value) {
        super(valueFactory);
        this.value = value;
        assert (value != null);
    }

    public IntegerValue abs() {
        return this.valueFactory.integerValueOf(this.value.abs());
    }

    public IntegerValue add(IntegerValue right) throws InvalidValueException {
        return this.valueFactory.integerValueOf(this.value.add(right.bigIntegerValue()));
    }

    public Double asDouble() {
        return this.value.doubleValue();
    }

    public Integer asInteger() {
        return this.value.intValue();
    }

    public Object asObject() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public int compareTo(NumericValue o) {
        if (o instanceof IntegerValue) {
            return this.value.compareTo(((IntegerValue)o).bigIntegerValue());
        }
        return Double.compare(this.doubleValue(), o.doubleValue());
    }

    public IntegerValue div(IntegerValue right) throws InvalidValueException {
        if (right.bigIntegerValue().signum() == 0) {
            return null;
        }
        return this.valueFactory.integerValueOf(this.value.divide(right.bigIntegerValue()));
    }

    public RealValue divide(IntegerValue right) throws InvalidValueException {
        BigDecimal bigLeft = this.bigDecimalValue();
        BigDecimal bigRight = right.bigDecimalValue();
        return RealValueImpl.divideBigDecimal(this.valueFactory, bigLeft, bigRight);
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerValue) {
            BigInteger bigIntegerValue = ((IntegerValue)obj).bigIntegerValue();
            return bigIntegerValue != null && this.value.compareTo(bigIntegerValue) == 0;
        }
        if (obj instanceof RealValue) {
            BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
            return bigDecimalValue != null && this.bigDecimalValue().compareTo(bigDecimalValue) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public boolean isUnlimitedNatural() {
        return this.signum() >= 0;
    }

    public IntegerValue max(IntegerValue right) throws InvalidValueException {
        return this.value.compareTo(right.bigIntegerValue()) >= 0 ? this : right;
    }

    public IntegerValue min(IntegerValue right) throws InvalidValueException {
        return this.value.compareTo(right.bigIntegerValue()) <= 0 ? this : right;
    }

    public IntegerValue mod(IntegerValue right) throws InvalidValueException {
        if (right.bigIntegerValue().signum() == 0) {
            return null;
        }
        return this.valueFactory.integerValueOf(this.value.remainder(right.bigIntegerValue()));
    }

    public IntegerValue multiply(IntegerValue right) throws InvalidValueException {
        return this.valueFactory.integerValueOf(this.value.multiply(right.bigIntegerValue()));
    }

    public IntegerValue negate() {
        return this.valueFactory.integerValueOf(this.value.negate());
    }

    public int signum() {
        return this.value.signum();
    }

    public IntegerValue subtract(IntegerValue right) throws InvalidValueException {
        return this.valueFactory.integerValueOf(this.value.subtract(right.bigIntegerValue()));
    }

    public String toString() {
        return this.value.toString();
    }
}

