/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.Value;

public class ForAllIteration
extends AbstractIteration {
    public static final ForAllIteration INSTANCE = new ForAllIteration();

    public BooleanValue.Accumulator createAccumulatorValue(DomainEvaluator evaluator, DomainType accumulatorType, DomainType bodyType) {
        return evaluator.getValueFactory().createBooleanAccumulatorValue();
    }

    protected Value resolveTerminalValue(DomainIterationManager iterationManager) {
        return iterationManager.getValueFactory().getTrue();
    }

    protected Value updateAccumulator(DomainIterationManager iterationManager) {
        Value bodyVal = iterationManager.evaluateBody();
        if (bodyVal.isUndefined()) {
            return iterationManager.throwInvalidEvaluation(EvaluatorMessages.UndefinedBody, new Object[]{"forAll"});
        }
        if (bodyVal.isTrue()) {
            return null;
        }
        return iterationManager.getValueFactory().getFalse();
    }
}

