/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.library.LibraryValidator;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.AbstractValue;

public class SortedByIteration
extends AbstractIteration {
    public static final SortedByIteration INSTANCE = new SortedByIteration();
    private static LibraryValidator validator = null;

    public SortingValue createAccumulatorValue(DomainEvaluator evaluator, DomainType accumulatorType, DomainType bodyType) throws InvalidValueException {
        DomainStandardLibrary standardLibrary = evaluator.getValueFactory().getStandardLibrary();
        DomainInheritance comparableType = standardLibrary.getOclComparableType().getInheritance(standardLibrary);
        DomainInheritance selfType = standardLibrary.getOclSelfType().getInheritance(standardLibrary);
        DomainOperation staticOperation = comparableType.lookupLocalOperation(standardLibrary, EvaluatorMessages.CompareToOperation, new DomainInheritance[]{selfType});
        try {
            LibraryFeature implementation = bodyType.lookupImplementation(standardLibrary, staticOperation);
            return new SortingValue(evaluator, accumulatorType, (LibraryBinaryOperation)implementation);
        }
        catch (Exception e) {
            throw new InvalidValueException((Throwable)e);
        }
    }

    public LibraryValidator getValidator(DomainStandardLibrary standardLibrary) {
        if (validator == null) {
            validator = SortedByIteration.getLibraryValidator((Object)standardLibrary, (String)"org.eclipse.ocl.examples.pivot.library.validators.ValidateSortedByIteration");
        }
        return validator;
    }

    protected Value resolveTerminalValue(DomainIterationManager iterationManager) {
        SortingValue accumulatorValue = (SortingValue)iterationManager.getAccumulatorValue();
        return accumulatorValue.createSortedValue();
    }

    protected Value updateAccumulator(DomainIterationManager iterationManager) {
        Value bodyVal = iterationManager.evaluateBody();
        if (bodyVal.isUndefined()) {
            return iterationManager.throwInvalidEvaluation(EvaluatorMessages.UndefinedBody, new Object[]{"sortedBy"});
        }
        Value iterValue = iterationManager.get();
        SortingValue accumulatorValue = (SortingValue)iterationManager.getAccumulatorValue();
        accumulatorValue.put(iterValue, bodyVal);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SortingValue
    extends AbstractValue
    implements Comparator<Value> {
        protected final DomainType type;
        private final DomainEvaluator evaluator;
        private final DomainType iteratorType;
        private final LibraryBinaryOperation implementation;
        private final Map<Value, Value> content = new HashMap<Value, Value>();
        private Map<Value, Integer> repeatCounts = null;

        public SortingValue(DomainEvaluator evaluator, DomainType returnType, LibraryBinaryOperation implementation) {
            super(evaluator.getValueFactory());
            this.type = returnType;
            this.evaluator = evaluator;
            this.iteratorType = this.valueFactory.getStandardLibrary().getIntegerType();
            this.implementation = implementation;
        }

        public Object asObject() {
            return this.content;
        }

        public Value asValidValue() {
            return this;
        }

        @Override
        public int compare(Value o1, Value o2) {
            Value v2;
            if (o1 == o2) {
                return 0;
            }
            Value v1 = this.content.get(o1);
            if (v1 == (v2 = this.content.get(o2))) {
                return 0;
            }
            try {
                IntegerValue comparison = this.implementation.evaluate(this.evaluator, this.iteratorType, v1, v2).asIntegerValue();
                return comparison.signum();
            }
            catch (InvalidValueException e) {
                this.evaluator.throwInvalidEvaluation(e);
                return 0;
            }
        }

        public Value createSortedValue() {
            ArrayList<Value> result = new ArrayList<Value>(this.content.keySet());
            Collections.sort(result, this);
            boolean isUnique = this.type.isUnique();
            if (isUnique || this.repeatCounts == null) {
                return this.valueFactory.createCollectionValue(true, isUnique, this.type, result);
            }
            ArrayList<Value> nonUniqueResult = new ArrayList<Value>();
            for (Value resultValue : result) {
                nonUniqueResult.add(resultValue);
                Integer repeatCount = this.repeatCounts.get(resultValue);
                if (repeatCount == null) continue;
                int i = repeatCount;
                while (i > 0) {
                    nonUniqueResult.add(resultValue);
                    --i;
                }
            }
            return this.valueFactory.createCollectionValue(true, false, this.type, nonUniqueResult);
        }

        public DomainType getType() {
            return this.type;
        }

        public void put(Value iterVal, Value comparable) {
            if (this.content.put(iterVal, comparable) != null && !this.type.isUnique()) {
                Integer repeatCount;
                if (this.repeatCounts == null) {
                    this.repeatCounts = new HashMap<Value, Integer>();
                }
                repeatCount = (repeatCount = this.repeatCounts.get(iterVal)) == null ? Integer.valueOf(1) : Integer.valueOf(repeatCount + 1);
                this.repeatCounts.put(iterVal, repeatCount);
            }
        }

        public String toString() {
            return this.content.toString();
        }
    }
}

