/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.oclany;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.TypeValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class OclAnyOclAsTypeOperation
extends AbstractBinaryOperation {
    public static final OclAnyOclAsTypeOperation INSTANCE = new OclAnyOclAsTypeOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceVal, Value argVal) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        DomainType sourceType = sourceVal.getActualType();
        if (sourceType == null) {
            return valueFactory.throwInvalidValueException(EvaluatorMessages.MissingSourceType, new Object[0]);
        }
        TypeValue typeVal = argVal.asTypeValue();
        DomainType argType = typeVal.getInstanceType();
        if (sourceType.conformsTo(valueFactory.getStandardLibrary(), argType)) {
            return sourceVal;
        }
        return valueFactory.throwInvalidValueException(EvaluatorMessages.IncompatibleArgumentType, new Object[]{argType});
    }
}

