/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import java.util.ArrayList;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractUnaryOperation;
import org.eclipse.ocl.examples.domain.values.StringValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class StringCharactersOperation
extends AbstractUnaryOperation {
    public static final StringCharactersOperation INSTANCE = new StringCharactersOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceVal) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        String sourceString = sourceVal.asString();
        ArrayList<StringValue> results = new ArrayList<StringValue>(sourceString.length());
        int i = 0;
        while (i < sourceString.length()) {
            String s = sourceString.substring(i, i + 1);
            results.add(valueFactory.stringValueOf(s));
            ++i;
        }
        return valueFactory.createSequenceValue((DomainCollectionType)returnType, results);
    }
}

