/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ocl.examples.pivot.BasicEnvironment;
import org.eclipse.ocl.examples.pivot.options.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicEnvironment
implements BasicEnvironment {
    private BasicEnvironment parent;
    private final Map<Option<?>, Object> options = new HashMap();

    protected AbstractBasicEnvironment(BasicEnvironment parent) {
        this.parent = parent;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        AbstractBasicEnvironment result = adapterType.isAssignableFrom(this.getClass()) ? this : null;
        return (T)result;
    }

    public BasicEnvironment getParent() {
        return this.parent;
    }

    protected void setParent(BasicEnvironment parent) {
        this.parent = parent;
    }

    protected Map<Option<?>, Object> basicGetOptions() {
        return this.options;
    }

    @Override
    public Map<Option<?>, Object> getOptions() {
        HashMap result = this.getParent() != null ? new HashMap(this.getParent().getOptions()) : new HashMap();
        result.putAll(this.basicGetOptions());
        return result;
    }

    @Override
    public <T> void setOption(Option<T> option, T value) {
        this.basicGetOptions().put(option, value);
    }

    @Override
    public <T> void putOptions(Map<? extends Option<T>, ? extends T> options) {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        myOptions.clear();
        myOptions.putAll(options);
    }

    @Override
    public <T> T removeOption(Option<T> option) {
        T result = this.getValue(option);
        this.basicGetOptions().remove(option);
        return result;
    }

    @Override
    public <T> Map<Option<T>, T> removeOptions(Collection<Option<T>> options) {
        HashMap<Option<T>, T> result = new HashMap<Option<T>, T>();
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        for (Option<T> next : options) {
            result.put(next, this.getValue(next));
            myOptions.remove(next);
        }
        return result;
    }

    @Override
    public Map<Option<?>, Object> clearOptions() {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        HashMap result = new HashMap(myOptions);
        myOptions.clear();
        return result;
    }

    @Override
    public boolean isEnabled(Option<Boolean> option) {
        Boolean result = this.getValue(option);
        return result == null ? false : result;
    }

    @Override
    public <T> T getValue(Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result == null) {
            result = this.getParent() != null ? this.getParent().getValue(option) : option.getDefaultValue();
        }
        return (T)result;
    }
}

