/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.AbstractEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLDebugOptions;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.ObjectUtil;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.helper.OCLHelper;
import org.eclipse.ocl.examples.pivot.helper.OCLHelperImpl;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.PivotPlugin;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCL {
    private final EnvironmentFactory environmentFactory;
    private final Environment rootEnvironment;
    private EvaluationEnvironment evalEnv;
    private DomainModelManager modelManager;
    private List<Constraint> constraints = new ArrayList<Constraint>();
    private Diagnostic problems;
    private Diagnostic evaluationProblems;
    private int parserRepairCount = 0;
    private boolean traceParsing = PivotPlugin.shouldTrace(OCLDebugOptions.PARSING);
    private boolean traceEvaluation = PivotPlugin.shouldTrace(OCLDebugOptions.EVALUATION);

    public static String initialize(ResourceSet resourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet != null ? resourceSet.getResourceFactoryRegistry() : Resource.Factory.Registry.INSTANCE;
        resourceFactoryRegistry.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        return null;
    }

    public static OCL newInstance() {
        return OCL.newInstance(PivotEnvironmentFactory.getGlobalRegistryInstance());
    }

    public static OCL newInstance(EnvironmentFactory envFactory) {
        return new OCL(envFactory, envFactory.createEnvironment());
    }

    public static OCL newInstance(EnvironmentFactory envFactory, Resource resource) {
        return new OCL(envFactory, envFactory.loadEnvironment(resource));
    }

    public static OCL newInstance(Environment env) {
        return new OCL(env.getFactory(), env);
    }

    protected OCL(EnvironmentFactory envFactory, Environment rootEnv) {
        this.environmentFactory = envFactory;
        this.rootEnvironment = rootEnv;
        if (envFactory instanceof AbstractEnvironmentFactory) {
            AbstractEnvironmentFactory abstractFactory = (AbstractEnvironmentFactory)envFactory;
            abstractFactory.setEvaluationTracingEnabled(this.traceEvaluation);
        }
    }

    public boolean check(Object context, Constraint constraint) {
        ExpressionInOCL specification = (ExpressionInOCL)constraint.getSpecification();
        return this.check(context, specification);
    }

    public boolean check(Object context, ExpressionInOCL specification) {
        DomainStandardLibrary stdlib = this.getEnvironment().getOCLStandardLibrary();
        if (specification.getBodyExpression().getType() != stdlib.getBooleanType()) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        try {
            Value result = this.evaluate(context, specification);
            return result.isTrue();
        }
        catch (InvalidEvaluationException e) {
            return false;
        }
    }

    public OCLHelper createOCLHelper() {
        return new OCLHelperImpl(this);
    }

    public OCLHelper createOCLHelper(EObject element) {
        OCLHelperImpl helper = new OCLHelperImpl(this);
        if (element instanceof Type) {
            helper.setContext((Type)element);
        } else if (element instanceof Operation) {
            Operation operation = (Operation)element;
            helper.setOperationContext(operation.getOwningType(), operation);
        } else if (element instanceof Property) {
            Property property = (Property)element;
            helper.setPropertyContext(property.getOwningType(), property);
        } else if (element instanceof EClassifier) {
            helper.setContext((EClassifier)element);
        } else if (element instanceof EOperation) {
            EOperation operation = (EOperation)element;
            helper.setOperationContext((EClassifier)operation.getEContainingClass(), operation);
        } else if (element instanceof EStructuralFeature) {
            EStructuralFeature property = (EStructuralFeature)element;
            helper.setPropertyContext((EClassifier)property.getEContainingClass(), property);
        }
        return helper;
    }

    public Query createQuery(ExpressionInOCL specification) {
        return new QueryImpl(this, specification);
    }

    public Query createQuery(Constraint constraint) {
        return new QueryImpl(this, (ExpressionInOCL)constraint.getSpecification());
    }

    public Resource cs2pivot(BaseResource csResource) {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        Resource pivotResource = csResource.getPivotResource(metaModelManager);
        return pivotResource;
    }

    public void dispose() {
        for (Constraint constraint : this.getConstraints()) {
            Constraint eObject = constraint;
            if (eObject.eResource() != null) continue;
            ObjectUtil.dispose(constraint);
        }
        this.getConstraints().clear();
        if (this.getEnvironment() instanceof Environment.Internal) {
            Environment.Internal env = (Environment.Internal)this.getEnvironment();
            env.dispose();
        }
        this.getMetaModelManager().dispose();
    }

    public Resource ecore2pivot(Resource ecoreResource) {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(ecoreResource, metaModelManager);
        Package pivotRoot = ecore2Pivot.getPivotRoot();
        Resource pivotResource = pivotRoot.eResource();
        return pivotResource;
    }

    public Value evaluate(Object context, ExpressionInOCL expression) {
        Value result;
        this.evaluationProblems = null;
        EvaluationEnvironment localEvalEnv = this.getEvaluationEnvironment();
        ValueFactory valueFactory = localEvalEnv.getValueFactory();
        Value value = valueFactory.valueOf(context);
        localEvalEnv.add(expression.getContextVariable(), value);
        DomainModelManager extents = this.getModelManager();
        if (extents == null) {
            extents = localEvalEnv.createModelManager(context);
        }
        EvaluationVisitor ev = this.environmentFactory.createEvaluationVisitor(this.rootEnvironment, localEvalEnv, extents);
        try {
            try {
                result = (Value)expression.accept(ev);
            }
            catch (EvaluationHaltedException e) {
                this.evaluationProblems = e.getDiagnostic();
                throw e;
            }
        }
        finally {
            localEvalEnv.remove(expression.getContextVariable());
        }
        if (result == null) {
            return localEvalEnv.throwInvalidEvaluation("Java-Null value");
        }
        if (result.isInvalid()) {
            return localEvalEnv.throwInvalidEvaluation("Invalid Value");
        }
        return result;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public Environment getEnvironment() {
        return this.rootEnvironment;
    }

    public EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public EvaluationEnvironment getEvaluationEnvironment() {
        if (this.evalEnv == null) {
            this.evalEnv = this.environmentFactory.createEvaluationEnvironment();
        }
        return this.evalEnv;
    }

    public Diagnostic getEvaluationProblems() {
        return this.evaluationProblems;
    }

    public MetaModelManager getMetaModelManager() {
        return this.rootEnvironment.getMetaModelManager();
    }

    public DomainModelManager getModelManager() {
        return this.modelManager;
    }

    public int getParserRepairCount() {
        return this.parserRepairCount;
    }

    public Diagnostic getProblems() {
        return this.problems;
    }

    public ExpressionInOCL getSpecification(Constraint constraint) throws ParserException {
        ValueSpecification specification = constraint.getSpecification();
        ExpressionInOCL expressionInOCL = null;
        if (specification instanceof ExpressionInOCL) {
            expressionInOCL = (ExpressionInOCL)specification;
        } else if (specification instanceof OpaqueExpression) {
            OpaqueExpression opaqueExpression = (OpaqueExpression)specification;
            String expression = PivotUtil.getBody(opaqueExpression);
            Element constrainedElement = (Element)constraint.getConstrainedElement().get(0);
            OCLHelper helper = this.createOCLHelper(constrainedElement);
            expressionInOCL = helper.createInvariant(expression);
        }
        return expressionInOCL;
    }

    public ValueFactory getValueFactory() {
        return this.getMetaModelManager().getValueFactory();
    }

    public boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    public boolean isParseTracingEnabled() {
        return this.traceParsing;
    }

    public BaseResource load(URI uri) {
        ResourceSet externalResourceSet = this.getMetaModelManager().getExternalResourceSet();
        return (BaseResource)externalResourceSet.getResource(uri, true);
    }

    public Resource parse(URI uri) {
        BaseResource csResource = this.load(uri);
        return this.cs2pivot(csResource);
    }

    public void pivot2cs(Resource pivotResource, BaseResource csResource) {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        csResource.updateFrom(pivotResource, metaModelManager);
    }

    public Resource pivot2ecore(Resource pivotResource, URI uri) throws IOException {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        XMLResource ecoreResource = Pivot2Ecore.createResource(metaModelManager, pivotResource, uri, null);
        return ecoreResource;
    }

    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
        if (this.environmentFactory instanceof AbstractEnvironmentFactory) {
            AbstractEnvironmentFactory abstractFactory = (AbstractEnvironmentFactory)this.environmentFactory;
            abstractFactory.setEvaluationTracingEnabled(this.traceEvaluation);
        }
    }

    public void setModelManager(DomainModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public void setParserRepairCount(int parserRepairCount) {
        if (parserRepairCount < 0) {
            throw new IllegalArgumentException("negative repair count");
        }
        this.parserRepairCount = parserRepairCount;
    }

    public void setParseTracingEnabled(boolean b) {
        this.traceParsing = b;
    }

    public void validate(OCLExpression expression) throws SemanticException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".validate");
    }

    public void validate(Constraint constraint) throws SemanticException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".validate");
    }
}

