/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.ocl.common.delegate.DelegateResourceSetAdapter;
import org.eclipse.ocl.common.delegate.VirtualDelegateMapping;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.delegate.DelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.DelegateResourceAdapter;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomainFactory;
import org.eclipse.ocl.examples.pivot.delegate.OCLInvocationDelegateFactory;
import org.eclipse.ocl.examples.pivot.delegate.OCLQueryDelegateFactory;
import org.eclipse.ocl.examples.pivot.delegate.OCLSettingDelegateFactory;
import org.eclipse.ocl.examples.pivot.delegate.OCLValidationDelegateFactory;
import org.eclipse.ocl.examples.pivot.delegate.ValidationDelegate;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerListener;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLDelegateDomain
implements DelegateDomain,
MetaModelManagerListener {
    public static final String OCL_DELEGATE_URI_PIVOT = "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot";
    protected final String uri;
    protected final EPackage ePackage;
    protected OCL ocl = null;

    public static void initialize(ResourceSet resourceSet) {
        OCLDelegateDomain.initialize(resourceSet, OCL_DELEGATE_URI_PIVOT);
    }

    public static void initialize(ResourceSet resourceSet, String oclDelegateURI) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLInvocationDelegateFactory.Global());
            EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLSettingDelegateFactory.Global());
            EValidator.ValidationDelegate.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLValidationDelegateFactory.Global());
            QueryDelegate.Factory.Registry.INSTANCE.put((Object)oclDelegateURI, (Object)new OCLQueryDelegateFactory.Global());
        }
        if (resourceSet != null) {
            DelegateResourceSetAdapter adapter = DelegateResourceSetAdapter.getAdapter((ResourceSet)resourceSet);
            VirtualDelegateMapping delegationMode = CommonOptions.DEFAULT_DELEGATION_MODE;
            adapter.putRegistry(VirtualDelegateMapping.class, (Object)new VirtualDelegateMapping(delegationMode.getPluginId(), delegationMode.getKey(), (String)delegationMode.getDefaultValue()));
            DelegateDomain.Factory.Registry.Impl delegateDomainFactory = new DelegateDomain.Factory.Registry.Impl();
            delegateDomainFactory.put(oclDelegateURI, new OCLDelegateDomainFactory());
            adapter.putRegistry(DelegateDomain.Factory.Registry.class, (Object)delegateDomainFactory);
            ValidationDelegate.Factory.Registry.Impl validationDelegateFactoryRegistry = new ValidationDelegate.Factory.Registry.Impl();
            validationDelegateFactoryRegistry.put(oclDelegateURI, new OCLValidationDelegateFactory(oclDelegateURI));
            adapter.putRegistry(ValidationDelegate.Factory.Registry.class, (Object)validationDelegateFactoryRegistry);
            EStructuralFeature.Internal.SettingDelegate.Factory.Registry.Impl settingDelegateFactoryRegistry = new EStructuralFeature.Internal.SettingDelegate.Factory.Registry.Impl();
            settingDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLSettingDelegateFactory(oclDelegateURI));
            adapter.putRegistry(EStructuralFeature.Internal.SettingDelegate.Factory.Registry.class, (Object)settingDelegateFactoryRegistry);
            EOperation.Internal.InvocationDelegate.Factory.Registry.Impl invocationDelegateFactoryRegistry = new EOperation.Internal.InvocationDelegate.Factory.Registry.Impl();
            invocationDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLInvocationDelegateFactory(oclDelegateURI));
            adapter.putRegistry(EOperation.Internal.InvocationDelegate.Factory.Registry.class, (Object)invocationDelegateFactoryRegistry);
            QueryDelegate.Factory.Registry.Impl queryDelegateFactoryRegistry = new QueryDelegate.Factory.Registry.Impl();
            queryDelegateFactoryRegistry.put((Object)oclDelegateURI, (Object)new OCLQueryDelegateFactory(oclDelegateURI));
            adapter.putRegistry(QueryDelegate.Factory.Registry.class, (Object)queryDelegateFactoryRegistry);
        }
    }

    public OCLDelegateDomain(String delegateURI, EPackage ePackage) {
        this.uri = delegateURI;
        this.ePackage = ePackage;
    }

    private PivotEnvironmentFactory getEnvironmentFactory() {
        Resource res = this.ePackage.eResource();
        PivotEnvironmentFactory envFactory = null;
        if (res != null) {
            MetaModelManager metaModelManager = null;
            ResourceSet resourceSet = res.getResourceSet();
            if (resourceSet != null) {
                MetaModelManagerResourceSetAdapter rsAdapter = MetaModelManagerResourceSetAdapter.findAdapter(resourceSet);
                if (rsAdapter != null) {
                    metaModelManager = rsAdapter.getMetaModelManager();
                }
                EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                envFactory = new PivotEnvironmentFactory(packageRegistry, metaModelManager);
                DelegateResourceAdapter.getAdapter(res);
            }
        }
        if (envFactory == null) {
            envFactory = PivotEnvironmentFactory.getGlobalRegistryInstance();
        }
        return envFactory;
    }

    public final MetaModelManager getMetaModelManager() {
        return this.getOCL().getMetaModelManager();
    }

    public OCL getOCL() {
        if (this.ocl == null) {
            this.ocl = OCL.newInstance(this.getEnvironmentFactory());
            this.ocl.getMetaModelManager().addListener(this);
        }
        return this.ocl;
    }

    public <T extends Element> T getPivot(Class<T> requiredClass, EObject eObject) {
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(eObject.eResource(), this.getOCL().getMetaModelManager());
        return ecore2Pivot.getCreated(requiredClass, eObject);
    }

    @Override
    public final String getURI() {
        return this.uri;
    }

    @Override
    public void metaModelManagerDisposed(MetaModelManager metaModelManager) {
        this.reset();
    }

    @Override
    public void reset() {
        if (this.ocl != null) {
            this.ocl.dispose();
            this.ocl = null;
        }
    }

    public String toString() {
        return String.valueOf(this.ePackage.getName()) + " : " + this.getURI();
    }
}

