/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.domain.evaluation.DomainException;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.SettingBehavior;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.osgi.util.NLS;

public class OCLSettingDelegate
extends BasicSettingDelegate.Stateless {
    protected final OCLDelegateDomain delegateDomain;
    private Property property;
    private ExpressionInOCL specification;

    public OCLSettingDelegate(OCLDelegateDomain delegateDomain, EStructuralFeature structuralFeature) {
        super(structuralFeature);
        this.delegateDomain = delegateDomain;
    }

    protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
        OCL ocl = this.delegateDomain.getOCL();
        MetaModelManager metaModelManager = ocl.getEnvironment().getMetaModelManager();
        if (this.specification == null) {
            Property property = this.getProperty();
            this.specification = SettingBehavior.INSTANCE.getExpressionInOCL(metaModelManager, property);
            SettingBehavior.INSTANCE.validate(property);
        }
        Query query = ocl.createQuery(this.specification);
        try {
            Value result = query.evaluate(owner);
            return result.asEcoreObject();
        }
        catch (DomainException e) {
            String message = NLS.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object)this.property);
            throw new OCLDelegateException(message, (Exception)((Object)e));
        }
    }

    public Property getProperty() {
        if (this.property == null) {
            this.property = this.delegateDomain.getPivot(Property.class, (EObject)this.eStructuralFeature);
        }
        return this.property;
    }

    protected boolean isSet(InternalEObject owner) {
        return false;
    }

    public String toString() {
        if (this.property != null) {
            return "<" + this.delegateDomain.getURI() + ":setting> " + this.property;
        }
        String name = String.valueOf(this.eStructuralFeature.getEContainingClass().getEPackage().getName()) + "::" + this.eStructuralFeature.getEContainingClass().getName() + "." + this.eStructuralFeature.getName();
        return "<" + this.delegateDomain.getURI() + ":setting> " + name;
    }
}

