/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public class PivotInstaller {
    public static void installDelegates(MetaModelManager metaModelManager, Package pivotPackage) {
        boolean hasDelegates = false;
        for (Type aType : metaModelManager.getLocalClasses(pivotPackage)) {
            if (!PivotInstaller.installDelegates(metaModelManager, aType)) continue;
            hasDelegates = true;
        }
        Package primaryPackage = metaModelManager.getPrimaryPackage(pivotPackage);
        EObject eTarget = primaryPackage.getETarget();
        if (eTarget instanceof EPackage && hasDelegates) {
            Pivot2Ecore.installDelegates((EPackage)eTarget);
        }
        for (Package nestedPackage : metaModelManager.getLocalPackages(pivotPackage)) {
            PivotInstaller.installDelegates(metaModelManager, nestedPackage);
        }
    }

    private static boolean installDelegates(MetaModelManager metaModelManager, Type pivotType) {
        boolean hasDelegates = false;
        Type primaryType = metaModelManager.getPrimaryType(pivotType);
        EObject eTarget = primaryType.getETarget();
        if (eTarget instanceof EClassifier) {
            EClassifier eClassifier = (EClassifier)eTarget;
            for (Constraint constraint : metaModelManager.getLocalConstraints(pivotType)) {
                EClassifier eContext;
                if (constraint.isCallable()) {
                    String name = constraint.getName();
                    eContext = null;
                    for (EOperation candidate : ((EClass)eClassifier).getEOperations()) {
                        if (!name.equals(candidate.getName()) || !EcoreUtil.isInvariant((EOperation)candidate)) continue;
                        eContext = candidate;
                        break;
                    }
                    if (eContext == null) {
                        EOperation eOperation = Pivot2Ecore.createConstraintEOperation(constraint, name);
                        ((EClass)eClassifier).getEOperations().add((Object)eOperation);
                        eContext = eOperation;
                    }
                } else {
                    eContext = eClassifier;
                }
                if (!Pivot2Ecore.installDelegate((EModelElement)eContext, constraint, null)) continue;
                hasDelegates = true;
            }
            for (Operation anOperation : metaModelManager.getLocalOperations(pivotType, null)) {
                EOperation eOperation = (EOperation)anOperation.getETarget();
                if (eOperation == null) continue;
                Pivot2Ecore.installDelegate(metaModelManager, eOperation);
            }
            for (Property aProperty : metaModelManager.getLocalProperties(pivotType, null)) {
                EStructuralFeature eFeature = (EStructuralFeature)aProperty.getETarget();
                if (eFeature == null) continue;
                Pivot2Ecore.installDelegate(metaModelManager, eFeature);
            }
            for (EAnnotation eAnnotation : eClassifier.getEAnnotations()) {
                TreeIterator tit = eAnnotation.eAllContents();
                while (tit.hasNext()) {
                    EAnnotation nestedAnnotation;
                    EObject eObject = (EObject)tit.next();
                    if (!(eObject instanceof EAnnotation) || !"http://www.eclipse.org/uml2/1.1.0/GenModel".equals((nestedAnnotation = (EAnnotation)eObject).getSource())) continue;
                    nestedAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
                }
            }
            if (hasDelegates) {
                Pivot2Ecore.installDelegates(metaModelManager, eClassifier, pivotType);
            }
        }
        return hasDelegates;
    }
}

