/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.common.delegate.DelegateResourceSetAdapter;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.context.PropertyContext;
import org.eclipse.ocl.examples.pivot.delegate.AbstractDelegatedBehavior;
import org.eclipse.ocl.examples.pivot.delegate.DelegateDomain;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingBehavior
extends AbstractDelegatedBehavior<EStructuralFeature, EStructuralFeature.Internal.SettingDelegate.Factory.Registry, EStructuralFeature.Internal.SettingDelegate.Factory> {
    public static final SettingBehavior INSTANCE = new SettingBehavior();
    public static final String DERIVATION_CONSTRAINT_KEY = "derivation";
    public static final String INITIAL_CONSTRAINT_KEY = "initial";
    public static final String NAME = "settingDelegates";

    @Override
    public EStructuralFeature.Internal.SettingDelegate.Factory getDefaultFactory() {
        return EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.getFactory(this.getName());
    }

    @Override
    public EStructuralFeature.Internal.SettingDelegate.Factory.Registry getDefaultRegistry() {
        return EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE;
    }

    @Override
    public EPackage getEPackage(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.getEContainingClass().getEPackage();
    }

    public ExpressionInOCL getExpressionInOCL(MetaModelManager metaModelManager, Property property) throws OCLDelegateException {
        Constraint constraint = this.getConstraintForStereotype(property, DERIVATION_CONSTRAINT_KEY);
        if (constraint == null) {
            constraint = this.getConstraintForStereotype(property, INITIAL_CONSTRAINT_KEY);
        }
        if (constraint != null) {
            ValueSpecification valueSpecification = constraint.getSpecification();
            if (valueSpecification instanceof ExpressionInOCL) {
                return (ExpressionInOCL)valueSpecification;
            }
            URI uri = metaModelManager.getResourceIdentifier(constraint, "body");
            PropertyContext propertyContext = new PropertyContext(metaModelManager, uri, property);
            ExpressionInOCL expressionInOCL = this.getExpressionInOCL(propertyContext, constraint);
            if (expressionInOCL != null) {
                return expressionInOCL;
            }
        }
        String message = NLS.bind((String)OCLMessages.MissingDerivationForSettingDelegate_ERROR_, (Object)property);
        throw new OCLDelegateException(message);
    }

    @Override
    public EStructuralFeature.Internal.SettingDelegate.Factory getFactory(DelegateDomain delegateDomain, EStructuralFeature eStructuralFeature) {
        EStructuralFeature.Internal.SettingDelegate.Factory.Registry registry = (EStructuralFeature.Internal.SettingDelegate.Factory.Registry)DelegateResourceSetAdapter.getRegistry((EModelElement)eStructuralFeature, this.getRegistryClass(), (Object)this.getDefaultRegistry());
        return registry.getFactory(delegateDomain.getURI());
    }

    @Override
    public Class<EStructuralFeature.Internal.SettingDelegate.Factory> getFactoryClass() {
        return EStructuralFeature.Internal.SettingDelegate.Factory.class;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<EStructuralFeature.Internal.SettingDelegate.Factory.Registry> getRegistryClass() {
        return EStructuralFeature.Internal.SettingDelegate.Factory.Registry.class;
    }
}

