/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluationEnvironment;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractOperation;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryTernaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryUnaryOperation;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.OperationContext;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class EObjectOperation
extends AbstractOperation
implements LibraryUnaryOperation,
LibraryBinaryOperation,
LibraryTernaryOperation {
    protected final EOperation eFeature;
    protected ValueSpecification specification;
    private ExpressionInOCL expressionInOCL = null;

    public EObjectOperation(EOperation eFeature, ValueSpecification specification) {
        this.eFeature = eFeature;
        this.specification = specification;
    }

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue) throws InvalidValueException {
        DomainEvaluator nestedEvaluator = evaluator.createNestedEvaluator();
        DomainEvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)this.expressionInOCL.getContextVariable(), sourceValue);
        return nestedEvaluator.evaluate((DomainExpression)this.expressionInOCL.getBodyExpression());
    }

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue, Value argumentValue) throws InvalidValueException {
        DomainEvaluator nestedEvaluator = evaluator.createNestedEvaluator();
        DomainEvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)this.expressionInOCL.getContextVariable(), sourceValue);
        EList<Variable> parameterVariables = this.expressionInOCL.getParameterVariable();
        nestedEvaluationEnvironment.add((DomainTypedElement)((Variable)parameterVariables.get(0)).getRepresentedParameter(), argumentValue);
        return nestedEvaluator.evaluate((DomainExpression)this.expressionInOCL.getBodyExpression());
    }

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue, Value firstArgumentValue, Value secondArgumentValue) throws InvalidValueException {
        DomainEvaluator nestedEvaluator = evaluator.createNestedEvaluator();
        DomainEvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)this.expressionInOCL.getContextVariable(), sourceValue);
        EList<Variable> parameterVariables = this.expressionInOCL.getParameterVariable();
        nestedEvaluationEnvironment.add((DomainTypedElement)((Variable)parameterVariables.get(0)).getRepresentedParameter(), firstArgumentValue);
        nestedEvaluationEnvironment.add((DomainTypedElement)((Variable)parameterVariables.get(1)).getRepresentedParameter(), secondArgumentValue);
        return nestedEvaluator.evaluate((DomainExpression)this.expressionInOCL.getBodyExpression());
    }

    public Value evaluate(DomainEvaluator evaluator, DomainCallExp callExp, Value sourceValue, Value ... argumentValues) throws InvalidValueException {
        if (this.expressionInOCL == null) {
            this.resolveExpressionInOCL(evaluator, callExp, sourceValue);
        }
        DomainEvaluator nestedEvaluator = evaluator.createNestedEvaluator();
        DomainEvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add((DomainTypedElement)this.expressionInOCL.getContextVariable(), sourceValue);
        EList<Variable> parameterVariables = this.expressionInOCL.getParameterVariable();
        int iMax = Math.min(parameterVariables.size(), argumentValues.length);
        int i = 0;
        while (i < iMax) {
            nestedEvaluationEnvironment.add((DomainTypedElement)((Variable)parameterVariables.get(i)).getRepresentedParameter(), argumentValues[i]);
            ++i;
        }
        return nestedEvaluator.evaluate((DomainExpression)this.expressionInOCL.getBodyExpression());
    }

    protected void resolveExpressionInOCL(DomainEvaluator evaluator, DomainCallExp callExp, Value sourceValue) {
        if (this.specification instanceof ExpressionInOCL) {
            this.expressionInOCL = (ExpressionInOCL)this.specification;
        } else {
            Operation operation;
            if (this.specification instanceof OpaqueExpression) {
                operation = ((OperationCallExp)callExp).getReferredOperation();
                String string = PivotUtil.getBody((OpaqueExpression)this.specification);
                EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
                MetaModelManager metaModelManager = evaluationVisitor.getMetaModelManager();
                URI uri = metaModelManager.getResourceIdentifier(operation, null);
                try {
                    OperationContext operationContext = new OperationContext(metaModelManager, uri, operation, null);
                    this.expressionInOCL = operationContext.parse(string);
                }
                catch (ParserException e) {
                    evaluator.throwInvalidEvaluation((Throwable)e, (DomainExpression)callExp, (Object)sourceValue, "parse failure", new Object[0]);
                }
            }
            if (this.expressionInOCL == null) {
                operation = ((OperationCallExp)callExp).getReferredOperation();
                evaluator.throwInvalidEvaluation(null, (DomainExpression)callExp, (Object)sourceValue, "No specification for '" + operation + "'", new Object[0]);
            }
        }
    }
}

