/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.ecore.EObjectOperation;
import org.eclipse.ocl.examples.pivot.ecore.EObjectProperty;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.AliasAdapter;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ecore2PivotDeclarationSwitch
extends EcoreSwitch<Object> {
    protected final Ecore2Pivot converter;

    public Ecore2PivotDeclarationSwitch(Ecore2Pivot converter) {
        this.converter = converter;
    }

    public Annotation caseEAnnotation(EAnnotation eObject) {
        String source = eObject.getSource();
        EMap details = eObject.getDetails();
        Annotation pivotElement = PivotFactory.eINSTANCE.createAnnotation();
        pivotElement.setName(source);
        this.converter.addMapping((EObject)eObject, pivotElement);
        this.doSwitchAll((Collection)pivotElement.getOwnedContent(), (List<? extends EObject>)eObject.getContents());
        for (Map.Entry entry : details) {
            String key = (String)entry.getKey();
            if (key.equals("documentation") && "http://www.eclipse.org/emf/2002/GenModel".equals(source)) continue;
            Detail pivotDetail = PivotFactory.eINSTANCE.createDetail();
            pivotDetail.setName(key);
            pivotDetail.getValue().add((Object)((String)entry.getValue()));
            pivotElement.getOwnedDetail().add((Object)pivotDetail);
        }
        if (!eObject.getReferences().isEmpty()) {
            this.converter.queueReference((EModelElement)eObject);
        }
        return pivotElement;
    }

    public Property caseEAttribute(EAttribute eObject) {
        Property pivotElement = this.converter.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (ENamedElement)eObject);
        this.copyStructuralFeature(pivotElement, (EStructuralFeature)eObject, null);
        pivotElement.setIsID(eObject.isID());
        return pivotElement;
    }

    public Class caseEClass(EClass eObject) {
        Class pivotElement = this.converter.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, (ENamedElement)eObject);
        this.copyClassifier(pivotElement, (EClassifier)eObject);
        pivotElement.setIsAbstract(eObject.isAbstract());
        pivotElement.setIsInterface(eObject.isInterface());
        this.doSwitchAll((List<? extends EObject>)eObject.getEGenericSuperTypes());
        EList<Operation> pivotOperations = pivotElement.getOwnedOperation();
        EList<Constraint> pivotConstraints = pivotElement.getOwnedRule();
        for (EOperation eOperation : eObject.getEOperations()) {
            if (EcoreUtil.isInvariant((EOperation)eOperation)) {
                EAnnotation eAnnotation;
                Constraint constraint = PivotFactory.eINSTANCE.createConstraint();
                constraint.setStereotype("invariant");
                constraint.setName(eOperation.getName());
                constraint.setIsCallable(true);
                String value = null;
                String commentBody = EcoreUtil.getAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"documentation");
                if (commentBody != null) {
                    Comment pivotComment = PivotFactory.eINSTANCE.createComment();
                    pivotComment.setBody(commentBody.replaceAll("\\r", ""));
                    constraint.getOwnedComment().add((Object)pivotComment);
                }
                if ((eAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation)) == null) {
                    eAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/2.2.0/GenModel");
                }
                if (eAnnotation == null) {
                    eAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
                }
                if (eAnnotation != null) {
                    value = (String)eAnnotation.getDetails().get((Object)"body");
                }
                OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                specification.getBody().add((Object)value);
                specification.getLanguage().add((Object)"OCL");
                constraint.setSpecification(specification);
                pivotConstraints.add(constraint);
                this.converter.addMapping((EObject)eOperation, constraint);
                continue;
            }
            Object pivotObject = this.doSwitch((EObject)eOperation);
            pivotOperations.add((Operation)pivotObject);
        }
        this.doSwitchAll((Collection)pivotElement.getOwnedAttribute(), (List<? extends EObject>)eObject.getEStructuralFeatures());
        this.converter.queueReference((EModelElement)eObject);
        return pivotElement;
    }

    public DataType caseEDataType(EDataType eObject) {
        DataType pivotElement = this.converter.refreshNamedElement(DataType.class, PivotPackage.Literals.DATA_TYPE, (ENamedElement)eObject);
        this.copyDataTypeOrEnum(pivotElement, eObject);
        java.lang.Class instanceClass = eObject.getInstanceClass();
        if (instanceClass != null) {
            try {
                MetaModelManager metaModelManager = this.converter.getMetaModelManager();
                if (instanceClass == Boolean.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getBooleanType());
                } else if (instanceClass == Byte.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Character.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Double.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == Float.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == Integer.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Long.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Short.TYPE) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == BigDecimal.class) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == BigInteger.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Boolean.class) {
                    pivotElement.setBehavioralType(metaModelManager.getBooleanType());
                } else if (instanceClass == Byte.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Character.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Double.class) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == Float.class) {
                    pivotElement.setBehavioralType(metaModelManager.getRealType());
                } else if (instanceClass == Integer.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Long.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == Short.class) {
                    pivotElement.setBehavioralType(metaModelManager.getIntegerType());
                } else if (instanceClass == String.class) {
                    pivotElement.setBehavioralType(metaModelManager.getStringType());
                } else {
                    instanceClass.getDeclaredMethod("compareTo", instanceClass);
                    this.converter.queueReference((EModelElement)eObject);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pivotElement;
    }

    public Enumeration caseEEnum(EEnum eObject) {
        Enumeration pivotElement = this.converter.refreshNamedElement(Enumeration.class, PivotPackage.Literals.ENUMERATION, (ENamedElement)eObject);
        this.copyDataTypeOrEnum(pivotElement, (EDataType)eObject);
        this.doSwitchAll((Collection)pivotElement.getOwnedLiteral(), (List<? extends EObject>)eObject.getELiterals());
        return pivotElement;
    }

    public EnumerationLiteral caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
        EnumerationLiteral pivotElement = this.converter.refreshNamedElement(EnumerationLiteral.class, PivotPackage.Literals.ENUMERATION_LITERAL, (ENamedElement)eEnumLiteral);
        this.copyNamedElement(pivotElement, (ENamedElement)eEnumLiteral);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eEnumLiteral, null);
        if (eEnumLiteral.eIsSet((EStructuralFeature)EcorePackage.Literals.EENUM_LITERAL__VALUE)) {
            pivotElement.setValue(BigInteger.valueOf(eEnumLiteral.getValue()));
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.ENUMERATION_LITERAL__VALUE);
        }
        return pivotElement;
    }

    public Object caseEGenericType(EGenericType eObject) {
        this.doSwitchAll((List<? extends EObject>)eObject.getETypeArguments());
        this.converter.addGenericType(eObject);
        return true;
    }

    public Operation caseEOperation(EOperation eObject) {
        Operation pivotElement = this.converter.refreshNamedElement(Operation.class, PivotPackage.Literals.OPERATION, (ENamedElement)eObject);
        ArrayList<EAnnotation> excludedAnnotations = null;
        EAnnotation oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eObject);
        if (oclAnnotation == null) {
            oclAnnotation = eObject.getEAnnotation("http://www.eclipse.org/uml2/2.2.0/GenModel");
        }
        if (oclAnnotation == null) {
            oclAnnotation = eObject.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        }
        if (oclAnnotation != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oclAnnotation);
            EList<Constraint> constraints = pivotElement.getOwnedRule();
            for (Map.Entry entry : oclAnnotation.getDetails().entrySet()) {
                Constraint constraint = PivotFactory.eINSTANCE.createConstraint();
                String key = (String)entry.getKey();
                if (key.equals("body")) {
                    constraint.setStereotype("body");
                } else if (key.startsWith("body_")) {
                    constraint.setStereotype("body");
                    constraint.setName(key.substring(5));
                } else if (key.equals("pre")) {
                    constraint.setStereotype("precondition");
                } else if (key.startsWith("pre_")) {
                    constraint.setStereotype("precondition");
                    constraint.setName(key.substring(4));
                } else if (key.equals("post")) {
                    constraint.setStereotype("postcondition");
                } else if (key.startsWith("post_")) {
                    constraint.setStereotype("postcondition");
                    constraint.setName(key.substring(5));
                } else {
                    this.converter.error("Unsupported operation constraint " + key);
                    constraint = null;
                }
                if (constraint == null) continue;
                String value = (String)entry.getValue();
                OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                specification.getBody().add((Object)value);
                specification.getLanguage().add((Object)"OCL");
                constraint.setSpecification(specification);
                constraints.add(constraint);
                pivotElement.setImplementation((LibraryFeature)new EObjectOperation(eObject, specification));
            }
        }
        this.copyTypedMultiplicityElement(pivotElement, (ETypedElement)eObject, excludedAnnotations);
        this.doSwitchAll((Collection)pivotElement.getOwnedParameter(), (List<? extends EObject>)eObject.getEParameters());
        this.copyTemplateSignature(pivotElement, (List<ETypeParameter>)eObject.getETypeParameters());
        this.doSwitchAll((List<? extends EObject>)eObject.getEGenericExceptions());
        this.converter.queueReference((EModelElement)eObject);
        return pivotElement;
    }

    public Package caseEPackage(EPackage eObject) {
        EAnnotation eAnnotation;
        Package pivotElement = this.converter.refreshNamedElement(Package.class, PivotPackage.Literals.PACKAGE, (ENamedElement)eObject);
        if (eObject.eIsSet((EStructuralFeature)EcorePackage.Literals.EPACKAGE__NS_URI)) {
            pivotElement.setNsURI(eObject.getNsURI());
        }
        if (eObject.eIsSet((EStructuralFeature)EcorePackage.Literals.EPACKAGE__NS_PREFIX)) {
            pivotElement.setNsPrefix(eObject.getNsPrefix());
        }
        this.converter.getMetaModelManager().addPackage(pivotElement);
        String moniker = Pivot2Moniker.toString(pivotElement);
        AliasAdapter adapter = AliasAdapter.getAdapter(eObject.eResource());
        if (adapter != null) {
            adapter.getAliasMap().put((EObject)eObject, moniker);
        }
        List<EAnnotation> exclusions = (eAnnotation = eObject.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore")) == null ? Collections.emptyList() : Collections.singletonList(eAnnotation);
        this.copyNamedElement(pivotElement, (ENamedElement)eObject);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eObject, exclusions);
        this.doSwitchAll((Collection)pivotElement.getNestedPackage(), (List<? extends EObject>)eObject.getESubpackages());
        this.doSwitchAll((Collection)pivotElement.getOwnedType(), (List<? extends EObject>)eObject.getEClassifiers());
        return pivotElement;
    }

    public Parameter caseEParameter(EParameter eObject) {
        Parameter pivotElement = this.converter.refreshNamedElement(Parameter.class, PivotPackage.Literals.PARAMETER, (ENamedElement)eObject);
        this.copyTypedMultiplicityElement(pivotElement, (ETypedElement)eObject, null);
        return pivotElement;
    }

    public Property caseEReference(EReference eObject) {
        Property pivotElement = this.converter.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (ENamedElement)eObject);
        ArrayList<Object> excludedAnnotations = null;
        EAnnotation oppositeRole = eObject.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
        if (oppositeRole != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oppositeRole);
        }
        if ((oppositeRole = eObject.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName")) != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList();
            }
            excludedAnnotations.add(oppositeRole);
        }
        this.copyStructuralFeature(pivotElement, (EStructuralFeature)eObject, excludedAnnotations);
        pivotElement.setIsComposite(eObject.isContainment());
        pivotElement.setIsResolveProxies(eObject.isResolveProxies());
        if (eObject.getEOpposite() != null || excludedAnnotations != null || !eObject.getEKeys().isEmpty()) {
            this.converter.queueReference((EModelElement)eObject);
        }
        return pivotElement;
    }

    public Element caseETypeParameter(ETypeParameter eObject) {
        EList eBounds;
        Class pivotElement = this.converter.refreshNamedElement(Class.class, PivotPackage.Literals.CLASS, (ENamedElement)eObject);
        this.converter.addMapping((EObject)eObject, pivotElement);
        String name = eObject.getName();
        pivotElement.setName(name);
        TypeTemplateParameter typeTemplateParameter = (TypeTemplateParameter)pivotElement.getTemplateParameter();
        if (typeTemplateParameter == null) {
            typeTemplateParameter = PivotFactory.eINSTANCE.createTypeTemplateParameter();
            typeTemplateParameter.setOwnedParameteredElement(pivotElement);
        }
        if (!(eBounds = eObject.getEBounds()).isEmpty()) {
            this.doSwitchAll((List<? extends EObject>)eBounds);
            this.converter.queueReference((EModelElement)eObject);
        }
        return typeTemplateParameter;
    }

    protected void copyClassifier(Class pivotElement, EClassifier eClassifier) {
        EAnnotation ecoreAnnotation;
        String constraintName;
        ArrayList<EAnnotation> excludedAnnotations = null;
        EMap oclAnnotationDetails = null;
        HashMap<String, Constraint> constraintMap = null;
        EAnnotation oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
        if (oclAnnotation != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oclAnnotation);
            EList<Constraint> constraints = pivotElement.getOwnedRule();
            oclAnnotationDetails = oclAnnotation.getDetails();
            int iMax = oclAnnotationDetails.size();
            int i = 0;
            while (i < iMax) {
                Map.Entry entry = (Map.Entry)oclAnnotationDetails.get(i);
                constraintName = (String)entry.getKey();
                if (constraintName == null) {
                    constraintName = "";
                }
                if (!constraintName.endsWith("$message")) {
                    Constraint constraint = PivotFactory.eINSTANCE.createConstraint();
                    constraint.setStereotype("invariant");
                    constraint.setName(constraintName);
                    String value = (String)entry.getValue();
                    OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                    specification.getBody().add((Object)value);
                    specification.getLanguage().add((Object)"OCL");
                    String message = (String)oclAnnotationDetails.get((Object)(String.valueOf(constraintName) + "$message"));
                    specification.getMessage().add((Object)(message != null ? message : ""));
                    constraint.setSpecification(specification);
                    constraints.add(constraint);
                    if (constraintMap == null) {
                        constraintMap = new HashMap<String, Constraint>();
                    }
                    constraintMap.put(constraintName, constraint);
                }
                ++i;
            }
        }
        if ((ecoreAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore")) != null) {
            if (excludedAnnotations == null) {
                excludedAnnotations = new ArrayList();
            }
            excludedAnnotations.add(ecoreAnnotation);
            String constraintNameList = (String)ecoreAnnotation.getDetails().get((Object)"constraints");
            if (constraintNameList != null) {
                String[] constraintNames;
                EList<Constraint> constraints = pivotElement.getOwnedRule();
                String[] stringArray = constraintNames = constraintNameList.split(" ");
                int n = constraintNames.length;
                int n2 = 0;
                while (n2 < n) {
                    constraintName = stringArray[n2];
                    if (oclAnnotationDetails == null || oclAnnotationDetails.get((Object)constraintName) == null) {
                        Constraint constraint = null;
                        if (constraintMap != null) {
                            constraint = (Constraint)constraintMap.get(constraintName);
                        }
                        if (constraint == null) {
                            constraint = PivotFactory.eINSTANCE.createConstraint();
                        }
                        constraint.setStereotype("invariant");
                        constraint.setName(constraintName);
                        OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                        constraint.setSpecification(specification);
                        constraints.add(constraint);
                    }
                    ++n2;
                }
            }
        }
        this.copyNamedElement(pivotElement, (ENamedElement)eClassifier);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eClassifier, excludedAnnotations);
        if (eClassifier.eIsSet((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME)) {
            pivotElement.setInstanceClassName(eClassifier.getInstanceClassName());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME);
        }
        this.copyTemplateSignature(pivotElement, (List<ETypeParameter>)eClassifier.getETypeParameters());
    }

    protected void copyDataTypeOrEnum(DataType pivotElement, EDataType eDataType) {
        this.copyClassifier(pivotElement, (EClassifier)eDataType);
        pivotElement.setIsSerializable(eDataType.isSerializable());
    }

    protected void copyTemplateSignature(TemplateableElement pivotElement, List<ETypeParameter> eTypeParameters) {
        if (!eTypeParameters.isEmpty()) {
            TemplateSignature pivotTemplateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
            pivotElement.setOwnedTemplateSignature(pivotTemplateSignature);
            this.doSwitchAll((Collection)pivotTemplateSignature.getOwnedParameter(), (List<? extends EObject>)eTypeParameters);
        }
    }

    protected void copyAnnotatedElement(NamedElement pivotElement, EModelElement eModelElement, List<EAnnotation> excludedAnnotations) {
        EList<Annotation> pivotAnnotations = pivotElement.getOwnedAnnotation();
        for (EAnnotation eAnnotation : eModelElement.getEAnnotations()) {
            if (excludedAnnotations != null && excludedAnnotations.contains(eAnnotation)) continue;
            String source = eAnnotation.getSource();
            EMap details = eAnnotation.getDetails();
            if ("http://www.eclipse.org/emf/2002/GenModel".equals(source) && details.containsKey((Object)"documentation")) {
                Comment pivotComment = PivotFactory.eINSTANCE.createComment();
                pivotComment.setBody((String)details.get((Object)"documentation"));
                pivotElement.getOwnedComment().add((Object)pivotComment);
            }
            if (eAnnotation.getContents().isEmpty() && eAnnotation.getReferences().isEmpty() && details.size() <= 1 && (details.size() != 1 || "http://www.eclipse.org/emf/2002/GenModel".equals(source) && details.containsKey((Object)"documentation"))) continue;
            Annotation pivotAnnotation = (Annotation)this.doSwitch((EObject)eAnnotation);
            pivotAnnotations.add(pivotAnnotation);
        }
    }

    protected void copyNamedElement(NamedElement pivotElement, ENamedElement eNamedElement) {
        this.converter.addMapping((EObject)eNamedElement, pivotElement);
        String name = eNamedElement.getName();
        pivotElement.setName(name);
    }

    protected void copyStructuralFeature(Property pivotElement, EStructuralFeature eObject, List<EAnnotation> excludedAnnotations) {
        EAnnotation oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eObject);
        if (oclAnnotation != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oclAnnotation);
            EList<Constraint> constraints = pivotElement.getOwnedRule();
            for (Map.Entry entry : oclAnnotation.getDetails().entrySet()) {
                Constraint constraint = PivotFactory.eINSTANCE.createConstraint();
                String key = (String)entry.getKey();
                if (key.equals("derivation")) {
                    constraint.setStereotype("derivation");
                } else if (key.equals("initial")) {
                    constraint.setStereotype("initial");
                } else if (key.equals("get")) {
                    constraint.setStereotype("derivation");
                } else {
                    this.converter.error("Unsupported feature constraint " + key);
                    constraint = null;
                }
                if (constraint != null) {
                    String value = (String)entry.getValue();
                    OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                    specification.getBody().add((Object)value);
                    specification.getLanguage().add((Object)"OCL");
                    constraint.setSpecification(specification);
                    constraints.add(constraint);
                    pivotElement.setImplementation((LibraryFeature)new EObjectProperty(eObject, specification));
                    continue;
                }
                pivotElement.setImplementation((LibraryFeature)new EObjectProperty(eObject, null));
            }
        }
        this.copyTypedMultiplicityElement(pivotElement, (ETypedElement)eObject, excludedAnnotations);
        pivotElement.setIsReadOnly(!eObject.isChangeable());
        pivotElement.setIsDerived(eObject.isDerived());
        pivotElement.setIsTransient(eObject.isTransient());
        pivotElement.setIsUnsettable(eObject.isUnsettable());
        pivotElement.setIsVolatile(eObject.isVolatile());
        if (eObject.eIsSet((EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL)) {
            pivotElement.setDefault(eObject.getDefaultValueLiteral());
        } else {
            pivotElement.eUnset((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT);
        }
    }

    protected void copyTypedMultiplicityElement(TypedMultiplicityElement pivotElement, ETypedElement eTypedElement, List<EAnnotation> excludedAnnotations) {
        this.copyNamedElement(pivotElement, (ENamedElement)eTypedElement);
        this.copyAnnotatedElement(pivotElement, (EModelElement)eTypedElement, excludedAnnotations);
        int lower = eTypedElement.getLowerBound();
        int upper = eTypedElement.getUpperBound();
        pivotElement.setLower(BigInteger.valueOf(lower));
        pivotElement.setUpper(BigInteger.valueOf(upper));
        pivotElement.setIsOrdered(eTypedElement.isOrdered());
        pivotElement.setIsUnique(eTypedElement.isUnique());
        EGenericType eGenericType = eTypedElement.getEGenericType();
        if (eGenericType != null) {
            this.doInPackageSwitch((EObject)eGenericType);
            this.converter.queueReference((EModelElement)eTypedElement);
        }
    }

    public Element defaultCase(EObject object) {
        this.converter.error("Unsupported " + object.eClass().getName() + " for Ecore2PivotDeclarationSwitch");
        return null;
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(Collection<T> pivotObjects, List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            Element pivotObject = (Element)this.doSwitch(eObject);
            pivotObjects.add(pivotObject);
        }
    }

    public <T extends Element> void doSwitchAll(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.doSwitch(eObject);
        }
    }
}

