/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvaluationVisitor
extends AbstractExtendingVisitor<Value, Object>
implements EvaluationVisitor {
    private static Set<String> BOOLEAN_CONSTRAINTS = new HashSet<String>();
    protected final EvaluationEnvironment evaluationEnvironment;
    protected final Environment environment;
    protected final MetaModelManager metaModelManager;
    protected final DomainModelManager modelManager;
    protected final ValueFactory valueFactory;
    private EvaluationVisitor undecoratedVisitor;
    private boolean isCanceled = false;

    static {
        BOOLEAN_CONSTRAINTS.add("invariant");
        BOOLEAN_CONSTRAINTS.add("precondition");
        BOOLEAN_CONSTRAINTS.add("postcondition");
    }

    protected AbstractEvaluationVisitor(Environment env, EvaluationEnvironment evalEnv, DomainModelManager modelManager) {
        super(null);
        this.evaluationEnvironment = evalEnv;
        this.environment = env;
        this.metaModelManager = env.getMetaModelManager();
        this.modelManager = modelManager;
        this.valueFactory = evalEnv.getValueFactory();
        this.undecoratedVisitor = this;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public EvaluationEnvironment getEvaluationEnvironment() {
        return this.evaluationEnvironment;
    }

    @Override
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @Override
    public DomainModelManager getModelManager() {
        return this.modelManager;
    }

    @Override
    public DomainStandardLibrary getStandardLibrary() {
        return this.metaModelManager;
    }

    protected EvaluationVisitor getUndecoratedVisitor() {
        return this.undecoratedVisitor;
    }

    @Override
    public ValueFactory getValueFactory() {
        if (this.isCanceled) {
            throw new EvaluationHaltedException("Canceled");
        }
        return this.valueFactory;
    }

    @Deprecated
    protected final EvaluationVisitor getVisitor() {
        return this.undecoratedVisitor;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    @Override
    public void setUndecoratedVisitor(EvaluationVisitor evaluationVisitor) {
        this.undecoratedVisitor = evaluationVisitor;
    }

    @Deprecated
    void setVisitor(EvaluationVisitor visitor) {
        this.setUndecoratedVisitor(visitor);
    }

    @Override
    public NullValue throwInvalidEvaluation(String message) throws InvalidEvaluationException {
        return this.evaluationEnvironment.throwInvalidEvaluation(message);
    }

    @Override
    public NullValue throwInvalidEvaluation(InvalidValueException e) throws InvalidEvaluationException {
        return this.evaluationEnvironment.throwInvalidEvaluation(e);
    }

    @Override
    public NullValue throwInvalidEvaluation(Throwable e, DomainExpression expression, Object value, String message, Object ... bindings) {
        return this.evaluationEnvironment.throwInvalidEvaluation(e, expression, value, message, bindings);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (evaluation environment: ");
        result.append(this.getEvaluationEnvironment());
        result.append(')');
        return result.toString();
    }

    @Override
    public Value visitConstraint(Constraint constraint) {
        ValueSpecification specification = constraint.getSpecification();
        if (!(specification instanceof ExpressionInOCL)) {
            return null;
        }
        OCLExpression body = ((ExpressionInOCL)specification).getBodyExpression();
        boolean isBoolean = BOOLEAN_CONSTRAINTS.contains(constraint.getStereotype());
        if (body == null) {
            throw new IllegalArgumentException("constraint has no body expression");
        }
        if (isBoolean && body.getType() == this.metaModelManager.getBooleanType()) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        Value result = (Value)body.accept(this.getUndecoratedVisitor());
        try {
            return result.asBooleanValue();
        }
        catch (InvalidValueException e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e);
        }
    }
}

