/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.library.executor.LazyModelManager;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public class PivotModelManager
extends LazyModelManager {
    protected final MetaModelManager metaModelManager;
    private Ecore2Pivot ecoreConverter = null;

    public PivotModelManager(MetaModelManager metaModelManager, EObject context) {
        super(context);
        this.metaModelManager = metaModelManager;
    }

    protected boolean isInstance(DomainType requiredType, EObject eObject) {
        Type objectType;
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        if (ePackage == PivotPackage.eINSTANCE) {
            objectType = this.metaModelManager.getPivotType(eClass.getName());
        } else {
            Resource resource = eClass.eResource();
            if (resource != null) {
                Ecore2Pivot ecoreConverter = Ecore2Pivot.getAdapter(resource, this.metaModelManager);
                objectType = ecoreConverter.getPivotType((EObject)eClass);
            } else {
                List<EObject> roots = Collections.singletonList(EcoreUtil.getRootContainer((EObject)eClass));
                this.ecoreConverter = new Ecore2Pivot(null, this.metaModelManager);
                this.ecoreConverter.importObjects(roots, URI.createURI((String)"temp://eval"));
                objectType = this.ecoreConverter.getPivotType((EObject)eClass);
            }
        }
        return objectType.conformsTo((DomainStandardLibrary)this.metaModelManager, requiredType);
    }
}

