/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.executor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.elements.DomainClassifierType;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutableStandardLibrary;
import org.eclipse.ocl.examples.library.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.executor.PivotEcoreExecutorManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManageable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotExecutorStandardLibrary
extends ExecutableStandardLibrary
implements MetaModelManageable {
    protected final MetaModelManager metaModelManager;
    private Map<DomainType, Type> typeMap = null;
    private Map<DomainPackage, Package> packageMap = null;

    public PivotExecutorStandardLibrary(EcoreExecutorPackage ... execPackages) {
        OCLstdlibTables.PACKAGE.getClass();
        this.metaModelManager = new MetaModelManager();
        this.metaModelManager.setDefaultStandardLibraryURI("http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib");
        PivotTables.PACKAGE.getClass();
    }

    protected DomainClassifierType createClassifierType(DomainType typeType) {
        ClassifierType anyClassifierType = this.getAnyClassifierType();
        ClassifierType classifierType = PivotFactory.eINSTANCE.createClassifierType();
        classifierType.setName(anyClassifierType.getName());
        classifierType.setUnspecializedElement(anyClassifierType);
        classifierType.setInstanceType(this.getType(typeType));
        return classifierType;
    }

    public DomainEvaluator createEvaluator(EObject contextObject, Map<Object, Object> contextMap) {
        return new PivotEcoreExecutorManager(contextObject, contextMap, (DomainStandardLibrary)this, this.metaModelManager);
    }

    protected Package createPackage(DomainPackage domainPackage) {
        Package pivotPackage = PivotFactory.eINSTANCE.createPackage();
        pivotPackage.setName(domainPackage.getName());
        pivotPackage.setNsURI(domainPackage.getNsURI());
        for (DomainType domainType : domainPackage.getOwnedType()) {
            Type pivotType = this.createType(domainType);
            pivotPackage.getOwnedType().add((Object)pivotType);
        }
        return pivotPackage;
    }

    protected Type createType(DomainType domainType) {
        Type pivotType = PivotFactory.eINSTANCE.createType();
        pivotType.setName(domainType.getName());
        return pivotType;
    }

    public ClassifierType getAnyClassifierType() {
        return this.metaModelManager.getAnyClassifierType();
    }

    public DomainInheritance getInheritance(DomainType type) {
        return this.metaModelManager.getInheritance(type);
    }

    @Override
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public DomainType getOclType(String typeName) {
        return PivotTables.PACKAGE.getType(typeName);
    }

    protected Type getType(DomainType typeType) {
        DomainPackage domainPackage;
        Package pivotPackage;
        if (typeType instanceof DomainCollectionType) {
            DomainCollectionType domainCollectionType = (DomainCollectionType)typeType;
            return this.metaModelManager.getCollectionType(domainCollectionType.getContainerType(), domainCollectionType.getElementType());
        }
        if (this.typeMap == null) {
            this.typeMap = new HashMap<DomainType, Type>();
        } else {
            Type type = this.typeMap.get(typeType);
            if (type != null) {
                return type;
            }
        }
        if (this.packageMap == null) {
            this.packageMap = new HashMap<DomainPackage, Package>();
        }
        if ((pivotPackage = this.packageMap.get(domainPackage = typeType.getPackage())) == null && (pivotPackage = this.metaModelManager.getPrimaryPackage(domainPackage.getNsURI(), new String[0])) == null) {
            pivotPackage = this.createPackage(domainPackage);
            this.metaModelManager.addPackage(pivotPackage);
        }
        return this.metaModelManager.getPrimaryType(pivotPackage, typeType.getName());
    }

    public DomainType getType(EClassifier eClassifier) {
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter(eClassifier.eResource(), this.metaModelManager);
        Type pivotType = ecore2Pivot.getCreated(Type.class, (EObject)eClassifier);
        return pivotType;
    }
}

