/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library.validators;

import java.util.HashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.library.LibraryValidator;
import org.eclipse.ocl.examples.domain.validation.ValidationWarning;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;

public class ValidateClosureIteration
implements LibraryValidator {
    public Diagnostic validate(DomainStandardLibrary standardLibrary, DomainCallExp callExp) {
        HashMap<TemplateParameter, ParameterableElement> bindings;
        Type iteratorType;
        MetaModelManager metaModelManager = (MetaModelManager)standardLibrary;
        Type bodyType = ((IteratorExp)callExp).getBody().getType();
        if (bodyType instanceof CollectionType) {
            bodyType = ((CollectionType)bodyType).getElementType();
        }
        if (!metaModelManager.conformsTo(bodyType, iteratorType = ((Variable)((IteratorExp)callExp).getIterator().get(0)).getType(), bindings = new HashMap<TemplateParameter, ParameterableElement>())) {
            return new ValidationWarning(OCLMessages.IncompatibleBodyType_WARNING_, new Object[]{bodyType, iteratorType});
        }
        return null;
    }
}

