/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library.validators;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.library.LibraryValidator;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.validation.ValidationWarning;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class ValidateSortedByIteration
implements LibraryValidator {
    public Diagnostic validate(DomainStandardLibrary standardLibrary, DomainCallExp callExp) {
        Type type = ((LoopExp)callExp).getBody().getType();
        TemplateParameter templateParameter = type.getOwningTemplateParameter();
        if (templateParameter != null) {
            Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions = PivotUtil.getAllTemplateParameterSubstitutions(null, (TemplateableElement)callExp.getSource().getType());
            type = (Type)templateParameterSubstitutions.get(templateParameter);
        }
        type = PivotUtil.getBehavioralType(type);
        try {
            DomainInheritance comparableType = standardLibrary.getOclComparableType().getInheritance(standardLibrary);
            DomainInheritance selfType = standardLibrary.getOclSelfType().getInheritance(standardLibrary);
            DomainOperation staticOperation = comparableType.lookupLocalOperation(standardLibrary, EvaluatorMessages.CompareToOperation, new DomainInheritance[]{selfType});
            if (staticOperation == null) {
                return new ValidationWarning(OCLMessages.UnresolvedOperation_ERROR_, new Object[]{EvaluatorMessages.CompareToOperation, String.valueOf(comparableType)});
            }
            LibraryFeature implementation = type.lookupImplementation(standardLibrary, staticOperation);
            if (implementation == null) {
                return new ValidationWarning(OCLMessages.UnresolvedOperation_ERROR_, new Object[]{EvaluatorMessages.CompareToOperation, String.valueOf(type)});
            }
            return null;
        }
        catch (Exception e) {
            return new ValidationWarning(e.getLocalizedMessage(), new Object[0]);
        }
    }
}

