/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.library.CompositionProperty;
import org.eclipse.ocl.examples.pivot.library.ConstrainedOperation;
import org.eclipse.ocl.examples.pivot.library.ConstrainedProperty;
import org.eclipse.ocl.examples.pivot.library.ExplicitNavigationProperty;
import org.eclipse.ocl.examples.pivot.library.ImplicitNonCompositionProperty;
import org.eclipse.ocl.examples.pivot.library.TuplePartProperty;
import org.eclipse.ocl.examples.pivot.library.UnimplementedOperation;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationManager {
    protected final MetaModelManager metaModelManager;
    private List<ClassLoader> classLoaders = null;

    protected ImplementationManager(MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    public void addClassLoader(ClassLoader classLoader) {
        List<ClassLoader> classLoaders = this.getClassLoaders();
        if (!classLoaders.contains(classLoader)) {
            classLoaders.add(classLoader);
        }
    }

    public List<ClassLoader> getClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = new ArrayList<ClassLoader>();
            this.classLoaders.add(this.metaModelManager.getClass().getClassLoader());
        }
        return this.classLoaders;
    }

    protected LibraryFeature getOperationImplementation(Operation operation) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        LibraryFeature implementation = operation.getImplementation();
        String implementationClassName = operation.getImplementationClass();
        if (!(implementationClassName == null || implementation != null && implementation.getClass().getName().equals(implementationClassName))) {
            return this.loadImplementation(operation);
        }
        for (Constraint constraint : this.metaModelManager.getLocalConstraints(operation)) {
            ValueSpecification specification;
            if (!"body".equals(constraint.getStereotype()) || !((specification = constraint.getSpecification()) instanceof ExpressionInOCL)) continue;
            return new ConstrainedOperation((ExpressionInOCL)specification);
        }
        return UnimplementedOperation.INSTANCE;
    }

    protected LibraryFeature getPropertyImplementation(Property property) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ValueSpecification specification;
        LibraryFeature implementation = property.getImplementation();
        String implementationClassName = property.getImplementationClass();
        if (!(implementationClassName == null || implementation != null && implementation.getClass().getName().equals(implementationClassName))) {
            return this.loadImplementation(property);
        }
        for (Constraint constraint : this.metaModelManager.getLocalConstraints(property)) {
            if (!"initial".equals(constraint.getStereotype()) || !((specification = constraint.getSpecification()) instanceof ExpressionInOCL)) continue;
            return new ConstrainedProperty((ExpressionInOCL)specification);
        }
        for (Constraint constraint : this.metaModelManager.getLocalConstraints(property)) {
            if (!"derivation".equals(constraint.getStereotype()) || !((specification = constraint.getSpecification()) instanceof ExpressionInOCL)) continue;
            return new ConstrainedProperty((ExpressionInOCL)specification);
        }
        Property opposite = property.getOpposite();
        if (opposite != null && opposite.isComposite()) {
            return CompositionProperty.INSTANCE;
        }
        if (property.isImplicit()) {
            return ImplicitNonCompositionProperty.INSTANCE;
        }
        if (property.getOwningType() instanceof TupleType) {
            return TuplePartProperty.INSTANCE;
        }
        return ExplicitNavigationProperty.INSTANCE;
    }

    public void dispose() {
        this.classLoaders = null;
    }

    public LibraryFeature loadImplementation(Feature feature) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String implementationClassName;
        LibraryFeature implementation = feature.getImplementation();
        if (implementation == null && (implementationClassName = feature.getImplementationClass()) != null) {
            Class<?> theClass = null;
            this.addClassLoader(feature.getClass().getClassLoader());
            ClassNotFoundException e = null;
            for (ClassLoader classLoader : this.getClassLoaders()) {
                try {
                    theClass = classLoader.loadClass(implementationClassName);
                    e = null;
                    break;
                }
                catch (ClassNotFoundException e1) {
                    if (e != null) continue;
                    e = e1;
                }
            }
            if (e != null) {
                throw e;
            }
            Field field = theClass.getField("INSTANCE");
            implementation = (LibraryFeature)field.get(null);
        }
        return implementation;
    }
}

