/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.manager.TypeTracker;

public abstract class PackageTracker
implements Adapter.Internal {
    protected final PackageManager packageManager;
    protected final Package target;

    protected PackageTracker(PackageManager packageManager, Package target) {
        this.packageManager = packageManager;
        this.target = target;
        target.eAdapters().add((Object)this);
        packageManager.addPackageTracker(target, this);
    }

    private void addedType(Object pivotType) {
        if (pivotType instanceof Type) {
            this.getPackageServer().addType((Type)pivotType);
        }
    }

    public void dispose() {
        this.packageManager.removePackageTracker(this);
        this.target.eAdapters().remove((Object)this);
    }

    public MetaModelManager getMetaModelManager() {
        return this.packageManager.getMetaModelManager();
    }

    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    public abstract PackageServer getPackageServer();

    Package getPrimaryPackage() {
        PackageServer packageServer = this.getPackageServer();
        return packageServer != null ? packageServer.getTarget() : null;
    }

    public Package getTarget() {
        return this.target;
    }

    abstract TypeTracker getTypeTracker(Type var1);

    protected void initContents(PackageServer packageServer) {
        for (Type pivotType : this.target.getOwnedType()) {
            packageServer.addType(pivotType);
        }
        for (Package nestedPackage : this.target.getNestedPackage()) {
            packageServer.addNestedPackage(nestedPackage);
        }
    }

    public boolean isAdapterForType(Object type) {
        return this.packageManager == type;
    }

    public void notifyChanged(Notification notification) {
        block18: {
            Object feature;
            int eventType;
            block17: {
                eventType = notification.getEventType();
                feature = notification.getFeature();
                if (feature != PivotPackage.Literals.PACKAGE__OWNED_TYPE) break block17;
                switch (eventType) {
                    case 3: {
                        this.addedType(notification.getNewValue());
                        break;
                    }
                    case 5: {
                        List values = (List)notification.getNewValue();
                        for (Object value : values) {
                            this.addedType(value);
                        }
                        break block18;
                    }
                    case 4: {
                        this.removedType(notification.getOldValue());
                        break;
                    }
                    case 6: {
                        List values = (List)notification.getOldValue();
                        for (Object value : values) {
                            this.removedType(value);
                        }
                    }
                }
                break block18;
            }
            if (feature == PivotPackage.Literals.PACKAGE__NESTED_PACKAGE) {
                PackageServer packageServer = this.getPackageServer();
                switch (eventType) {
                    case 3: {
                        packageServer.addedNestedPackage(notification.getNewValue());
                        break;
                    }
                    case 5: {
                        List values = (List)notification.getNewValue();
                        for (Object value : values) {
                            packageServer.addedNestedPackage(value);
                        }
                        break;
                    }
                    case 4: {
                        packageServer.removedNestedPackage(notification.getOldValue());
                        break;
                    }
                    case 6: {
                        List values = (List)notification.getOldValue();
                        for (Object value : values) {
                            packageServer.removedNestedPackage(value);
                        }
                        break;
                    }
                }
            }
        }
    }

    private void removedType(Object pivotType) {
        TypeTracker typeTracker;
        if (pivotType instanceof Type && (typeTracker = this.packageManager.getMetaModelManager().findTypeTracker((Type)pivotType)) != null) {
            TypeServer typeServer = typeTracker.getTypeServer();
            typeServer.removedType((Type)pivotType);
        }
    }

    public void setTarget(Notifier newTarget) {
        assert (this.target == newTarget);
    }

    public String toString() {
        return String.valueOf(this.target);
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (this.target == oldTarget);
    }
}

