/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.prettyprint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrettyPrintOptions {
    protected final Namespace scope;

    public PrettyPrintOptions(Namespace scope) {
        this.scope = scope;
    }

    public abstract void addReservedNames(Iterable<String> var1);

    public abstract void addRestrictedNames(Iterable<String> var1);

    public String getAlias(Namespace namespace) {
        return this.getGlobalOptions().getAlias(namespace);
    }

    public URI getBaseURI() {
        return this.getGlobalOptions().getBaseURI();
    }

    public abstract Global getGlobalOptions();

    public String getIndentStep() {
        return this.getGlobalOptions().getIndentStep();
    }

    public int getLinelength() {
        return this.getGlobalOptions().getLinelength();
    }

    public MetaModelManager getMetaModelManager() {
        return this.getGlobalOptions().getMetaModelManager();
    }

    public abstract Set<String> getReservedNames();

    public abstract Set<String> getRestrictedNames();

    public Namespace getScope() {
        return this.scope;
    }

    public void setIndentStep(String indentStep) {
        this.getGlobalOptions().setIndentStep(indentStep);
    }

    public void setLinelength(int linelength) {
        this.getGlobalOptions().setLinelength(linelength);
    }

    @Deprecated
    public void setUseParentheses(boolean useParentheses) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Global
    extends PrettyPrintOptions {
        private String indentStep = "  ";
        private int linelength = Integer.MAX_VALUE;
        private final Set<String> reservedNames = new HashSet<String>();
        private final Set<String> restrictedNames = new HashSet<String>();
        private Map<Namespace, String> namespace2alias = new HashMap<Namespace, String>();
        private URI baseURI = null;
        private MetaModelManager metaModelManager = null;

        public Global(Namespace scope) {
            super(scope);
        }

        public void addAliases(Namespace namespace, String alias) {
            if (this.namespace2alias == null) {
                this.namespace2alias = new HashMap<Namespace, String>();
            }
            this.namespace2alias.put(namespace, alias);
        }

        @Override
        public void addReservedNames(Iterable<String> names) {
            for (String name : names) {
                this.reservedNames.add(name);
                this.restrictedNames.add(name);
            }
        }

        @Override
        public void addRestrictedNames(Iterable<String> names) {
            for (String name : names) {
                this.restrictedNames.add(name);
            }
        }

        @Override
        public String getAlias(Namespace namespace) {
            return this.namespace2alias != null ? this.namespace2alias.get(namespace) : null;
        }

        @Override
        public URI getBaseURI() {
            return this.baseURI;
        }

        @Override
        public Global getGlobalOptions() {
            return this;
        }

        @Override
        public String getIndentStep() {
            return this.indentStep;
        }

        @Override
        public int getLinelength() {
            return this.linelength;
        }

        public Set<Namespace> getAliasedNamespaces() {
            return this.namespace2alias.keySet();
        }

        @Override
        public MetaModelManager getMetaModelManager() {
            return this.metaModelManager;
        }

        @Override
        public Set<String> getReservedNames() {
            return this.reservedNames;
        }

        @Override
        public Set<String> getRestrictedNames() {
            return this.restrictedNames;
        }

        public void setAliases(Map<Namespace, String> namespace2alias) {
            this.namespace2alias = namespace2alias;
        }

        public void setBaseURI(URI baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public void setIndentStep(String indentStep) {
            this.indentStep = indentStep;
        }

        @Override
        public void setLinelength(int linelength) {
            this.linelength = linelength;
        }

        public void setMetaModelManager(MetaModelManager metaModelManager) {
            this.metaModelManager = metaModelManager;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Local
    extends PrettyPrintOptions {
        private PrettyPrintOptions options;
        private Set<String> reservedNames = null;
        private Set<String> restrictedNames = null;

        public Local(PrettyPrintOptions options, Namespace scope) {
            super(scope);
            this.options = options;
        }

        @Override
        public void addReservedNames(Iterable<String> names) {
            if (this.reservedNames == null) {
                this.reservedNames = new HashSet<String>();
            }
            if (this.reservedNames == null) {
                this.restrictedNames = new HashSet<String>();
            }
            for (String name : names) {
                this.reservedNames.add(name);
                this.restrictedNames.add(name);
            }
        }

        @Override
        public void addRestrictedNames(Iterable<String> names) {
            if (this.reservedNames == null) {
                this.reservedNames = new HashSet<String>();
            }
            if (this.reservedNames == null) {
                this.restrictedNames = new HashSet<String>();
            }
            for (String name : names) {
                this.restrictedNames.add(name);
            }
        }

        @Override
        public Global getGlobalOptions() {
            return this.options.getGlobalOptions();
        }

        @Override
        public Set<String> getReservedNames() {
            return this.reservedNames != null ? this.reservedNames : this.options.getReservedNames();
        }

        @Override
        public Set<String> getRestrictedNames() {
            return this.restrictedNames != null ? this.restrictedNames : this.options.getRestrictedNames();
        }
    }
}

