/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.prettyprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.examples.pivot.util.AbstractVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PathElement;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrinter {
    public static final String NULL_PLACEHOLDER = "<null>";
    public static List<String> reservedNameList = Arrays.asList("and", "else", "endif", "false", "if", "implies", "in", "invalid", "let", "not", "null", "or", "self", "then", "true", "xor");
    public static List<String> restrictedNameList = Arrays.asList("Bag", "Boolean", "Collection", "Integer", "OclAny", "OclInvalid", "OclVoid", "OrderedSet", "Real", "Sequence", "Set", "String", "Tuple", "UnlimitedNatural");
    private static Map<EPackage, Factory> factoryMap = new HashMap<EPackage, Factory>();
    private final PrettyPrintOptions options;
    private String pendingPrefix = "";
    private StringBuilder pendingText;
    protected Fragment fragment;
    private Mode mode;
    private final AbstractVisitor<Object, PrettyPrinter> visitor;
    private Namespace scope;
    private Precedence currentPrecedence = null;

    public static void addFactory(EPackage ePackage, Factory factory) {
        factoryMap.put(ePackage, factory);
    }

    public static PrettyPrinter createNamePrinter(Element element, PrettyPrintOptions options) {
        return new PrettyPrinter(options, Mode.NAME, element);
    }

    public static PrettyPrinter createPrinter(Element element, PrettyPrintOptions options) {
        return new PrettyPrinter(options, Mode.FULL, element);
    }

    public static PrettyPrintOptions.Global createOptions(Namespace scope) {
        PrettyPrintOptions.Global options = new PrettyPrintOptions.Global(scope);
        options.addReservedNames(reservedNameList);
        options.addRestrictedNames(reservedNameList);
        return options;
    }

    public static String print(Element element) {
        return PrettyPrinter.print(element, PrettyPrinter.createOptions(null));
    }

    public static String print(Element element, Namespace namespace) {
        return PrettyPrinter.print(element, PrettyPrinter.createOptions(namespace));
    }

    public static String print(Element element, PrettyPrintOptions options) {
        if (element == null) {
            return NULL_PLACEHOLDER;
        }
        PrettyPrinter printer = new PrettyPrinter(options, Mode.FULL, element);
        try {
            printer.appendElement(element);
            return printer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(printer.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    public static String printName(Element element) {
        return PrettyPrinter.printName(element, PrettyPrinter.createOptions(null));
    }

    public static String printName(Element element, Namespace namespace) {
        return PrettyPrinter.printName(element, PrettyPrinter.createOptions(namespace));
    }

    public static String printName(Element element, PrettyPrintOptions options) {
        if (element == null) {
            return NULL_PLACEHOLDER;
        }
        PrettyPrinter printer = PrettyPrinter.createNamePrinter(element, options);
        try {
            printer.appendElement(element);
            return printer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(printer.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    public static String printType(Element element) {
        return PrettyPrinter.printType(element, PrettyPrinter.createOptions(null));
    }

    public static String printType(Element element, Namespace namespace) {
        return PrettyPrinter.printType(element, PrettyPrinter.createOptions(namespace));
    }

    public static String printType(Element element, PrettyPrintOptions options) {
        if (element == null) {
            return NULL_PLACEHOLDER;
        }
        PrettyPrinter printer = new PrettyPrinter(options, Mode.TYPE, element);
        try {
            printer.appendElement(element);
            return printer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(printer.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    private PrettyPrinter(PrettyPrintOptions options, Mode mode, Element element) {
        this.options = options;
        this.mode = mode;
        this.scope = options.getScope();
        this.pendingText = new StringBuilder();
        this.fragment = new Fragment(null, 0, "", "", "");
        EObject rootObject = EcoreUtil.getRootContainer((EObject)element);
        EPackage rootPackage = rootObject.eClass().getEPackage();
        Factory factory = factoryMap.get(rootPackage);
        this.visitor = factory.createPrettyPrintVisitor(this);
    }

    public void append(Number number) {
        if (number != null) {
            this.append(number.toString());
        } else {
            this.append(NULL_PLACEHOLDER);
        }
    }

    protected void append(String string) {
        if (string != null) {
            this.pendingText.append(string);
        } else {
            this.pendingText.append(NULL_PLACEHOLDER);
        }
    }

    public void appendElement(Element element) {
        this.visitor.safeVisit(element);
    }

    public void appendMultiplicity(int lower, int upper) {
        PivotUtil.appendMultiplicity(this.pendingText, lower, upper);
    }

    public void appendName(NamedElement object) {
        this.appendName(object, this.options.getRestrictedNames());
    }

    public void appendName(NamedElement object, Set<String> keywords) {
        this.append(this.getName(object, keywords));
    }

    public void appendParameters(Operation operation, boolean withNames) {
        this.append("(");
        String prefix = "";
        if (operation instanceof Iteration) {
            Iteration iteration = (Iteration)operation;
            for (Parameter parameter : iteration.getOwnedIterator()) {
                this.append(prefix);
                if (withNames) {
                    this.appendName(parameter);
                    this.append(" : ");
                }
                this.appendTypedMultiplicity(parameter);
                prefix = ", ";
            }
            if (iteration.getOwnedAccumulator().size() > 0) {
                prefix = "; ";
                for (Parameter parameter : iteration.getOwnedAccumulator()) {
                    if (withNames) {
                        this.appendName(parameter);
                        this.append(" : ");
                    }
                    this.append(prefix);
                    this.appendTypedMultiplicity(parameter);
                    prefix = ", ";
                }
            }
            prefix = " | ";
        }
        for (Parameter parameter : operation.getOwnedParameter()) {
            this.append(prefix);
            if (withNames) {
                this.appendName(parameter);
                this.append(" : ");
            }
            this.appendTypedMultiplicity(parameter);
            prefix = ", ";
        }
        this.append(")");
    }

    public void appendParent(EObject scope, Element element, String parentSeparator) {
        Mode savedMode = this.pushMode(Mode.TYPE);
        try {
            EObject eObject = scope;
            while (eObject != null) {
                if (element == eObject) {
                    return;
                }
                eObject = eObject.eContainer();
            }
            if (element == null) {
                this.append(NULL_PLACEHOLDER);
            } else {
                Element unspecializedElement = element instanceof TemplateableElement ? ((TemplateableElement)element).getUnspecializedElement() : element;
                Namespace parent = PivotUtil.getNamespace((unspecializedElement != null ? unspecializedElement : element).eContainer());
                if (parent instanceof Package) {
                    String name = ((Package)parent).getName();
                    if ("$$".equals(name)) {
                        return;
                    }
                    if ("pivot".equals(name)) {
                        return;
                    }
                    if ("ocl".equals(name)) {
                        return;
                    }
                }
                if (element instanceof Operation && parent instanceof Type && "$$".equals(((Type)((Object)parent)).getName())) {
                    Operation operation = (Operation)element;
                    this.append(operation.getOwningType().getName());
                    this.appendTemplateBindings(operation);
                    this.append(parentSeparator);
                    return;
                }
                MetaModelManager metaModelManager = this.options.getGlobalOptions().getMetaModelManager();
                if (metaModelManager != null && parent instanceof Type) {
                    parent = (Namespace)((Object)metaModelManager.getPrimaryType((Type)((Object)parent)));
                }
                if (parent == scope) {
                    return;
                }
                if (parent instanceof Visitable) {
                    List<PathElement> parentPath = PathElement.getPath(parent, metaModelManager);
                    int iMax = parentPath.size();
                    int i = 0;
                    if (scope != null) {
                        List<PathElement> scopePath = PathElement.getPath(scope, metaModelManager);
                        i = PathElement.getCommonLength(parentPath, scopePath);
                    }
                    if (i < iMax) {
                        this.appendElement(parentPath.get(i++).getElement());
                        while (i < iMax) {
                            this.append("::");
                            this.appendElement(parentPath.get(i++).getElement());
                        }
                    }
                } else assert (element instanceof Package || element instanceof ExpressionInOCL) : element.eClass().getName();
            }
            this.append(parentSeparator);
        }
        finally {
            this.popMode(savedMode);
        }
    }

    public void appendQualifiedType(Element element) {
        Mode savedMode = this.pushMode(Mode.TYPE);
        try {
            MetaModelManager metaModelManager = this.options.getGlobalOptions().getMetaModelManager();
            Namespace parent = PivotUtil.getNamespace(element.eContainer());
            List<PathElement> parentPath = PathElement.getPath(parent, metaModelManager);
            int iMax = parentPath.size();
            int i = 0;
            Namespace scope = this.options.getScope();
            if (scope != null) {
                List<PathElement> scopePath = PathElement.getPath(scope, metaModelManager);
                i = PathElement.getCommonLength(parentPath, scopePath);
            }
            if (i == 0 && i < iMax) {
                PathElement rootPathElement = parentPath.get(0);
                String name = rootPathElement.getName();
                String alias = this.options.getAlias((Namespace)rootPathElement.getElement());
                if (alias != null) {
                    this.append(this.getName(alias, this.options.getReservedNames()));
                    this.append("::");
                    ++i;
                } else if ("$$".equals(name)) {
                    ++i;
                } else if ("pivot".equals(name)) {
                    ++i;
                } else if ("ocl".equals(name)) {
                    ++i;
                } else {
                    URI uri = rootPathElement.getElement().eResource().getURI();
                    if (uri != null) {
                        URI baseURI;
                        if (PivotUtil.isPivotURI(uri)) {
                            uri = PivotUtil.getNonPivotURI(uri);
                        }
                        if ((baseURI = this.options.getBaseURI()) != null) {
                            uri = uri.deresolve(baseURI);
                        }
                        this.append(this.getName(uri.toString(), this.options.getReservedNames()));
                        this.append("::");
                        ++i;
                    }
                }
            }
            while (i < iMax) {
                this.appendElement(parentPath.get(i++).getElement());
                this.append("::");
            }
            this.appendElement(element);
        }
        finally {
            this.popMode(savedMode);
        }
    }

    public void appendTemplateBindings(TemplateableElement typeRef) {
        block8: {
            Mode savedMode = this.pushMode(Mode.TYPE);
            try {
                EList<TemplateBinding> templateBindings = typeRef.getTemplateBinding();
                if (templateBindings.isEmpty()) break block8;
                this.append("(");
                String prefix = "";
                for (TemplateBinding templateBinding : templateBindings) {
                    for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitution()) {
                        this.append(prefix);
                        Namespace savedScope = this.pushScope((Namespace)((Object)typeRef));
                        try {
                            this.appendElement(templateParameterSubstitution.getActual());
                        }
                        finally {
                            this.popScope(savedScope);
                        }
                        prefix = ", ";
                    }
                }
                this.append(")");
            }
            finally {
                this.popMode(savedMode);
            }
        }
    }

    public void appendTemplateParameters(TemplateableElement templateableElement) {
        EList<TemplateParameter> templateParameters;
        TemplateSignature templateSignature = templateableElement.getOwnedTemplateSignature();
        if (templateSignature != null && !(templateParameters = templateSignature.getOwnedParameter()).isEmpty()) {
            this.append("(");
            String prefix = "";
            for (TemplateParameter templateParameter : templateParameters) {
                this.append(prefix);
                Namespace savedScope = this.pushScope((Namespace)((Object)templateableElement));
                try {
                    this.appendElement(templateParameter);
                }
                finally {
                    this.popScope(savedScope);
                }
                prefix = ", ";
            }
            this.append(")");
        }
    }

    public void appendTypedMultiplicity(TypedMultiplicityElement object) {
        int lower = object.getLower().intValue();
        int upper = object.getUpper().intValue();
        if (upper != 1) {
            if (object.isOrdered()) {
                if (object.isUnique()) {
                    this.append("OrderedSet");
                } else {
                    this.append("Sequence");
                }
            } else if (object.isUnique()) {
                this.append("Set");
            } else {
                this.append("Bag");
            }
            this.append("(");
            this.appendElement(object.getType());
            if (lower > 0 || upper >= 0) {
                this.appendMultiplicity(lower, upper);
            }
            this.append(")");
        } else {
            this.appendElement(object.getType());
            this.appendMultiplicity(lower, upper);
        }
    }

    public Precedence getCurrentPrecedence() {
        return this.currentPrecedence;
    }

    public Set<String> getReservedNames() {
        return this.options.getReservedNames();
    }

    public Set<String> getRestrictedNames() {
        return this.options.getRestrictedNames();
    }

    public Namespace getScope() {
        return this.scope;
    }

    public void push(String text, String suffix) {
        this.append(text);
        this.fragment = this.fragment.addChild(this.pendingPrefix, this.pendingText.toString(), suffix);
        this.fragment.exdented = true;
        this.pendingPrefix = "";
        this.pendingText.setLength(0);
    }

    public void exdent(String prefix, String text, String suffix) {
        assert (this.fragment != null && this.fragment.getParent() != null);
        if (this.pendingPrefix != null && this.pendingPrefix.length() > 0 || this.pendingText.length() > 0) {
            this.fragment.addChild(this.pendingPrefix, this.pendingText.toString(), "");
            this.pendingPrefix = "";
            this.pendingText.setLength(0);
        }
        if (prefix.length() > 0 || text.length() > 0) {
            this.fragment = this.fragment.getParent().addChild(prefix, text.toString(), suffix);
            this.fragment.exdented = true;
        }
    }

    public String getName(NamedElement object, Set<String> keywords) {
        if (object == null) {
            return NULL_PLACEHOLDER;
        }
        return this.getName(object.getName(), keywords);
    }

    public String getName(String name, Set<String> keywords) {
        if (keywords == null || !keywords.contains(name) && PivotUtil.isValidIdentifier(name)) {
            return name;
        }
        StringBuilder s = new StringBuilder();
        s.append("_'");
        s.append(PivotUtil.convertToOCLString(name));
        s.append("'");
        return s.toString();
    }

    public void next(String prefix, String text, String suffix) {
        assert (this.fragment != null);
        if (this.pendingPrefix != null && this.pendingPrefix.length() > 0 || this.pendingText.length() > 0) {
            this.fragment.addChild(this.pendingPrefix, this.pendingText.toString(), "");
            this.pendingPrefix = "";
            this.pendingText.setLength(0);
        }
        this.fragment.addChild(prefix, text, suffix);
    }

    public void pop() {
        assert (this.fragment != null);
        if (this.pendingPrefix != null && this.pendingPrefix.length() > 0 || this.pendingText.length() > 0) {
            this.fragment.addChild(this.pendingPrefix, this.pendingText.toString(), "");
        }
        this.pendingPrefix = "";
        this.pendingText.setLength(0);
        assert (this.fragment.getParent() != null);
        this.fragment = this.fragment.getParent();
    }

    public void popMode(Mode oldMode) {
        this.mode = oldMode;
    }

    public void popScope(Namespace oldScope) {
        this.scope = oldScope;
    }

    public void precedenceVisit(OCLExpression expression, Precedence newPrecedence) {
        Precedence savedPrecedcence = this.currentPrecedence;
        try {
            this.currentPrecedence = newPrecedence;
            this.appendElement(expression);
        }
        finally {
            this.currentPrecedence = savedPrecedcence;
        }
    }

    public Mode pushMode(Mode newMode) {
        Mode oldMode = this.mode;
        this.mode = newMode;
        return oldMode;
    }

    public Namespace pushScope(Namespace newScope) {
        Namespace oldscope = this.scope;
        this.scope = newScope;
        return oldscope;
    }

    public boolean showNames() {
        return this.mode == Mode.NAME || this.mode == Mode.FULL;
    }

    public String toString() {
        if (this.fragment == null) {
            return String.valueOf(this.pendingPrefix) + this.pendingText.toString();
        }
        this.fragment.configureLineWrapping(this.options.getIndentStep().length(), this.options.getLinelength());
        StringBuilder s = new StringBuilder();
        String newLine = this.fragment.toString(s, null, "  ");
        return String.valueOf(s.toString()) + newLine + this.pendingPrefix + this.pendingText.toString();
    }

    public String toString(String indent, int lineLength) {
        if (this.fragment == null) {
            return String.valueOf(this.pendingPrefix) + this.pendingText.toString();
        }
        this.fragment.configureLineWrapping(indent.length(), lineLength);
        StringBuilder s = new StringBuilder();
        this.fragment.toString(s, null, indent);
        return String.valueOf(s.toString()) + this.pendingPrefix + this.pendingText.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public AbstractVisitor<Object, PrettyPrinter> createPrettyPrintVisitor(PrettyPrinter var1);
    }

    private static class Fragment {
        private final int depth;
        private final String prefix;
        private final String text;
        private final String suffix;
        private Fragment parent = null;
        private List<Fragment> children = null;
        private boolean lineWrap = true;
        private boolean exdented = false;

        public Fragment(Fragment parent, int depth, String prefix, String text, String suffix) {
            this.parent = parent;
            this.depth = depth;
            this.prefix = prefix;
            this.text = text;
            this.suffix = suffix;
        }

        public Fragment addChild(String prefix, String text, String suffix) {
            if (this.children == null) {
                this.children = new ArrayList<Fragment>();
            }
            Fragment child = new Fragment(this, this.depth + 1, prefix, text, suffix);
            this.children.add(child);
            return child;
        }

        public void configureLineWrapping(int spacesPerIndent, int lineLength) {
            int firstColumn = this.depth * spacesPerIndent;
            int lastColumn = firstColumn + this.text.length();
            if (this.prefix != null) {
                lastColumn += this.prefix.length();
            }
            if (this.suffix != null) {
                lastColumn += this.suffix.length();
            }
            if (this.children != null) {
                for (Fragment child : this.children) {
                    child.lineWrap = true;
                    child.configureLineWrapping(spacesPerIndent, lineLength);
                }
                int allChildrenLength = this.getChildrenLength(true);
                if (lastColumn + allChildrenLength <= lineLength) {
                    for (Fragment child : this.children) {
                        child.lineWrap = false;
                    }
                } else {
                    for (Fragment child : this.children) {
                        child.lineWrap = child.exdented;
                    }
                }
            }
            if (this.parent == null) {
                this.lineWrap = false;
            }
        }

        public int getChildrenLength(Boolean concatenate) {
            int childrenLength = 0;
            int iChild = 0;
            while (iChild < this.children.size()) {
                int childLength = this.getChildLength(iChild);
                if (concatenate == Boolean.TRUE) {
                    childrenLength += childLength;
                } else if (childLength > childrenLength) {
                    childrenLength = childLength;
                }
                ++iChild;
            }
            return childrenLength;
        }

        public int getChildLength(int iChild) {
            Fragment child = this.children.get(iChild);
            int childLength = child.length();
            int jChild = iChild + 1;
            while (jChild < this.children.size()) {
                Fragment nextChild = this.children.get(jChild);
                if (nextChild.prefix != null && nextChild.lineWrap) break;
                childLength += child.length();
                ++jChild;
            }
            return childLength;
        }

        public int length() {
            int length = this.text.length();
            if (this.prefix != null) {
                length += this.prefix.length();
            }
            if (this.suffix != null) {
                length += this.suffix.length();
            }
            if (this.children != null) {
                length += this.getChildrenLength(null);
            }
            return length;
        }

        public Fragment getParent() {
            return this.parent;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            this.toString(s, null, "  ");
            return s.toString();
        }

        public String toString(StringBuilder s, String newLine, String indent) {
            if ((this.lineWrap || newLine != null) && this.prefix != null) {
                if (this.lineWrap) {
                    newLine = "\n";
                }
                s.append(newLine);
                if (this.text.length() > 0) {
                    if (newLine != null && newLine.equals("\n")) {
                        int i = 1;
                        while (i < this.depth) {
                            s.append(indent);
                            ++i;
                        }
                    } else {
                        s.append(this.prefix);
                    }
                } else if (this.prefix.length() > 0) {
                    s.append(this.prefix);
                }
            }
            s.append(this.text);
            newLine = this.suffix;
            if (this.children != null) {
                for (Fragment child : this.children) {
                    newLine = child.toString(s, newLine, indent);
                }
            }
            return newLine;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        TYPE,
        NAME,
        FULL;

    }
}

