/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.scoping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Model;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.scoping.PivotScopeView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Nameable;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentView {
    private static final Logger logger = Logger.getLogger(EnvironmentView.class);
    protected final MetaModelManager metaModelManager;
    protected final EStructuralFeature reference;
    private EClassifier requiredType;
    protected final String name;
    private final Map<String, Object> contentsByName = new HashMap<String, Object>();
    private Map<EObject, Map<TemplateParameter, ParameterableElement>> templateBindings = null;
    private int contentsSize = 0;
    private List<ScopeFilter> matchers = null;
    private Set<ScopeFilter> resolvers = null;

    public EnvironmentView(MetaModelManager metaModelManager, EStructuralFeature reference, String name) {
        this.metaModelManager = metaModelManager;
        this.reference = reference;
        this.requiredType = reference != null ? reference.getEType() : null;
        this.name = name;
    }

    public boolean accepts(EClass eClass) {
        return PivotUtil.conformsTo(this.requiredType, (EClassifier)eClass);
    }

    public void addAllContents(Type forType, ScopeView scopeView, Type pivotClass, Boolean selectStatic, Set<Type> alreadyVisited) {
        this.addNamedElements(forType, this.metaModelManager.getLocalOperations(pivotClass, selectStatic));
        this.addNamedElements(forType, this.metaModelManager.getLocalProperties(pivotClass, selectStatic));
        alreadyVisited.add(pivotClass);
        for (Type superClass : this.metaModelManager.getSuperClasses(pivotClass)) {
            if (alreadyVisited.contains(superClass)) continue;
            this.addAllContents(forType, scopeView, superClass, selectStatic, alreadyVisited);
        }
    }

    public void addAllProperties(Type type, Boolean selectStatic) {
        this.addAllProperties(type, type, selectStatic, new HashSet<Type>());
    }

    protected void addAllProperties(Type forType, Type pivotClass, Boolean selectStatic, Set<Type> alreadyVisited) {
        this.addNamedElements(this.metaModelManager.getLocalProperties(pivotClass, selectStatic));
        alreadyVisited.add(pivotClass);
        for (Type superClass : this.metaModelManager.getSuperClasses(pivotClass)) {
            if (alreadyVisited.contains(superClass)) continue;
            this.addAllProperties(forType, superClass, selectStatic, alreadyVisited);
        }
    }

    public int addElement(String elementName, EObject element) {
        return this.addElement(elementName, null, element);
    }

    public int addElement(String elementName, Type forType, EObject element) {
        Object value;
        if (element == null) {
            return 0;
        }
        if (elementName == null) {
            return 0;
        }
        element = this.metaModelManager.getPrimaryElement(element);
        if (this.name != null && !this.name.equals(elementName)) {
            return 0;
        }
        if (this.name != null && this.matchers != null) {
            for (ScopeFilter filter : this.matchers) {
                if (filter.matches(this, forType, element)) continue;
                return 0;
            }
        }
        if (this.requiredType != null && !this.requiredType.isInstance((Object)element)) {
            return 0;
        }
        if (this.matchers != null) {
            if (this.resolvers == null) {
                this.resolvers = new HashSet<ScopeFilter>();
            }
            this.resolvers.addAll(this.matchers);
        }
        if ((value = this.contentsByName.get(elementName)) != element) {
            if (value == null) {
                this.contentsByName.put(elementName, element);
                ++this.contentsSize;
            } else {
                List<EObject> values;
                if (value instanceof EObject) {
                    values = new ArrayList<EObject>();
                    values.add((EObject)value);
                    this.contentsByName.put(elementName, values);
                } else {
                    List castValue = (List)value;
                    values = castValue;
                }
                if (!values.contains(element)) {
                    values.add(element);
                    ++this.contentsSize;
                }
            }
        }
        return 1;
    }

    public int addElements(Iterable<? extends EObject> elements) {
        return this.addElements(null, elements);
    }

    public int addElements(Type forType, Iterable<? extends EObject> elements) {
        int additions = 0;
        if (elements != null) {
            for (EObject eObject : elements) {
                if (!(eObject instanceof Nameable)) continue;
                Nameable namedElement = (Nameable)eObject;
                additions += this.addElement(namedElement.getName(), forType, namedElement);
            }
        }
        return additions;
    }

    public void addElementsOfScope(Element element, ScopeView scopeView) {
        Attribution attribution;
        if (element != null && (attribution = PivotUtil.getAttribution(element = PivotUtil.getLowerBound(element))) != null) {
            attribution.computeLookup(element, this, scopeView);
        }
    }

    public void addFilter(ScopeFilter filter) {
        if (this.matchers == null) {
            this.matchers = new ArrayList<ScopeFilter>();
        }
        this.matchers.add(filter);
    }

    public void addImportedElement(URI baseURI) {
        if (baseURI != null) {
            String name;
            if (PivotUtil.isPivotURI(baseURI)) {
                baseURI = PivotUtil.getNonPivotURI(baseURI);
            }
            if (baseURI != null && (name = this.getName()) != null) {
                URI uri = URI.createURI((String)name).resolve(baseURI);
                try {
                    Element importedElement = this.metaModelManager.loadResource(uri, null, null);
                    this.addElement(name, importedElement);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void addInheritedContents(Class target, ScopeView scopeView) {
        EList<Type> superClasses = target.getSuperClass();
        if (superClasses.size() > 0) {
            for (Type superClass : superClasses) {
                this.addElementsOfScope(superClass, scopeView);
            }
        } else {
            ClassifierType libType = this.metaModelManager.getAnyClassifierType();
            this.addLibContents(libType, scopeView);
        }
    }

    public void addLibContents(Type libType, ScopeView scopeView) {
        if (libType == null) {
            return;
        }
        this.addElementsOfScope(libType, scopeView);
        for (Type superClass : libType.getSuperClass()) {
            this.addLibContents(superClass, scopeView);
        }
    }

    public int addNamedElement(Nameable namedElement) {
        return this.addNamedElement(null, namedElement);
    }

    public int addNamedElement(Type forType, Nameable namedElement) {
        if (namedElement != null) {
            return this.addElement(namedElement.getName(), forType, namedElement);
        }
        return 0;
    }

    public int addNamedElements(Iterable<? extends Nameable> namedElements) {
        return this.addNamedElements(null, namedElements);
    }

    public int addNamedElements(Type forType, Iterable<? extends Nameable> namedElements) {
        int additions = 0;
        if (namedElements != null) {
            for (Nameable nameable : namedElements) {
                additions += this.addElement(nameable.getName(), forType, nameable);
            }
        }
        return additions;
    }

    public void addRootPackages() {
        for (Package pPackage : this.metaModelManager.getPackageManager().getAllPackages()) {
            if (pPackage instanceof Model) {
                this.addElements((Iterable<? extends EObject>)pPackage.getNestedPackage());
                continue;
            }
            String nsURI = pPackage.getNsURI();
            if (nsURI == null) continue;
            this.addElement(nsURI, pPackage);
        }
    }

    public int computeLookups(Element target, EObject child, EStructuralFeature containmentFeature, EReference targetReference) {
        Attribution attribution = PivotUtil.getAttribution(target);
        PivotScopeView pivotScopeView = new PivotScopeView(this.metaModelManager, target, attribution, child, containmentFeature, targetReference);
        return this.computeLookups(pivotScopeView);
    }

    public int computeLookups(ScopeView aScope) {
        try {
            while (aScope != null && !this.hasFinalResult()) {
                Attribution aAttribution = aScope.getAttribution();
                if (aAttribution != null) {
                    EObject aTarget = aScope.getTarget();
                    aScope = aAttribution.computeLookup(aTarget, this, aScope);
                    continue;
                }
                break;
            }
        }
        catch (IllegalLibraryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)("Lookup of '" + this.name + "' failed"), (Throwable)e);
        }
        return this.resolveDuplicates();
    }

    public EObject getContent() {
        if (this.contentsSize == 0) {
            return null;
        }
        if (this.contentsSize != 1) {
            logger.warn((Object)("Unhandled ambiguous content for '" + this.name + "'"));
        }
        for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                value = values.get(values.size() - 1);
            }
            if (!(value instanceof EObject)) continue;
            return (EObject)value;
        }
        return null;
    }

    public Set<Map.Entry<String, Object>> getEntries() {
        return this.contentsByName.entrySet();
    }

    public String getName() {
        return this.name;
    }

    public EStructuralFeature getReference() {
        return this.reference;
    }

    public EClassifier getRequiredType() {
        return this.requiredType;
    }

    public int getSize() {
        return this.contentsSize;
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public boolean hasFinalResult() {
        if (this.contentsSize == 0) {
            return false;
        }
        return this.getName() != null;
    }

    public void removeFilter(ScopeFilter filter) {
        if (this.matchers != null) {
            this.matchers.remove(filter);
        }
    }

    public int resolveDuplicates() {
        if (this.contentsSize > 1 && this.resolvers != null && this.getName() != null) {
            int newSize = 0;
            for (Map.Entry<String, Object> entry : this.contentsByName.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof List) {
                    List values = (List)value;
                    for (ScopeFilter filter : this.resolvers) {
                        int i = 0;
                        while (i < values.size() - 1) {
                            EObject reference = (EObject)values.get(i);
                            Map<TemplateParameter, ParameterableElement> referenceBindings = this.templateBindings != null ? this.templateBindings.get(reference) : null;
                            int j = i + 1;
                            while (j < values.size()) {
                                Map<TemplateParameter, ParameterableElement> candidateBindings;
                                EObject candidate = (EObject)values.get(j);
                                int verdict = filter.compareMatches(reference, referenceBindings, candidate, candidateBindings = this.templateBindings != null ? this.templateBindings.get(candidate) : null);
                                if (verdict == 0) {
                                    ++j;
                                    continue;
                                }
                                if (verdict < 0) {
                                    values.remove(i);
                                    reference = null;
                                    break;
                                }
                                values.remove(j);
                                candidate = null;
                            }
                            if (reference == null) continue;
                            ++i;
                        }
                    }
                    newSize += values.size();
                    continue;
                }
                ++newSize;
            }
            this.contentsSize = newSize;
        }
        return this.getSize();
    }

    public void setBindings(EObject eObject, Map<TemplateParameter, ParameterableElement> bindings) {
        if (this.templateBindings == null) {
            this.templateBindings = new HashMap<EObject, Map<TemplateParameter, ParameterableElement>>();
        }
        this.templateBindings.put(eObject, bindings);
    }

    public void setRequiredType(EClassifier requiredType) {
        assert (PivotUtil.conformsTo(this.reference.getEType(), requiredType));
        this.requiredType = requiredType;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.reference != null) {
            s.append(this.reference.getName());
            s.append(" : ");
        }
        if (this.requiredType != null) {
            s.append(this.requiredType.getName());
        }
        s.append(" \"");
        if (this.name != null) {
            s.append(this.name);
        }
        s.append("\" {");
        String prefix = "";
        for (String contentName : this.contentsByName.keySet()) {
            s.append(prefix);
            s.append(contentName);
            Object content = this.contentsByName.get(contentName);
            if (content instanceof List) {
                s.append("*");
                s.append(((List)content).size());
            }
            prefix = ",";
        }
        s.append("}");
        return s.toString();
    }
}

