/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.scoping;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class PivotScopeView
implements ScopeView {
    public static final ScopeView NULLSCOPEVIEW = new ScopeView(){

        public Attribution getAttribution() {
            return null;
        }

        public EObject getChild() {
            return null;
        }

        public EStructuralFeature getContainmentFeature() {
            return null;
        }

        public ScopeView getParent() {
            return NULLSCOPEVIEW;
        }

        public EObject getTarget() {
            return null;
        }

        public EReference getTargetReference() {
            return null;
        }
    };
    protected final MetaModelManager metaModelManager;
    protected final Attribution attribution;
    protected final Element target;
    protected final EObject child;
    protected final EStructuralFeature containmentFeature;
    protected final EReference targetReference;
    private ScopeView parent = null;

    public PivotScopeView(MetaModelManager metaModelManager, Element target, Attribution attribution, EObject child, EStructuralFeature containmentFeature, EReference targetReference) {
        this.metaModelManager = metaModelManager;
        this.attribution = attribution;
        this.target = target;
        this.child = child;
        this.containmentFeature = containmentFeature;
        this.targetReference = targetReference;
    }

    public Attribution getAttribution() {
        return this.attribution;
    }

    public EObject getChild() {
        return this.child;
    }

    public EStructuralFeature getContainmentFeature() {
        return this.containmentFeature;
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public ScopeView getParent() {
        if (this.parent == null) {
            EObject pParent;
            Element aParent = null;
            Attribution parentScope = null;
            if (this.target instanceof Element && (pParent = this.target.eContainer()) instanceof Element) {
                parentScope = PivotUtil.getAttribution(pParent);
                aParent = (Element)pParent;
            }
            if (parentScope == null) {
                this.parent = NULLSCOPEVIEW;
            } else {
                EStructuralFeature eContainingFeature = this.target.eContainingFeature();
                this.parent = new PivotScopeView(this.metaModelManager, aParent, parentScope, this.target, eContainingFeature, this.targetReference);
            }
        }
        return this.parent;
    }

    public final Element getTarget() {
        return this.target;
    }

    public EReference getTargetReference() {
        return this.targetReference;
    }

    public String toString() {
        Element target = this.getTarget();
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(target.eClass().getName());
        if (this.containmentFeature != null) {
            s.append("::");
            s.append(this.containmentFeature.getName());
        }
        s.append("] ");
        s.append(String.valueOf(target));
        return s.toString();
    }
}

