/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.AbstractPivotSaver;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotSaver
extends AbstractPivotSaver {
    public static AbstractPivotSaver.Factory FACTORY = new Factory();
    protected final Resource resource;
    private Map<String, Operation> operations = new HashMap<String, Operation>();
    private List<Element> specializingElements = new ArrayList<Element>();
    private Package orphanage = null;
    private Map<Type, Type> specializations = new HashMap<Type, Type>();
    private Class orphanageClass = null;

    public PivotSaver(Resource resource) {
        this.resource = resource;
    }

    @Override
    public void addSpecializingElement(Element object) {
        this.specializingElements.add(object);
    }

    @Override
    public boolean addSpecializingElement(Element object, Operation referredOperation) {
        if (referredOperation == null) {
            return false;
        }
        if (!this.isOrphanOperation(referredOperation)) {
            return false;
        }
        this.specializingElements.add(object);
        return true;
    }

    @Override
    public boolean addSpecializingElement(Element object, Type referredType) {
        if (referredType == null) {
            return false;
        }
        if (PivotUtil.isLibraryType(referredType)) {
            return false;
        }
        this.specializingElements.add(object);
        return true;
    }

    protected Package getOrphanPackage(Resource resource) {
        if (this.orphanage == null) {
            this.orphanage = PivotFactory.eINSTANCE.createPackage();
            this.orphanage.setName("$$");
            resource.getContents().add((Object)this.orphanage);
            this.orphanageClass = PivotFactory.eINSTANCE.createAnyType();
            this.orphanageClass.setName("$$");
            this.orphanage.getOwnedType().add((Object)this.orphanageClass);
        }
        return this.orphanage;
    }

    protected boolean isOrphanOperation(Operation operation) {
        return operation.getTemplateBinding().size() > 0;
    }

    public Package localizeSpecializations() {
        this.locateSpecializations((List<? extends EObject>)this.resource.getContents());
        if (this.specializingElements.size() > 0) {
            this.orphanage = this.getOrphanPackage(this.resource);
            int i = 0;
            while (i < this.specializingElements.size()) {
                Element element = this.specializingElements.get(i);
                AbstractPivotSaver.ResolveVisitor resolveVisitor = this.getResolveVisitor(element);
                if (resolveVisitor != null) {
                    resolveVisitor.safeVisit(element);
                }
                ++i;
            }
        }
        return this.orphanage;
    }

    protected void locateSpecializations(List<? extends EObject> eObjects) {
        for (EObject eObject : eObjects) {
            AbstractPivotSaver.LocateVisitor locateVisitor;
            if (eObject instanceof Visitable && (locateVisitor = this.getLocateVisitor(eObject)) != null) {
                locateVisitor.safeVisit((Visitable)eObject);
            }
            this.locateSpecializations((List<? extends EObject>)eObject.eContents());
        }
    }

    @Override
    public <T extends Operation> T resolveOperation(T referredOperation) {
        if (!this.isOrphanOperation(referredOperation)) {
            return referredOperation;
        }
        String moniker = Pivot2Moniker.toString(referredOperation);
        Operation operation = this.operations.get(moniker);
        if (operation != null) {
            Operation castOperation = operation;
            return (T)castOperation;
        }
        Operation resolvedOperation = (Operation)EcoreUtil.copy(referredOperation);
        this.orphanageClass.getOwnedOperation().add((Object)resolvedOperation);
        this.operations.put(moniker, resolvedOperation);
        String newMoniker = Pivot2Moniker.toString(resolvedOperation);
        assert (moniker.equals(newMoniker));
        this.locateSpecializations(Collections.singletonList(resolvedOperation));
        return (T)resolvedOperation;
    }

    @Override
    public <T extends Type> T resolveType(T referredType) {
        if (PivotUtil.isLibraryType(referredType)) {
            return referredType;
        }
        Type resolvedType = this.specializations.get(referredType);
        if (resolvedType == null) {
            resolvedType = (Type)EcoreUtil.copy(referredType);
            this.specializations.put(referredType, resolvedType);
            this.orphanage.getOwnedType().add((Object)resolvedType);
        }
        this.locateSpecializations(Collections.singletonList(resolvedType));
        return (T)resolvedType;
    }

    private static final class Factory
    implements AbstractPivotSaver.Factory {
        private Factory() {
            PivotSaver.addFactory(this);
        }

        public LocateVisitor createLocateVisitor(AbstractPivotSaver saver) {
            return new LocateVisitor(saver);
        }

        public ResolveVisitor createResolveVisitor(AbstractPivotSaver saver) {
            return new ResolveVisitor(saver);
        }

        public EPackage getEPackage() {
            return PivotPackage.eINSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocateVisitor
    extends AbstractExtendingVisitor<Object, AbstractPivotSaver>
    implements AbstractPivotSaver.LocateVisitor {
        protected LocateVisitor(AbstractPivotSaver context) {
            super(context);
        }

        @Override
        public Object visitClass(Class object) {
            for (Type superClass : object.getSuperClass()) {
                if (superClass.getTemplateBinding().size() <= 0) continue;
                ((AbstractPivotSaver)this.context).addSpecializingElement(object);
                break;
            }
            return null;
        }

        @Override
        public Object visitCollectionType(CollectionType object) {
            Type referredType = object.getElementType();
            ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredType);
            return super.visitCollectionType(object);
        }

        @Override
        public Object visitLambdaType(LambdaType object) {
            boolean doneIt = false;
            Type referredType = object.getContextType();
            if (((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredType)) {
                doneIt = true;
            }
            if (!doneIt) {
                referredType = object.getResultType();
                if (((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredType)) {
                    doneIt = true;
                }
                if (!doneIt) {
                    for (Type parameterType : object.getParameterType()) {
                        if (((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, parameterType)) break;
                    }
                }
            }
            return super.visitLambdaType(object);
        }

        @Override
        public Object visitLoopExp(LoopExp object) {
            Iteration referredIteration = object.getReferredIteration();
            ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredIteration);
            return super.visitLoopExp(object);
        }

        @Override
        public Object visitOperationCallExp(OperationCallExp object) {
            Operation referredOperation = object.getReferredOperation();
            ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredOperation);
            return super.visitOperationCallExp(object);
        }

        @Override
        public Object visitProperty(Property object) {
            Property opposite = object.getOpposite();
            if (opposite != null) {
                Resource eResource = opposite.eResource();
                assert (eResource != null);
            }
            return super.visitProperty(object);
        }

        @Override
        public Object visitTemplateParameterSubstitution(TemplateParameterSubstitution object) {
            ParameterableElement actual = object.getActual();
            if (actual instanceof Type) {
                ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, (Type)actual);
            }
            return null;
        }

        @Override
        public Object visitTypedElement(TypedElement object) {
            Type referredType = object.getType();
            ((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, referredType);
            return null;
        }

        @Override
        public Object visitTypeTemplateParameter(TypeTemplateParameter object) {
            for (Type constrainingType : object.getConstrainingType()) {
                if (((AbstractPivotSaver)this.context).addSpecializingElement((Element)object, constrainingType)) break;
            }
            return null;
        }

        @Override
        public Object visiting(Visitable visitable) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResolveVisitor
    extends AbstractExtendingVisitor<Object, AbstractPivotSaver>
    implements AbstractPivotSaver.ResolveVisitor {
        protected ResolveVisitor(AbstractPivotSaver saver) {
            super(saver);
        }

        @Override
        public Object visitClass(Class object) {
            EList<Type> superClasses = object.getSuperClass();
            int i = 0;
            while (i < superClasses.size()) {
                Type referredClass = (Type)superClasses.get(i);
                Type resolvedClass = ((AbstractPivotSaver)this.context).resolveType(referredClass);
                if (resolvedClass != null) {
                    superClasses.set(i, resolvedClass);
                }
                ++i;
            }
            return null;
        }

        @Override
        public Object visitClassifierType(ClassifierType object) {
            Type referredType = object.getInstanceType();
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            if (resolvedType != null) {
                object.setInstanceType(resolvedType);
            }
            return super.visitClassifierType(object);
        }

        @Override
        public Object visitCollectionType(CollectionType object) {
            Type referredType = object.getElementType();
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            if (resolvedType != null && resolvedType != referredType) {
                object.setElementType(resolvedType);
            }
            return super.visitCollectionType(object);
        }

        @Override
        public Object visitLambdaType(LambdaType object) {
            Type referredType = object.getContextType();
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            if (resolvedType != null) {
                object.setContextType(resolvedType);
            }
            if ((resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType = object.getResultType())) != null) {
                object.setResultType(resolvedType);
            }
            EList<Type> parameterTypes = object.getParameterType();
            int i = 0;
            while (i < parameterTypes.size()) {
                referredType = (Type)parameterTypes.get(i);
                resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
                if (resolvedType != null) {
                    parameterTypes.set(i, resolvedType);
                }
                ++i;
            }
            return super.visitLambdaType(object);
        }

        @Override
        public Object visitLoopExp(LoopExp object) {
            Iteration referredIteration = object.getReferredIteration();
            Iteration resolvedIteration = ((AbstractPivotSaver)this.context).resolveOperation(referredIteration);
            if (resolvedIteration != null) {
                object.setReferredIteration(resolvedIteration);
            }
            return null;
        }

        @Override
        public Object visitOperationCallExp(OperationCallExp object) {
            Operation referredOperation = object.getReferredOperation();
            Operation resolvedOperation = ((AbstractPivotSaver)this.context).resolveOperation(referredOperation);
            if (resolvedOperation != null) {
                object.setReferredOperation(resolvedOperation);
            }
            return null;
        }

        @Override
        public Object visitTemplateParameterSubstitution(TemplateParameterSubstitution object) {
            Type referredType = (Type)object.getActual();
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            if (resolvedType != null) {
                object.setActual(resolvedType);
            }
            return null;
        }

        @Override
        public Object visitTypeTemplateParameter(TypeTemplateParameter object) {
            EList<Type> constrainingTypes = object.getConstrainingType();
            int i = 0;
            while (i < constrainingTypes.size()) {
                Type referredType = (Type)constrainingTypes.get(i);
                Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
                if (resolvedType != null) {
                    constrainingTypes.set(i, resolvedType);
                }
                ++i;
            }
            return null;
        }

        @Override
        public Object visitTypedElement(TypedElement object) {
            Type referredType = object.getType();
            Type resolvedType = ((AbstractPivotSaver)this.context).resolveType(referredType);
            if (resolvedType != null) {
                object.setType(resolvedType);
            }
            return null;
        }

        @Override
        public Object visiting(Visitable visitable) {
            throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for PivotSaver Resolve pass");
        }
    }
}

