/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.common.utils.ClassUtils;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.BagType;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.OrderedSetType;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.SequenceType;
import org.eclipse.ocl.examples.pivot.SetType;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotSaver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotUtil
extends DomainUtil {
    private static final Logger logger = Logger.getLogger(PivotUtil.class);
    public static final String SCHEME_PIVOT = "pivot";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void appendMultiplicity(StringBuilder s, int lower, int upper) {
        if (upper < 0) {
            if (lower == 0) {
                s.append("[*]");
            } else if (lower == 1) {
                s.append("[+]");
            } else {
                s.append("[" + lower + "..*]");
            }
        } else if (upper == 1) {
            if (lower == 0) {
                s.append("[?]");
            }
        } else if (upper == lower) {
            s.append("[" + lower + "]");
        } else {
            s.append("[" + lower + ".." + upper + "]");
        }
    }

    public static void checkResourceErrors(String message, Resource resource) throws ParserException {
        EList errors = resource.getErrors();
        if (errors.size() > 0) {
            throw new SemanticException(PivotUtil.formatResourceDiagnostics((List<Resource.Diagnostic>)resource.getErrors(), message, "\n"));
        }
    }

    public static boolean conformsTo(EStructuralFeature eStructuralFeature, EClassifier contentType) {
        if (eStructuralFeature == null) {
            return true;
        }
        EClassifier targetType = eStructuralFeature.getEType();
        if (targetType == contentType) {
            return true;
        }
        if (!(targetType instanceof EClass)) {
            return false;
        }
        if (!(contentType instanceof EClass)) {
            return false;
        }
        return PivotUtil.conformsTo(targetType, contentType);
    }

    public static boolean conformsTo(EClassifier targetType, EClassifier contentType) {
        if (targetType == contentType) {
            return true;
        }
        if (!(targetType instanceof EClass)) {
            return false;
        }
        if (!(contentType instanceof EClass)) {
            return false;
        }
        return ((EClass)targetType).isSuperTypeOf((EClass)contentType);
    }

    public static String convertFromOCLString(String javaString) {
        char[] convtBuf;
        char[] in = javaString.toCharArray();
        int off = 0;
        int len = javaString.length();
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '\\') {
                if ((aChar = in[off++]) == 'u') {
                    int value = 0;
                    if (off + 4 > end) {
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 't') {
                    aChar = '\t';
                } else if (aChar == 'r') {
                    aChar = '\r';
                } else if (aChar == 'n') {
                    aChar = '\n';
                } else if (aChar == 'f') {
                    aChar = '\f';
                } else if (aChar == 'b') {
                    aChar = '\b';
                } else if (aChar == '\"') {
                    aChar = '\"';
                } else if (aChar == '\'') {
                    aChar = '\'';
                } else if (aChar == '\\') {
                    aChar = '\\';
                } else {
                    throw new IllegalArgumentException("Illegal escape character \\" + aChar);
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String convertToOCLString(String theString) {
        if (theString == null) {
            return null;
        }
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '\b': {
                        outBuffer.append('\\');
                        outBuffer.append('b');
                        break;
                    }
                    case '\'': {
                        outBuffer.append('\\');
                        outBuffer.append('\'');
                        break;
                    }
                    default: {
                        if (aChar < ' ' || aChar > '~') {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(PivotUtil.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(PivotUtil.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(PivotUtil.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(PivotUtil.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public static void debugObjectUsage(String prefix, EObject element) {
        StringBuilder s = new StringBuilder();
        s.append(prefix);
        if (element != null) {
            s.append(element.eClass().getName());
            s.append("@");
            s.append(Integer.toHexString(element.hashCode()));
            Resource eResource = element.eResource();
            if (eResource != null) {
                if (element instanceof Element) {
                    s.append(" ");
                    s.append(Pivot2Moniker.toString((Element)element));
                }
                s.append(" ");
                s.append(eResource.getURI());
            } else if (element instanceof NamedElement) {
                s.append(" ");
                s.append(String.valueOf(((NamedElement)element).getName()));
            }
        } else {
            s.append("null");
        }
        System.out.println(s.toString());
    }

    public static boolean debugWellContainedness(Type type) {
        if (type.eResource() == null) {
            PivotUtil.debugObjectUsage("Badly contained ", type);
            return false;
        }
        if (type instanceof CollectionType && !PivotUtil.debugWellContainedness(((CollectionType)type).getElementType())) {
            PivotUtil.debugObjectUsage("Badly contained ", type);
            return false;
        }
        return true;
    }

    public static Type findTypeOf(MetaModelManager metaModelManager, EClassifier eClass) {
        Type type;
        Ecore2Pivot adapter;
        Resource resource = eClass.eResource();
        if (resource != null && (adapter = Ecore2Pivot.findAdapter(resource, metaModelManager)) != null && (type = adapter.getCreated(Type.class, (EObject)eClass)) != null) {
            return type;
        }
        return null;
    }

    public static String formatResourceDiagnostics(List<Resource.Diagnostic> diagnostics, String messagePrefix, String newLine) {
        if (diagnostics.size() <= 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(messagePrefix);
        for (Resource.Diagnostic diagnostic : diagnostics) {
            s.append(newLine);
            String location = diagnostic.getLocation();
            if (location != null) {
                s.append(location);
                s.append(":");
            }
            s.append(diagnostic.getLine());
            try {
                int column = diagnostic.getColumn();
                s.append(":");
                s.append(column);
            }
            catch (Exception exception) {
                // empty catch block
            }
            s.append(": ");
            s.append(diagnostic.getMessage());
        }
        return s.toString();
    }

    public static <T> T getAdapter(Class<T> adapterClass, Notifier notifier) {
        return PivotUtil.getAdapter(adapterClass, (List<Adapter>)notifier.eAdapters());
    }

    public static <T> T getAdapter(Class<T> adapterClass, List<Adapter> eAdapters) {
        Adapter adapter = EcoreUtil.getAdapter(eAdapters, adapterClass);
        if (adapter == null) {
            return null;
        }
        if (!adapterClass.isAssignableFrom(adapter.getClass())) {
            throw new ClassCastException(String.valueOf(adapter.getClass().getName()) + " is not assignable to " + adapterClass.getName());
        }
        Adapter castAdapter = adapter;
        return (T)castAdapter;
    }

    public static List<TemplateParameter> getAllTemplateParameters(Collection<TemplateBinding> templateBindings) {
        List<TemplateParameter> list = null;
        for (TemplateBinding templateBinding : templateBindings) {
            EList<TemplateParameter> templateParameters;
            TemplateSignature templateSignature = templateBinding.getSignature();
            if (templateSignature == null || (templateParameters = templateSignature.getParameter()).size() <= 0) continue;
            if (list == null) {
                list = new ArrayList<TemplateParameter>();
            }
            list.addAll((Collection<TemplateParameter>)templateParameters);
        }
        return list != null ? list : Collections.emptyList();
    }

    public static List<List<TemplateParameter>> getAllTemplateParameterLists(EObject eObject) {
        List<List<TemplateParameter>> result = null;
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            result = PivotUtil.getAllTemplateParameterLists(eContainer);
        }
        if (eObject instanceof TemplateableElement) {
            EList<TemplateParameter> templateParameters;
            TemplateSignature templateSignature;
            TemplateableElement unspecializedTemplateableElement = (TemplateableElement)eObject;
            if (eObject instanceof Type) {
                eObject = PivotUtil.getUnspecializedTemplateableElement((Type)eObject);
            }
            if ((templateSignature = unspecializedTemplateableElement.getOwnedTemplateSignature()) != null && (templateParameters = templateSignature.getParameter()).size() > 0) {
                if (result == null) {
                    result = new ArrayList<List<TemplateParameter>>();
                }
                result.add((List<TemplateParameter>)templateParameters);
            }
        }
        return result;
    }

    public static List<TemplateParameter> getAllTemplateParameters(EObject eObject) {
        List<TemplateParameter> result = null;
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            result = PivotUtil.getAllTemplateParameters(eContainer);
        }
        if (eObject instanceof TemplateableElement) {
            EList<TemplateParameter> templateParameters;
            TemplateSignature templateSignature;
            TemplateableElement unspecializedTemplateableElement = (TemplateableElement)eObject;
            if (eObject instanceof Type) {
                eObject = PivotUtil.getUnspecializedTemplateableElement((Type)eObject);
            }
            if ((templateSignature = unspecializedTemplateableElement.getOwnedTemplateSignature()) != null && (templateParameters = templateSignature.getParameter()).size() > 0) {
                if (result == null) {
                    result = new ArrayList<TemplateParameter>();
                }
                result.addAll((Collection<TemplateParameter>)templateParameters);
            }
        }
        return result;
    }

    public static Map<TemplateParameter, ParameterableElement> getAllTemplateParametersAsBindings(EObject eObject) {
        EList<TemplateParameter> templateParameters;
        TemplateSignature templateSignature;
        if (eObject instanceof Type) {
            eObject = PivotUtil.getUnspecializedTemplateableElement((Type)eObject);
        }
        Map<TemplateParameter, ParameterableElement> result = null;
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            result = PivotUtil.getAllTemplateParametersAsBindings(eContainer);
        }
        if (eObject instanceof TemplateableElement && (templateSignature = ((TemplateableElement)eObject).getOwnedTemplateSignature()) != null && (templateParameters = templateSignature.getParameter()).size() > 0) {
            if (result == null) {
                result = new HashMap<TemplateParameter, ParameterableElement>();
            }
            for (TemplateParameter templateParameter : templateSignature.getParameter()) {
                result.put(templateParameter, null);
            }
        }
        return result;
    }

    public static Map<TemplateParameter, ParameterableElement> getAllTemplateParameterSubstitutions(Map<TemplateParameter, ParameterableElement> map, TemplateableElement templateableElement) {
        TemplateableElement eObject = templateableElement;
        while (eObject != null) {
            if (eObject instanceof TemplateableElement) {
                for (TemplateBinding templateBinding : eObject.getTemplateBinding()) {
                    for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitution()) {
                        if (map == null) {
                            map = new HashMap<TemplateParameter, ParameterableElement>();
                        }
                        map.put(templateParameterSubstitution.getFormal(), templateParameterSubstitution.getActual());
                    }
                }
            }
            if (eObject instanceof Type) {
                for (Type superType : ((Type)eObject).getSuperClass()) {
                    map = PivotUtil.getAllTemplateParameterSubstitutions(map, superType);
                }
            }
            eObject = eObject.eContainer();
        }
        return map;
    }

    public static Map<TemplateParameter, ParameterableElement> getAllTemplateParameterSubstitutions(Map<TemplateParameter, ParameterableElement> bindings, Type argumentType, LambdaType lambdaType) {
        TemplateParameter resultTemplateParameter;
        Type resultType = lambdaType.getResultType();
        if (resultType != null && (resultTemplateParameter = resultType.getOwningTemplateParameter()) != null) {
            if (bindings == null) {
                bindings = new HashMap<TemplateParameter, ParameterableElement>();
            }
            bindings.put(resultTemplateParameter, argumentType);
        }
        return bindings;
    }

    public static Attribution getAttribution(EObject eObject) {
        if (eObject == null) {
            logger.warn((Object)"getAttribution for null");
            return null;
        }
        if (eObject.eIsProxy()) {
            logger.warn((Object)("getAttribution for proxy " + eObject));
            return null;
        }
        EClass eClass = eObject.eClass();
        Attribution attribution = Attribution.REGISTRY.get(eClass);
        if (attribution == null) {
            EClass superClass = eClass;
            while (superClass.getESuperTypes().size() > 0) {
                attribution = Attribution.REGISTRY.get(superClass = (EClass)superClass.getESuperTypes().get(0));
                if (attribution == null) continue;
                Attribution.REGISTRY.put((EClassifier)eClass, attribution);
                break;
            }
        }
        return attribution;
    }

    public static Type getBehavioralType(Type type) {
        DataType dataType;
        Type behavioralType;
        if (type instanceof DataType && (behavioralType = (dataType = (DataType)type).getBehavioralType()) != null) {
            return behavioralType;
        }
        return type;
    }

    public static String getBody(OpaqueExpression specification) {
        EList<String> bodies = specification.getBody();
        EList<String> languages = specification.getLanguage();
        if (bodies == null || languages == null) {
            return null;
        }
        int iMax = Math.min(bodies.size(), languages.size());
        int i = 0;
        while (i < iMax) {
            if ("OCL".equalsIgnoreCase((String)languages.get(i))) {
                return (String)bodies.get(i);
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind getCollectionKind(CollectionType collectionType) {
        if (collectionType instanceof OrderedSetType) {
            return CollectionKind.ORDERED_SET;
        }
        if (collectionType instanceof SequenceType) {
            return CollectionKind.SEQUENCE;
        }
        if (collectionType instanceof SetType) {
            return CollectionKind.SET;
        }
        if (collectionType instanceof BagType) {
            return CollectionKind.BAG;
        }
        return CollectionKind.COLLECTION;
    }

    public static String getConstraintTypeName(ExpressionInOCL expression) {
        return ((NamedElement)expression.eContainer().eContainer()).getName();
    }

    public static String getConstraintTypeName(Constraint constraint) {
        return ((NamedElement)constraint.eContainer()).getName();
    }

    public static int getContainmentDepth(EObject eObject) {
        int depth = 0;
        EObject eContainer = eObject.eContainer();
        while (eContainer != null) {
            if (++depth > 100000) {
                return depth;
            }
            eContainer = eContainer.eContainer();
        }
        return depth;
    }

    public static <T extends NamedElement> T getNamedElement(Iterable<T> elements, String name) {
        if (elements == null) {
            return null;
        }
        for (NamedElement element : elements) {
            if (!ClassUtils.equals((Object)name, (Object)element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    public static Type getOwningType(Feature feature) {
        Type owner = null;
        if (feature instanceof Property) {
            owner = ((Property)feature).getOwningType();
        } else if (feature instanceof Operation) {
            owner = ((Operation)feature).getOwningType();
        }
        return owner;
    }

    public static Package getPackage(EObject object) {
        EObject eObject = object;
        while (eObject != null) {
            if (eObject instanceof Package) {
                return (Package)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static Element getLowerBound(Element element) {
        if (element instanceof UnspecifiedType) {
            return ((UnspecifiedType)element).getLowerBound();
        }
        return element;
    }

    public static String getMessage(OpaqueExpression specification) {
        EList<String> messages = specification.getMessage();
        EList<String> languages = specification.getLanguage();
        if (messages == null || languages == null) {
            return null;
        }
        int iMax = Math.min(messages.size(), languages.size());
        int i = 0;
        while (i < iMax) {
            if ("OCL".equalsIgnoreCase((String)languages.get(i))) {
                return (String)messages.get(i);
            }
            ++i;
        }
        return null;
    }

    public static Namespace getNamespace(EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Type) {
                return (Namespace)eObject;
            }
            if (eObject instanceof Package) {
                return (Namespace)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static URI getNonPivotURI(URI uri) {
        assert (PivotUtil.isPivotURI(uri));
        String[] oldSegments = uri.segments();
        String[] newSegments = new String[oldSegments.length - 1];
        newSegments[0] = uri.scheme();
        System.arraycopy(oldSegments, 1, newSegments, 0, oldSegments.length - 1);
        URI pivotURI = URI.createHierarchicalURI((String)oldSegments[0], (String)uri.authority(), (String)uri.device(), (String[])newSegments, (String)uri.query(), (String)uri.fragment());
        return pivotURI;
    }

    public static <T extends Element> T getPivot(Class<T> pivotClass, Pivotable pivotableElement) {
        if (pivotableElement == null) {
            return null;
        }
        Element pivotElement = pivotableElement.getPivot();
        if (pivotElement == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException(String.valueOf(pivotElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    public static URI getPivotURI(URI uri) {
        String oldScheme = uri.scheme();
        if (oldScheme == null) {
            oldScheme = "null";
        }
        String[] oldSegments = uri.segments();
        String[] newSegments = new String[oldSegments.length + 1];
        newSegments[0] = oldScheme;
        System.arraycopy(oldSegments, 0, newSegments, 1, oldSegments.length);
        URI pivotURI = URI.createHierarchicalURI((String)SCHEME_PIVOT, (String)uri.authority(), (String)uri.device(), (String[])newSegments, (String)uri.query(), (String)uri.fragment());
        return pivotURI;
    }

    public static Feature getReferredFeature(CallExp callExp) {
        Feature feature = null;
        if (callExp instanceof LoopExp) {
            feature = ((LoopExp)callExp).getReferredIteration();
        } else if (callExp instanceof OperationCallExp) {
            feature = ((OperationCallExp)callExp).getReferredOperation();
        } else if (callExp instanceof PropertyCallExp) {
            feature = ((PropertyCallExp)callExp).getReferredProperty();
        }
        return feature;
    }

    public static Operation getReferredOperation(CallExp callExp) {
        Operation operation = null;
        if (callExp instanceof LoopExp) {
            operation = ((LoopExp)callExp).getReferredIteration();
        } else if (callExp instanceof OperationCallExp) {
            operation = ((OperationCallExp)callExp).getReferredOperation();
        }
        return operation;
    }

    public static List<TemplateParameter> getTemplateParameters(TemplateableElement templateableElement) {
        TemplateSignature ownedTemplateSignature;
        if (templateableElement != null && (ownedTemplateSignature = templateableElement.getOwnedTemplateSignature()) != null) {
            return ownedTemplateSignature.getParameter();
        }
        return Collections.emptyList();
    }

    public static List<ParameterableElement> getTemplateParameterables(TemplateableElement templateableElement) {
        if (templateableElement == null) {
            return Collections.emptyList();
        }
        TemplateSignature ownedTemplateSignature = templateableElement.getOwnedTemplateSignature();
        if (ownedTemplateSignature == null) {
            return Collections.emptyList();
        }
        EList<TemplateParameter> templateParameters = ownedTemplateSignature.getParameter();
        if (templateParameters.size() == 0) {
            return Collections.emptyList();
        }
        if (templateParameters.size() == 1) {
            return Collections.singletonList(((TemplateParameter)templateParameters.get(0)).getParameteredElement());
        }
        ArrayList<ParameterableElement> results = new ArrayList<ParameterableElement>(templateParameters.size());
        for (TemplateParameter templateParameter : templateParameters) {
            results.add(templateParameter.getParameteredElement());
        }
        return results;
    }

    public static MetaModelManager getMetaModelManager(Resource resource) {
        MetaModelManagerResourceAdapter adapter = MetaModelManagerResourceAdapter.getAdapter(resource, null);
        MetaModelManager metaModelManager = adapter.getMetaModelManager();
        assert (metaModelManager != null);
        return metaModelManager;
    }

    public static String getNsURI(EModelElement element) {
        String nsURI;
        if (element instanceof EPackage && (nsURI = ((EPackage)element).getNsURI()) != null) {
            return nsURI;
        }
        StringBuilder s = new StringBuilder();
        PivotUtil.getNsURI(s, (EObject)element);
        return s.toString();
    }

    public static String getNsURI(Element element) {
        String nsURI;
        if (element instanceof Package && (nsURI = ((Package)element).getNsURI()) != null) {
            return nsURI;
        }
        StringBuilder s = new StringBuilder();
        s.append("u_r_i:");
        PivotUtil.getNsURI(s, element);
        return s.toString();
    }

    private static void getNsURI(StringBuilder s, EObject element) {
        String nsURI;
        EObject eContainer;
        String nsURI2;
        if (element instanceof Package) {
            nsURI2 = ((Package)element).getNsURI();
            if (nsURI2 != null) {
                s.append(nsURI2);
                return;
            }
        } else if (element instanceof EPackage && (nsURI2 = ((EPackage)element).getNsURI()) != null) {
            s.append(nsURI2);
            return;
        }
        if ((eContainer = element.eContainer()) instanceof Package) {
            nsURI = ((Package)element).getNsURI();
            if (nsURI != null) {
                s.append(nsURI);
                s.append("#/");
            } else {
                PivotUtil.getNsURI(s, eContainer);
            }
        } else if (eContainer instanceof EPackage) {
            nsURI = ((EPackage)element).getNsURI();
            if (nsURI != null) {
                s.append(nsURI);
                s.append("#/");
            } else {
                PivotUtil.getNsURI(s, eContainer);
            }
        } else {
            if (eContainer == null) {
                String name = null;
                if (element instanceof Package) {
                    name = ((Package)element).getName();
                } else if (element instanceof EPackage) {
                    name = ((EPackage)element).getName();
                }
                if (name == null) {
                    name = "$null$";
                }
                s.append(name);
                return;
            }
            PivotUtil.getNsURI(s, eContainer);
        }
        EReference eFeature = element.eContainmentFeature();
        s.append("@");
        s.append(eFeature.getName());
        if (eFeature.isMany()) {
            int index = ((List)eContainer.eGet(element.eContainingFeature())).indexOf(element);
            s.append(".");
            s.append(index);
        }
    }

    public static List<Type> getTypeTemplateParameterables(TemplateableElement templateableElement) {
        if (templateableElement == null) {
            return Collections.emptyList();
        }
        TemplateSignature ownedTemplateSignature = templateableElement.getOwnedTemplateSignature();
        if (ownedTemplateSignature == null) {
            return Collections.emptyList();
        }
        EList<TemplateParameter> templateParameters = ownedTemplateSignature.getParameter();
        if (templateParameters.size() == 0) {
            return Collections.emptyList();
        }
        if (templateParameters.size() == 1) {
            return Collections.singletonList((Type)((TemplateParameter)templateParameters.get(0)).getParameteredElement());
        }
        ArrayList<Type> results = new ArrayList<Type>(templateParameters.size());
        for (TemplateParameter templateParameter : templateParameters) {
            results.add((Type)templateParameter.getParameteredElement());
        }
        return results;
    }

    public static <T extends Type> T getUnspecializedTemplateableElement(T templateableElement) {
        if (templateableElement == null) {
            return null;
        }
        TemplateableElement unspecializedElement = templateableElement.getUnspecializedElement();
        if (unspecializedElement == null) {
            return templateableElement;
        }
        Type castUnspecializedElement = (Type)unspecializedElement;
        return (T)castUnspecializedElement;
    }

    public static boolean isLibraryType(Type type) {
        if (type instanceof LambdaType) {
            return false;
        }
        if (type instanceof TupleType) {
            return false;
        }
        return type.getTemplateBinding().isEmpty();
    }

    public static boolean isPivotURI(URI uri) {
        return SCHEME_PIVOT.equals(uri.scheme()) && uri.segments().length > 0;
    }

    public static boolean isValidIdentifier(String value) {
        if (value == null) {
            return false;
        }
        int iMax = value.length();
        int i = 0;
        while (i < iMax) {
            char c = value.charAt(i);
            if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || c == '_' || '0' <= c && c <= '9' && i > 0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void localizeSpecializations(Resource pivotResource) {
        PivotSaver saver = new PivotSaver(pivotResource);
        saver.localizeSpecializations();
    }

    public static <T extends EObject> void refreshList(List<? super T> elements, List<? extends T> newElements) {
        int k = newElements.size();
        while (k-- > 0) {
            EObject newElement = (EObject)newElements.get(k);
            if (!newElement.eIsProxy()) continue;
            elements.remove(newElement);
        }
        k = elements.size();
        while (k-- > 0) {
            T oldElement = elements.get(k);
            if (newElements.contains(oldElement)) continue;
            elements.remove(k);
        }
        int newMax = newElements.size();
        int i = 0;
        while (i < newMax) {
            EObject newElement = (EObject)newElements.get(i);
            int oldMax = elements.size();
            boolean reused = false;
            int j = i;
            while (j < oldMax) {
                T oldElement = elements.get(j);
                if (oldElement == newElement) {
                    if (j != i) {
                        elements.remove(j);
                        elements.add(i, newElement);
                    }
                    reused = true;
                    break;
                }
                ++j;
            }
            if (!reused) {
                if (i < oldMax) {
                    elements.add(i, newElement);
                } else {
                    elements.add(newElement);
                }
            }
            assert (newElements.get(i) == elements.get(i));
            ++i;
        }
        int k2 = elements.size();
        while (k2 > newMax) {
            elements.remove(--k2);
        }
        assert (newElements.size() == elements.size());
    }

    public static <T extends EObject> void refreshSet(List<? super T> oldElements, Collection<? extends T> newElements) {
        int i = oldElements.size();
        while (i-- > 0) {
            T oldElement = oldElements.get(i);
            if (newElements.contains(oldElement)) continue;
            oldElements.remove(i);
        }
        for (EObject newElement : newElements) {
            if (newElement.eIsProxy() || oldElements.contains(newElement)) continue;
            oldElements.add(newElement);
        }
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrecedenceComparator
    implements Comparator<Precedence> {
        public static final PrecedenceComparator INSTANCE = new PrecedenceComparator();

        @Override
        public int compare(Precedence p1, Precedence p2) {
            int o1 = p1 != null ? p1.getOrder().intValue() : -1;
            int o2 = p2 != null ? p2.getOrder().intValue() : -1;
            return o1 - o2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateParameterSubstitutionComparator
    implements Comparator<TemplateParameterSubstitution> {
        public static Comparator<? super TemplateParameterSubstitution> INSTANCE = new TemplateParameterSubstitutionComparator();

        @Override
        public int compare(TemplateParameterSubstitution o1, TemplateParameterSubstitution o2) {
            TemplateParameter f1 = o1.getFormal();
            TemplateParameter f2 = o2.getFormal();
            int i1 = f1.getSignature().getParameter().indexOf((Object)f1);
            int i2 = f2.getSignature().getParameter().indexOf((Object)f2);
            return i1 - i2;
        }
    }
}

