/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.AssociationClassCallExp;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.FeatureCallExp;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.MessageExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StateExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.UnspecifiedValueExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Nameable;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToStringVisitor
extends AbstractExtendingVisitor<String, String> {
    private static final Logger logger = Logger.getLogger(ToStringVisitor.class);
    private static Map<EPackage, Factory> factoryMap = new HashMap<EPackage, Factory>();
    public static Factory FACTORY = new MyFactory();
    protected static String NULL_PLACEHOLDER = "\"<null>\"";
    protected StringBuilder result = new StringBuilder();

    public static void addFactory(Factory factory) {
        factoryMap.put(factory.getEPackage(), factory);
    }

    public static ToStringVisitor create(EObject eObject) {
        EPackage ePackage = eObject.eClass().getEPackage();
        Factory factory = factoryMap.get(ePackage);
        if (factory != null) {
            return factory.createToStringVisitor();
        }
        logger.error((Object)("No ToStringVisitor Factory registered for " + ePackage.getName()));
        return null;
    }

    protected ToStringVisitor() {
        super(null);
    }

    protected void append(Number number) {
        if (number != null) {
            this.result.append(number.toString());
        } else {
            this.result.append(NULL_PLACEHOLDER);
        }
    }

    protected void append(String string) {
        if (string != null) {
            this.result.append(string);
        } else {
            this.result.append(NULL_PLACEHOLDER);
        }
    }

    protected void appendAtPre(FeatureCallExp mpc) {
        if (mpc.isPre()) {
            this.append("@pre");
        }
    }

    protected void appendName(Nameable object) {
        if (object == null) {
            this.result.append(NULL_PLACEHOLDER);
        } else {
            this.result.append(object.getName());
        }
    }

    protected void appendQualifiedName(NamedElement object) {
        if (object == null) {
            this.result.append(NULL_PLACEHOLDER);
        } else {
            EObject container = object.eContainer();
            if (container instanceof NamedElement) {
                this.appendQualifiedName((NamedElement)container);
                this.append("::");
            }
            this.appendName(object);
            if (object instanceof TemplateableElement) {
                TemplateableElement templateableElement = (TemplateableElement)((Object)object);
                this.appendTemplateBindings((List<TemplateBinding>)templateableElement.getTemplateBinding());
                this.appendTemplateSignature(templateableElement.getOwnedTemplateSignature());
            }
        }
    }

    protected void appendOperationSignature(Operation operation) {
        this.appendName(operation);
        this.append("(");
        boolean comma = false;
        for (Parameter parm : operation.getOwnedParameter()) {
            if (comma) {
                this.append(", ");
            } else {
                comma = true;
            }
            this.appendName(parm);
            this.append(" : ");
            if (parm.getType() != null) {
                this.appendName(parm.getType());
                continue;
            }
            this.append("OclVoid");
        }
        this.append(") :");
        if (operation.getType() != null) {
            this.append(" ");
            this.appendName(operation.getType());
        }
    }

    protected void appendQualifiedName(NamedElement parent, String separator, NamedElement child) {
        if (parent != null) {
            this.appendQualifiedName(parent);
            this.append(separator);
        }
        this.appendName(child);
    }

    protected void appendPropertySignature(Property property) {
        this.appendName(property);
        if (property.getType() != null) {
            this.append(" : ");
            this.appendName(property.getType());
        }
    }

    protected void appendTemplateBindings(List<TemplateBinding> templateBindings) {
        if (templateBindings.size() > 0) {
            this.append("(");
            String prefix = "";
            for (TemplateBinding templateBinding : templateBindings) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitution()) {
                    this.append(prefix);
                    this.safeVisit(templateParameterSubstitution.getActual());
                    prefix = ",";
                }
            }
            this.append(")");
        }
    }

    protected void appendTemplateSignature(TemplateSignature templateSignature) {
        EList<TemplateParameter> templateParameters;
        if (templateSignature != null && !(templateParameters = templateSignature.getOwnedParameter()).isEmpty()) {
            this.append("(");
            String prefix = "";
            for (TemplateParameter templateParameter : templateParameters) {
                this.append(prefix);
                this.safeVisit(templateParameter.getParameteredElement());
                prefix = ",";
            }
            this.append(")");
        }
    }

    protected void appendType(Type type) {
        if (type != null && type.eClass() == PivotPackage.Literals.CLASS && type.eContainer() instanceof NamedElement) {
            this.appendQualifiedName((NamedElement)type.eContainer());
            this.append("::");
        }
        this.appendName(type);
    }

    public String toString() {
        return this.result.toString();
    }

    @Override
    public String visitAnyType(AnyType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitAssociationClassCallExp(AssociationClassCallExp ac) {
        this.safeVisit(ac.getSource());
        this.append(".");
        this.appendName(ac.getReferredAssociationClass());
        this.appendAtPre(ac);
        EList<OCLExpression> qualifiers = ac.getQualifier();
        if (!qualifiers.isEmpty()) {
            this.append("[");
            this.safeVisit((Visitable)qualifiers.get(0));
            this.append("]");
        }
        return null;
    }

    @Override
    public String visitBooleanLiteralExp(BooleanLiteralExp bl) {
        this.append(Boolean.toString(bl.isBooleanSymbol()));
        return null;
    }

    @Override
    public String visitClass(Class cls) {
        TemplateParameter owningTemplateParameter = cls.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            this.appendName(cls);
        } else {
            Package pkg = cls.getPackage();
            if (pkg == null) {
                this.append("null::");
                this.appendName(cls);
            } else if (pkg.eContainer() != null || !"ocl".equals(pkg.getName())) {
                this.appendQualifiedName(pkg, "::", cls);
            } else {
                this.appendName(cls);
            }
            this.appendTemplateBindings((List<TemplateBinding>)cls.getTemplateBinding());
            this.appendTemplateSignature(cls.getOwnedTemplateSignature());
        }
        return null;
    }

    @Override
    public String visitClassifierType(ClassifierType object) {
        this.appendName(object);
        if (object.getTemplateBinding().size() > 0) {
            this.appendTemplateBindings((List<TemplateBinding>)object.getTemplateBinding());
        } else if (object.getInstanceType() != null) {
            this.append("<");
            this.appendQualifiedName(object.getInstanceType());
            this.append(">");
        }
        this.appendTemplateSignature(object.getOwnedTemplateSignature());
        return null;
    }

    @Override
    public String visitCollectionItem(CollectionItem item) {
        this.safeVisit(item.getItem());
        return null;
    }

    @Override
    public String visitCollectionLiteralExp(CollectionLiteralExp cl) {
        switch (cl.getKind()) {
            case SET: {
                this.append("Set {");
                break;
            }
            case ORDERED_SET: {
                this.append("OrderedSet {");
                break;
            }
            case BAG: {
                this.append("Bag {");
                break;
            }
            case SEQUENCE: {
                this.append("Sequence {");
                break;
            }
            default: {
                this.append("Collection {");
            }
        }
        boolean isFirst = true;
        for (CollectionLiteralPart part : cl.getPart()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(part);
            isFirst = false;
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitCollectionRange(CollectionRange range) {
        this.safeVisit(range.getFirst());
        this.append(" .. ");
        this.safeVisit(range.getLast());
        return null;
    }

    @Override
    public String visitCollectionType(CollectionType object) {
        this.appendName(object);
        this.appendTemplateBindings((List<TemplateBinding>)object.getTemplateBinding());
        this.appendTemplateSignature(object.getOwnedTemplateSignature());
        return null;
    }

    @Override
    public String visitConstraint(Constraint constraint) {
        EList<Element> constrained = constraint.getConstrainedElement();
        if (!constrained.isEmpty()) {
            EObject elem = (EObject)constrained.get(0);
            this.append("context ");
            if (elem instanceof Type) {
                this.appendName((NamedElement)elem);
            } else if (elem instanceof Operation) {
                Operation oper = (Operation)elem;
                this.appendOperationSignature(oper);
            } else if (elem instanceof Property) {
                Property prop = (Property)elem;
                this.appendPropertySignature(prop);
            }
            this.append(" ");
        }
        String stereo = constraint.getStereotype();
        this.append(stereo);
        String name = constraint.getName();
        if (name != null) {
            this.append(" ");
            this.append(name);
        }
        this.append(": ");
        this.safeVisit(constraint.getSpecification());
        return null;
    }

    @Override
    public String visitConstructorExp(ConstructorExp constructorExp) {
        this.appendQualifiedName(constructorExp.getType());
        this.append("{");
        String prefix = "";
        for (ConstructorPart part : constructorExp.getPart()) {
            this.append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitConstructorPart(ConstructorPart part) {
        this.appendName(part.getReferredProperty());
        OCLExpression initExpression = part.getInitExpression();
        if (initExpression != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public String visitEnumLiteralExp(EnumLiteralExp el) {
        this.appendQualifiedName(el.getReferredEnumLiteral());
        return null;
    }

    @Override
    public String visitEnumerationLiteral(EnumerationLiteral el) {
        this.appendQualifiedName(el.getEnumeration(), "::", el);
        return null;
    }

    @Override
    public String visitExpressionInOCL(ExpressionInOCL expression) {
        return (String)this.safeVisit(expression.getBodyExpression());
    }

    @Override
    public String visitIfExp(IfExp ifExp) {
        this.append("if ");
        this.safeVisit(ifExp.getCondition());
        this.append(" then ");
        this.safeVisit(ifExp.getThenExpression());
        this.append(" else ");
        this.safeVisit(ifExp.getElseExpression());
        this.append(" endif");
        return null;
    }

    @Override
    public String visitIntegerLiteralExp(IntegerLiteralExp il) {
        this.append(il.getIntegerSymbol());
        return null;
    }

    @Override
    public String visitInvalidLiteralExp(InvalidLiteralExp il) {
        this.append("invalid");
        return null;
    }

    @Override
    public String visitInvalidType(InvalidType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitIterateExp(IterateExp callExp) {
        this.safeVisit(callExp.getSource());
        this.append("->");
        this.appendName(callExp.getReferredIteration());
        this.append("(");
        boolean isFirst = true;
        for (Variable variable : callExp.getIterator()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(variable);
            isFirst = false;
        }
        this.append("; ");
        this.safeVisit(callExp.getResult());
        this.append(" | ");
        this.safeVisit(callExp.getBody());
        this.append(")");
        return null;
    }

    @Override
    public String visitIteration(Iteration iteration) {
        this.appendQualifiedName(iteration.getOwningType(), ".", iteration);
        this.appendTemplateBindings((List<TemplateBinding>)iteration.getTemplateBinding());
        this.appendTemplateSignature(iteration.getOwnedTemplateSignature());
        this.append("(");
        boolean isFirst = true;
        for (Parameter parameter : iteration.getOwnedIterator()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.appendQualifiedName(parameter.getType());
            isFirst = false;
        }
        isFirst = true;
        for (Parameter parameter : iteration.getOwnedAccumulator()) {
            if (!isFirst) {
                this.append(", ");
            } else {
                this.append("; ");
            }
            this.appendQualifiedName(parameter.getType());
            isFirst = false;
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitIteratorExp(IteratorExp callExp) {
        this.safeVisit(callExp.getSource());
        this.append("->");
        this.appendName(callExp.getReferredIteration());
        this.append("(");
        boolean isFirst = true;
        for (Variable variable : callExp.getIterator()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(variable);
            isFirst = false;
        }
        this.append(" | ");
        this.safeVisit(callExp.getBody());
        this.append(")");
        return null;
    }

    @Override
    public String visitLambdaType(LambdaType lambda) {
        this.appendName(lambda);
        Type contextType = lambda.getContextType();
        if (contextType != null) {
            this.append(" ");
            this.appendType(contextType);
            this.appendTemplateSignature(lambda.getOwnedTemplateSignature());
            this.append("(");
            boolean isFirst = true;
            for (Type parameterType : lambda.getParameterType()) {
                if (!isFirst) {
                    this.append(",");
                }
                this.appendType(parameterType);
                isFirst = false;
            }
            this.append(") : ");
            this.appendType(lambda.getResultType());
        }
        return null;
    }

    @Override
    public String visitLetExp(LetExp letExp) {
        this.append("let ");
        this.safeVisit(letExp.getVariable());
        this.append(" in ");
        this.safeVisit(letExp.getIn());
        return null;
    }

    @Override
    public String visitMessageExp(MessageExp messageExp) {
        this.safeVisit(messageExp.getTarget());
        this.append(messageExp.getType() instanceof CollectionType ? "^^" : "^");
        if (messageExp.getCalledOperation() != null) {
            this.appendName(messageExp.getCalledOperation().getOperation());
        } else if (messageExp.getSentSignal() != null) {
            this.appendName(messageExp.getSentSignal().getSignal());
        }
        this.append("(");
        String prefix = "";
        for (OCLExpression argument : messageExp.getArgument()) {
            this.append(prefix);
            this.safeVisit(argument);
            prefix = ", ";
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitNullLiteralExp(NullLiteralExp il) {
        this.append("null");
        return null;
    }

    @Override
    public String visitOpaqueExpression(OpaqueExpression object) {
        String body = PivotUtil.getBody(object);
        if (body != null) {
            this.append(body);
        }
        return null;
    }

    @Override
    public String visitOperation(Operation operation) {
        this.appendQualifiedName(operation.getOwningType(), ".", operation);
        this.appendTemplateBindings((List<TemplateBinding>)operation.getTemplateBinding());
        this.appendTemplateSignature(operation.getOwnedTemplateSignature());
        this.append("(");
        boolean isFirst = true;
        for (Parameter parameter : operation.getOwnedParameter()) {
            if (!isFirst) {
                this.append(",");
            }
            Type type = parameter.getType();
            boolean isMany = parameter.getUpper().intValue() != 1;
            boolean isOrdered = parameter.isOrdered();
            boolean isUnique = parameter.isUnique();
            if (isMany) {
                this.append(isOrdered ? (isUnique ? "OrderedSet" : "Sequence") : (isUnique ? "Set" : "Bag"));
                this.append("(");
            }
            this.appendQualifiedName(type);
            if (isMany) {
                this.append(")");
            }
            isFirst = false;
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitOperationCallExp(OperationCallExp oc) {
        OCLExpression source = oc.getSource();
        this.safeVisit(source);
        Operation oper = oc.getReferredOperation();
        if (oper != null) {
            Type sourceType = source != null ? source.getType() : null;
            this.append(sourceType instanceof CollectionType ? "->" : ".");
            this.appendName(oper);
        } else {
            this.append(".");
            this.appendName(oc);
        }
        this.append("(");
        String prefix = "";
        for (OCLExpression argument : oc.getArgument()) {
            this.append(prefix);
            this.safeVisit(argument);
            prefix = ", ";
        }
        this.append(")");
        this.appendAtPre(oc);
        return null;
    }

    @Override
    public String visitPackage(Package pkg) {
        this.appendQualifiedName(pkg.getNestingPackage(), "::", pkg);
        return null;
    }

    @Override
    public String visitParameter(Parameter parameter) {
        this.appendQualifiedName((NamedElement)parameter.eContainer(), ".", parameter);
        return null;
    }

    @Override
    public String visitPrecedence(Precedence precedence) {
        this.appendName(precedence);
        return null;
    }

    @Override
    public String visitPrimitiveType(PrimitiveType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitProperty(Property property) {
        this.appendQualifiedName(property.getOwningType(), ".", property);
        return null;
    }

    @Override
    public String visitPropertyCallExp(PropertyCallExp pc) {
        OCLExpression source = pc.getSource();
        this.safeVisit(source);
        Property property = pc.getReferredProperty();
        Type sourceType = source != null ? source.getType() : null;
        this.result.append(sourceType instanceof CollectionType ? "->" : ".");
        this.appendName(property);
        this.appendAtPre(pc);
        EList<OCLExpression> qualifiers = pc.getQualifier();
        if (!qualifiers.isEmpty()) {
            this.append("[");
            String prefix = "";
            for (OCLExpression qualifier : qualifiers) {
                this.append(prefix);
                this.safeVisit(qualifier);
                prefix = ", ";
            }
            this.append("]");
        }
        return null;
    }

    @Override
    public String visitRealLiteralExp(RealLiteralExp rl) {
        this.append(rl.getRealSymbol());
        return null;
    }

    @Override
    public String visitStateExp(StateExp s) {
        this.appendName(s);
        return null;
    }

    @Override
    public String visitStringLiteralExp(StringLiteralExp sl) {
        this.append("'");
        this.append(sl.getStringSymbol());
        this.append("'");
        return null;
    }

    @Override
    public String visitTemplateBinding(TemplateBinding object) {
        this.appendTemplateBindings(Collections.singletonList(object));
        return null;
    }

    @Override
    public String visitTemplateParameter(TemplateParameter object) {
        TemplateSignature signature = object.getSignature();
        this.appendName(signature != null ? (NamedElement)((Object)signature.getTemplate()) : null);
        this.append(".");
        this.appendName((NamedElement)((Object)object.getParameteredElement()));
        return null;
    }

    @Override
    public String visitTemplateParameterSubstitution(TemplateParameterSubstitution object) {
        TemplateParameter formal = object.getFormal();
        this.appendName(formal != null ? (NamedElement)((Object)formal.getParameteredElement()) : null);
        this.append("/");
        this.appendName((NamedElement)((Object)object.getActual()));
        return null;
    }

    @Override
    public String visitTemplateSignature(TemplateSignature object) {
        this.appendTemplateSignature(object);
        return null;
    }

    @Override
    public String visitTupleLiteralExp(TupleLiteralExp literalExp) {
        this.append("Tuple{");
        String prefix = "";
        for (TupleLiteralPart part : literalExp.getPart()) {
            this.append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitTupleLiteralPart(TupleLiteralPart part) {
        OCLExpression initExpression;
        this.appendName(part);
        Type type = part.getType();
        if (type != null) {
            this.append(" : ");
            this.appendName(type);
        }
        if ((initExpression = part.getInitExpression()) != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public String visitTupleType(TupleType object) {
        this.appendName(object);
        this.append("(");
        String prefix = "";
        for (TypedElement part : object.getOwnedAttribute()) {
            this.append(prefix);
            this.appendName(part);
            this.append(":");
            this.appendName(part.getType());
            prefix = ",";
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitTypeExp(TypeExp t) {
        this.appendQualifiedName(t.getReferredType());
        return null;
    }

    @Override
    public String visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp unl) {
        BigInteger symbol = unl.getUnlimitedNaturalSymbol();
        if (symbol.signum() < 0) {
            this.append("*");
        } else {
            this.append(symbol);
        }
        return null;
    }

    @Override
    public String visitUnspecifiedType(UnspecifiedType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitUnspecifiedValueExp(UnspecifiedValueExp uv) {
        this.append("?");
        if (uv.getType() != null && !(uv.getType() instanceof VoidType)) {
            this.append(" : ");
            this.appendName(uv.getType());
        }
        return null;
    }

    @Override
    public String visitVariable(Variable variable) {
        OCLExpression initExpression;
        this.appendName(variable);
        Type type = variable.getType();
        if (type != null) {
            this.append(" : ");
            this.safeVisit(type);
        }
        if ((initExpression = variable.getInitExpression()) != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public String visitVariableExp(VariableExp v) {
        this.appendName(v.getReferredVariable());
        return null;
    }

    @Override
    public String visitVoidType(VoidType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visiting(Visitable visitable) {
        if (visitable == null) {
            this.append(NULL_PLACEHOLDER);
        } else {
            this.append(visitable.getClass().getName());
        }
        return null;
    }

    public static interface Factory {
        public ToStringVisitor createToStringVisitor();

        public EPackage getEPackage();
    }

    private static final class MyFactory
    implements Factory {
        private MyFactory() {
            ToStringVisitor.addFactory(this);
        }

        public ToStringVisitor createToStringVisitor() {
            return new ToStringVisitor();
        }

        public EPackage getEPackage() {
            return PivotPackage.eINSTANCE;
        }
    }
}

