/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.ocl.examples.xtext.base.scoping.QualifiedPath;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.BodyCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ClassifierContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.CompleteOCLDocumentCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.DefCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.DefOperationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.DefPropertyCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.DerCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.InitCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.InvCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.OperationContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PackageDeclarationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PostCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PreCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PropertyContextDeclCS;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.labeling.EssentialOCLLabelProvider;

public class CompleteOCLLabelProvider
extends EssentialOCLLabelProvider {
    @Inject
    public CompleteOCLLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected String image(BodyCS ele) {
        return "/org.eclipse.ocl.examples.xtext.oclinecore.ui/icons/full/obj16/DefinitionConstraint.gif";
    }

    protected String text(BodyCS ele) {
        String name = ele.getName();
        return name != null ? "body " + name : "body";
    }

    protected String image(ClassifierContextDeclCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Class.gif";
    }

    protected String text(ClassifierContextDeclCS ele) {
        Type classifier = ele.getClassifier();
        if (classifier == null) {
            return "<<null>>";
        }
        if (classifier.eIsProxy()) {
            return "<<unresolved-proxy>>";
        }
        return classifier.getName();
    }

    protected String text(CompleteOCLDocumentCS ele) {
        return "Complete OCL document";
    }

    protected String image(DefCS ele) {
        return "/org.eclipse.ocl.examples.xtext.oclinecore.ui/icons/full/obj16/DefinitionConstraint.gif";
    }

    protected String text(DefCS ele) {
        StringBuilder s = new StringBuilder();
        s.append("def ");
        this.appendOptionalString(s, ele.getName());
        s.append(": ");
        return s.toString();
    }

    protected String text(DefOperationCS ele) {
        StringBuilder s = new StringBuilder();
        this.appendString(s, ele.getName());
        EList parameters = ele.getParameters();
        if (!parameters.isEmpty()) {
            s.append("(");
            String prefix = "";
            for (ParameterCS csParameter : parameters) {
                s.append(prefix);
                this.appendType(s, (TypeRefCS)csParameter.getOwnedType());
                prefix = ", ";
            }
            s.append(")");
        }
        s.append(" : ");
        TypedRefCS ownedType = ele.getOwnedType();
        if (ownedType != null) {
            this.appendType(s, (TypeRefCS)ownedType);
        }
        return s.toString();
    }

    protected String text(DefPropertyCS ele) {
        StringBuilder s = new StringBuilder();
        this.appendString(s, ele.getName());
        s.append(" : ");
        this.appendType(s, (TypeRefCS)ele.getOwnedType());
        return s.toString();
    }

    protected String image(DerCS ele) {
        return "/org.eclipse.ocl.examples.xtext.oclinecore.ui/icons/full/obj16/DerivationConstraint.gif";
    }

    protected String text(DerCS ele) {
        return "derive";
    }

    protected String image(InitCS ele) {
        return "/org.eclipse.ocl.examples.xtext.oclinecore.ui/icons/full/obj16/InitialConstraint.gif";
    }

    protected String text(InitCS ele) {
        return "init";
    }

    protected String image(InvCS ele) {
        return "/org.eclipse.ocl.examples.xtext.oclinecore.ui/icons/full/obj16/InvariantConstraint.gif";
    }

    protected String text(InvCS ele) {
        String name = ele.getName();
        return name != null ? "inv " + name : "inv";
    }

    protected String image(OperationContextDeclCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Operation.gif";
    }

    protected String text(OperationContextDeclCS ele) {
        StringBuilder s = new StringBuilder();
        Operation operation = ele.getOperation();
        if (operation == null) {
            return "<<null>>";
        }
        if (operation.eIsProxy()) {
            return "<<unresolved-proxy>>";
        }
        this.appendName(s, (NamedElement)PivotUtil.getOwningType((Feature)operation));
        s.append("::");
        this.appendName(s, (NamedElement)operation);
        s.append("(");
        String prefix = "";
        for (Parameter parameter : operation.getOwnedParameter()) {
            s.append(prefix);
            this.appendType(s, parameter.getType());
            prefix = ", ";
        }
        s.append(")");
        s.append(" : ");
        this.appendType(s, operation.getType());
        return s.toString();
    }

    protected String image(PackageDeclarationCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Package.gif";
    }

    protected String text(PackageDeclarationCS ele) {
        AliasAnalysis aliasAnalysis = AliasAnalysis.getAdapter((Resource)ele.eResource());
        Package pivot = ele.getPackage();
        if (pivot == null) {
            return "<<null>>";
        }
        QualifiedPath contextPath = new QualifiedPath(aliasAnalysis.getPath((Element)pivot));
        return contextPath.toString();
    }

    protected String image(PostCS ele) {
        return "/org.eclipse.ocl.examples.xtext.oclinecore.ui/icons/full/obj16/PostconditionConstraint.gif";
    }

    protected String text(PostCS ele) {
        String name = ele.getName();
        return name != null ? "post " + name : "post";
    }

    protected String image(PreCS ele) {
        return "/org.eclipse.ocl.examples.xtext.oclinecore.ui/icons/full/obj16/PreconditionConstraint.gif";
    }

    protected String text(PreCS ele) {
        String name = ele.getName();
        return name != null ? "pre " + name : "pre";
    }

    protected String image(PropertyContextDeclCS ele) {
        return "/org.eclipse.uml2.uml.edit/icons/full/obj16/Property.gif";
    }

    protected String text(PropertyContextDeclCS ele) {
        StringBuilder s = new StringBuilder();
        Property feature = ele.getProperty();
        if (feature == null) {
            return "<<null>>";
        }
        if (feature.eIsProxy()) {
            return "<<unresolved-proxy>>";
        }
        this.appendName(s, (NamedElement)PivotUtil.getOwningType((Feature)feature));
        s.append("::");
        this.appendName(s, (NamedElement)feature);
        s.append(" : ");
        this.appendType(s, feature.getType());
        return s.toString();
    }
}

