/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.cs2pivot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.Model;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.LibraryCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ClassifierContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.CompleteOCLDocumentCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ContextConstraintCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.ContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.DefCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.DefFeatureCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.DefOperationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.DefPropertyCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.IncludeCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.OperationContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PackageDeclarationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.PropertyContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.cs2pivot.AbstractCompleteOCLContainmentVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.AbstractOperationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteOCLContainmentVisitor
extends AbstractCompleteOCLContainmentVisitor {
    private Map<Package, Package> modelPackage2contextPackage = new HashMap<Package, Package>();
    private Map<Type, Type> modelType2contextType = new HashMap<Type, Type>();
    private Map<Type, List<Operation>> modelType2contextOperations = new HashMap<Type, List<Operation>>();
    private Map<Type, List<Property>> modelType2contextProperties = new HashMap<Type, List<Property>>();
    private Map<NamedElement, List<Constraint>> modelElement2constraints = new HashMap<NamedElement, List<Constraint>>();

    public static String getStereotype(String stereotype) {
        if (stereotype == null) {
            return null;
        }
        if (stereotype.equals("body")) {
            return "body";
        }
        if (stereotype.equals("def")) {
            return "definition";
        }
        if (stereotype.equals("derive")) {
            return "derivation";
        }
        if (stereotype.equals("init")) {
            return "initial";
        }
        if (stereotype.equals("inv")) {
            return "invariant";
        }
        if (stereotype.equals("pre")) {
            return "precondition";
        }
        if (stereotype.equals("post")) {
            return "postcondition";
        }
        return stereotype;
    }

    public CompleteOCLContainmentVisitor(CS2PivotConversion context) {
        super(context);
    }

    protected void installConstraintContainment(NamedElement contextElement) {
        List<Constraint> constraints = this.modelElement2constraints.get(contextElement);
        if (constraints == null) {
            contextElement.getOwnedRule().clear();
        } else {
            PivotUtil.refreshList((List)contextElement.getOwnedRule(), constraints);
        }
    }

    protected void installOperationContainment(Type modelType, Type contextType) {
        List<Operation> contextOperations = this.modelType2contextOperations.get(modelType);
        if (contextOperations == null) {
            contextType.getOwnedOperation().clear();
        } else {
            PivotUtil.refreshList((List)contextType.getOwnedOperation(), contextOperations);
            for (Operation contextOperation : contextOperations) {
                this.installConstraintContainment((NamedElement)contextOperation);
            }
        }
    }

    protected void installPackageContainment() {
        HashMap<Package, HashSet<Package>> nestedContextPackageMaps = new HashMap<Package, HashSet<Package>>();
        for (Package modelPackage : this.modelPackage2contextPackage.keySet()) {
            Package contextPackage = this.modelPackage2contextPackage.get(modelPackage);
            Package parentModelPackage = modelPackage.getNestingPackage();
            if (parentModelPackage == null) continue;
            Package parentContextPackage = this.modelPackage2contextPackage.get(parentModelPackage);
            HashSet<Package> nestedContextPackages = (HashSet<Package>)nestedContextPackageMaps.get(parentContextPackage);
            if (nestedContextPackages == null) {
                nestedContextPackages = new HashSet<Package>();
                nestedContextPackageMaps.put(parentContextPackage, nestedContextPackages);
            }
            nestedContextPackages.add(contextPackage);
        }
        for (Package parentContextPackage : nestedContextPackageMaps.keySet()) {
            Set nestedContextPackages = (Set)nestedContextPackageMaps.get(parentContextPackage);
            PivotUtil.refreshSet((List)parentContextPackage.getNestedPackage(), (Collection)nestedContextPackages);
        }
    }

    protected void installPropertyContainment(Type modelType, Type contextType) {
        List<Property> contextProperties = this.modelType2contextProperties.get(modelType);
        if (contextProperties == null) {
            contextType.getOwnedAttribute().clear();
        } else {
            PivotUtil.refreshList((List)contextType.getOwnedAttribute(), contextProperties);
            for (Property contextProperty : contextProperties) {
                this.installConstraintContainment((NamedElement)contextProperty);
            }
        }
    }

    protected void installTypeContainment() {
        HashMap<Package, HashSet<Type>> nestedContextTypeMaps = new HashMap<Package, HashSet<Type>>();
        for (Type modelType : this.modelType2contextType.keySet()) {
            Type contextType = this.modelType2contextType.get(modelType);
            Package parentModelPackage = modelType.getPackage();
            Package parentContextPackage = this.modelPackage2contextPackage.get(parentModelPackage);
            HashSet<Type> ownedTypes = (HashSet<Type>)nestedContextTypeMaps.get(parentContextPackage);
            if (ownedTypes == null) {
                ownedTypes = new HashSet<Type>();
                nestedContextTypeMaps.put(parentContextPackage, ownedTypes);
            }
            ownedTypes.add(contextType);
            this.installOperationContainment(modelType, contextType);
            this.installPropertyContainment(modelType, contextType);
            this.installConstraintContainment((NamedElement)contextType);
        }
        for (Package parentContextPackage : nestedContextTypeMaps.keySet()) {
            Set ownedTypes = (Set)nestedContextTypeMaps.get(parentContextPackage);
            PivotUtil.refreshSet((List)parentContextPackage.getOwnedType(), (Collection)ownedTypes);
        }
    }

    protected void refreshConstrainedElements(ContextDeclCS csElement, NamedElement constrainedElement) {
        for (ContextConstraintCS csRule : csElement.getRules()) {
            Constraint constraint = (Constraint)PivotUtil.getPivot(Constraint.class, (Pivotable)csRule);
            EList constrainedElements = constraint.getConstrainedElement();
            constrainedElements.clear();
            constrainedElements.add(constrainedElement);
            List<Constraint> constraints = this.modelElement2constraints.get(constrainedElement);
            if (constraints == null) {
                constraints = new ArrayList<Constraint>();
                this.modelElement2constraints.put(constrainedElement, constraints);
            }
            constraints.add(constraint);
        }
    }

    protected Package refreshContextPackage(Package modelPackage, PackageDeclarationCS csElement) {
        if (modelPackage == null || modelPackage.eIsProxy()) {
            return null;
        }
        Package contextPackage = this.modelPackage2contextPackage.get(modelPackage);
        if (contextPackage == null) {
            contextPackage = (Package)((CS2PivotConversion)this.context).refreshModelElement(Package.class, PivotPackage.Literals.PACKAGE, (ModelElementCS)csElement);
            contextPackage.setName(modelPackage.getName());
            contextPackage.setNsURI(modelPackage.getNsURI());
            this.modelPackage2contextPackage.put(modelPackage, contextPackage);
            this.metaModelManager.installPackage(contextPackage);
            Package parentModelPackage = modelPackage.getNestingPackage();
            if (!(parentModelPackage instanceof Model)) {
                this.refreshContextPackage(parentModelPackage, null);
            }
        }
        if (csElement != null) {
            ((CS2PivotConversion)this.context).refreshComments((Element)contextPackage, (ElementCS)csElement);
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csElement, (Element)contextPackage);
        }
        return contextPackage;
    }

    protected Type refreshContextType(Type modelClassifier, ClassifierContextDeclCS csElement) {
        if (modelClassifier == null || modelClassifier.eIsProxy()) {
            return null;
        }
        Type contextClassifier = this.modelType2contextType.get(modelClassifier);
        if (contextClassifier == null) {
            contextClassifier = (Type)((CS2PivotConversion)this.context).refreshModelElement(Class.class, PivotPackage.Literals.CLASS, (ModelElementCS)csElement);
            contextClassifier.setName(modelClassifier.getName());
            this.modelType2contextType.put(modelClassifier, contextClassifier);
            this.refreshContextPackage(modelClassifier.getPackage(), null);
        }
        if (csElement != null) {
            ((CS2PivotConversion)this.context).refreshComments((Element)contextClassifier, (ElementCS)csElement);
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csElement, (Element)contextClassifier);
        }
        return contextClassifier;
    }

    protected void registerOperation(Type modelClassifier, Operation pivotElement) {
        List<Operation> contextOperations = this.modelType2contextOperations.get(modelClassifier);
        if (contextOperations == null) {
            contextOperations = new ArrayList<Operation>();
            this.modelType2contextOperations.put(modelClassifier, contextOperations);
        }
        contextOperations.add(pivotElement);
    }

    protected void registerProperty(Type modelClassifier, Property pivotElement) {
        List<Property> contextProperties = this.modelType2contextProperties.get(modelClassifier);
        if (contextProperties == null) {
            contextProperties = new ArrayList<Property>();
            this.modelType2contextProperties.put(modelClassifier, contextProperties);
        }
        contextProperties.add(pivotElement);
    }

    @Override
    public Continuation<?> visitClassifierContextDeclCS(ClassifierContextDeclCS csElement) {
        CS2Pivot.setElementType((PathNameCS)csElement.getPathName(), (EClass)PivotPackage.Literals.TYPE, (ElementCS)csElement, null);
        Type modelClassifier = csElement.getClassifier();
        Type contextClassifier = this.refreshContextType(modelClassifier, csElement);
        this.refreshConstrainedElements(csElement, (NamedElement)contextClassifier);
        return null;
    }

    @Override
    public Continuation<?> visitCompleteOCLDocumentCS(CompleteOCLDocumentCS csElement) {
        for (IncludeCS csInclude : csElement.getOwnedInclude()) {
            csInclude.getNamespace();
        }
        Model contextModel = (Model)this.refreshPackage(Model.class, PivotPackage.Literals.MODEL, csElement);
        this.metaModelManager.installPackage((Package)contextModel);
        ArrayList<Package> modelModels = new ArrayList<Package>();
        for (Package modelPackage : this.modelPackage2contextPackage.keySet()) {
            Package parentContextPackage;
            Package parentModelPackage = modelPackage.getNestingPackage();
            if (!(parentModelPackage instanceof Model) || (parentContextPackage = this.modelPackage2contextPackage.get(parentModelPackage)) != null) continue;
            modelModels.add(parentModelPackage);
        }
        for (Package modelModel : modelModels) {
            this.modelPackage2contextPackage.put(modelModel, (Package)contextModel);
        }
        this.installTypeContainment();
        this.installPackageContainment();
        return null;
    }

    @Override
    public Continuation<?> visitContextConstraintCS(ContextConstraintCS csElement) {
        Constraint pivotElement = (Constraint)this.refreshNamedElement(Constraint.class, PivotPackage.Literals.CONSTRAINT, (NamedElementCS)csElement);
        String newStereotype = csElement.getStereotype();
        String stereotype = CompleteOCLContainmentVisitor.getStereotype(newStereotype);
        pivotElement.setStereotype(stereotype);
        return null;
    }

    @Override
    public Continuation<?> visitDefCS(DefCS csElement) {
        Constraint pivotElement = (Constraint)this.refreshNamedElement(Constraint.class, PivotPackage.Literals.CONSTRAINT, (NamedElementCS)csElement);
        DefFeatureCS csFeature = csElement.getFeature();
        pivotElement.setStereotype(csFeature instanceof DefOperationCS ? "body" : "initial");
        Feature pivotFeature = (Feature)PivotUtil.getPivot(Feature.class, (Pivotable)csFeature);
        pivotFeature.setIsStatic(csElement.isStatic());
        PivotUtil.refreshList((List)pivotFeature.getOwnedRule(), Collections.singletonList(pivotElement));
        return null;
    }

    @Override
    public Continuation<?> visitDefOperationCS(DefOperationCS csElement) {
        ClassifierContextDeclCS csClassifierContextDecl = (ClassifierContextDeclCS)csElement.getDef().getContextDecl();
        Type modelClassifier = csClassifierContextDecl.getClassifier();
        Operation pivotElement = (Operation)this.refreshNamedElement(Operation.class, PivotPackage.Literals.OPERATION, (NamedElementCS)csElement);
        this.registerOperation(modelClassifier, pivotElement);
        ((CS2PivotConversion)this.context).refreshPivotList(Parameter.class, (List)pivotElement.getOwnedParameter(), csElement.getParameters());
        return null;
    }

    @Override
    public Continuation<?> visitDefPropertyCS(DefPropertyCS csElement) {
        ClassifierContextDeclCS csClassifierContextDecl = (ClassifierContextDeclCS)csElement.getDef().getContextDecl();
        Type modelClassifier = csClassifierContextDecl.getClassifier();
        Property pivotElement = (Property)this.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (NamedElementCS)csElement);
        this.registerProperty(modelClassifier, pivotElement);
        pivotElement.setIsDerived(true);
        pivotElement.setIsReadOnly(true);
        pivotElement.setIsTransient(true);
        pivotElement.setIsVolatile(true);
        pivotElement.setIsResolveProxies(false);
        return null;
    }

    public Continuation<?> visitImportCS(ImportCS csElement) {
        Namespace namespace = csElement.getNamespace();
        if (namespace != null && !namespace.eIsProxy()) {
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csElement, (Element)namespace);
        }
        return null;
    }

    @Override
    public Continuation<?> visitIncludeCS(IncludeCS csElement) {
        return null;
    }

    public Continuation<?> visitLibraryCS(LibraryCS csElement) {
        Package pPackage = csElement.getPackage();
        if (pPackage != null && !pPackage.eIsProxy()) {
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csElement, (Element)pPackage);
        }
        return null;
    }

    @Override
    public Continuation<?> visitOperationContextDeclCS(OperationContextDeclCS csElement) {
        EList<ParameterCS> csParameters = csElement.getParameters();
        CS2Pivot.setElementType((PathNameCS)csElement.getPathName(), (EClass)PivotPackage.Literals.OPERATION, (ElementCS)csElement, (ScopeFilter)new OperationDeclScopeFilter(this.metaModelManager, null, (List<ParameterCS>)csParameters));
        EList path = csElement.getPathName().getPath();
        int pathSize = path.size();
        Element modelParent = pathSize >= 2 ? ((PathElementCS)path.get(pathSize - 2)).getElement() : null;
        Operation pivotElement = (Operation)((CS2PivotConversion)this.context).refreshModelElement(Operation.class, PivotPackage.Literals.OPERATION, (ModelElementCS)csElement);
        if (modelParent instanceof Type) {
            Type modelClassifier = (Type)modelParent;
            this.refreshContextType(modelClassifier, null);
            this.registerOperation(modelClassifier, pivotElement);
        }
        ((CS2PivotConversion)this.context).refreshPivotList(Parameter.class, (List)pivotElement.getOwnedParameter(), csParameters);
        ((CS2PivotConversion)this.context).refreshComments((Element)pivotElement, (ElementCS)csElement);
        this.refreshConstrainedElements(csElement, (NamedElement)pivotElement);
        return null;
    }

    @Override
    public Continuation<?> visitPackageDeclarationCS(PackageDeclarationCS csElement) {
        CS2Pivot.setElementType((PathNameCS)csElement.getPathName(), (EClass)PivotPackage.Literals.PACKAGE, (ElementCS)csElement, null);
        Package modelPackage = csElement.getPackage();
        this.refreshContextPackage(modelPackage, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitPropertyContextDeclCS(PropertyContextDeclCS csElement) {
        CS2Pivot.setElementType((PathNameCS)csElement.getPathName(), (EClass)PivotPackage.Literals.PROPERTY, (ElementCS)csElement, null);
        Property modelProperty = csElement.getProperty();
        Property contextProperty = (Property)((CS2PivotConversion)this.context).refreshModelElement(Property.class, PivotPackage.Literals.PROPERTY, (ModelElementCS)csElement);
        if (modelProperty != null && !modelProperty.eIsProxy()) {
            contextProperty.setName(modelProperty.getName());
            contextProperty.setType(modelProperty.getType());
            Type modelClassifier = modelProperty.getOwningType();
            if (modelClassifier != null) {
                this.refreshContextType(modelClassifier, null);
                this.registerProperty(modelClassifier, contextProperty);
            }
        }
        ((CS2PivotConversion)this.context).refreshComments((Element)contextProperty, (ElementCS)csElement);
        this.refreshConstrainedElements(csElement, (NamedElement)contextProperty);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OperationDeclScopeFilter
    extends AbstractOperationFilter {
        private final List<ParameterCS> csParameters;

        public OperationDeclScopeFilter(MetaModelManager metaModelManager, Type sourceType, List<ParameterCS> csParameters) {
            super(metaModelManager, sourceType);
            this.csParameters = csParameters;
        }

        public boolean matches(EnvironmentView environmentView, Type forType, EObject eObject) {
            if (eObject instanceof Iteration) {
                return false;
            }
            if (eObject instanceof Operation) {
                Operation candidateOperation = (Operation)eObject;
                EList candidateParameters = candidateOperation.getOwnedParameter();
                int iMax = this.csParameters.size();
                if (iMax != candidateParameters.size()) {
                    return false;
                }
                Map bindings = this.getOperationBindings(candidateOperation);
                int i = 0;
                while (i < iMax) {
                    Parameter candidateParameter = (Parameter)candidateParameters.get(i);
                    ParameterCS csParameter = this.csParameters.get(i);
                    if (csParameter == null) {
                        return false;
                    }
                    TypedRefCS csType = csParameter.getOwnedType();
                    Type pType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType);
                    if (pType == null) {
                        return false;
                    }
                    Type candidateType = this.metaModelManager.getTypeWithMultiplicity((TypedMultiplicityElement)candidateParameter);
                    if (candidateType instanceof SelfType) {
                        candidateType = candidateOperation.getOwningType();
                    }
                    if (!this.metaModelManager.conformsTo(pType = PivotUtil.getBehavioralType((Type)pType), candidateType, bindings)) {
                        return false;
                    }
                    ++i;
                }
                if (bindings != null) {
                    this.installBindings(environmentView, forType, eObject, bindings);
                }
                return true;
            }
            return false;
        }
    }
}

