/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Nameable;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.scoping.AbstractRootCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ContextCS;

public class ContextCSAttribution
extends AbstractRootCSAttribution {
    public static final ContextCSAttribution INSTANCE = new ContextCSAttribution();

    public ScopeView computeLookup(EObject target, EnvironmentView environmentView, ScopeView scopeView) {
        MetaModelManager metaModelManager = environmentView.getMetaModelManager();
        ContextCS targetElement = (ContextCS)target;
        environmentView.addFilter((ScopeFilter)NoImplicitProperties.INSTANCE);
        try {
            Resource eResource;
            ExpressionInOCL pivot = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)targetElement);
            if (pivot != null && pivot.getContextVariable().getType() != null) {
                Variable resultVariable = pivot.getResultVariable();
                if (resultVariable != null) {
                    environmentView.addNamedElement((Nameable)resultVariable);
                }
                for (Variable parameterVariable : pivot.getParameterVariable()) {
                    environmentView.addNamedElement((Nameable)parameterVariable);
                }
                Variable contextVariable = pivot.getContextVariable();
                if (contextVariable != null) {
                    environmentView.addNamedElement((Nameable)contextVariable);
                    if (!environmentView.hasFinalResult()) {
                        Type type = contextVariable.getType();
                        environmentView.addElementsOfScope((Element)type, scopeView);
                        Package pPackage = type.getPackage();
                        while (!environmentView.hasFinalResult() && pPackage != null) {
                            environmentView.addElementsOfScope((Element)pPackage, scopeView);
                            pPackage = pPackage.getNestingPackage();
                        }
                    }
                }
            } else {
                ParserContext parserContext;
                Type contextType;
                Resource resource = target.eResource();
                if (resource instanceof BaseResource && (contextType = (parserContext = ((BaseResource)resource).getParserContext()).getClassContext()) != null) {
                    environmentView.computeLookups((Element)contextType, null, null, PivotPackage.Literals.NAMED_ELEMENT__OWNED_RULE);
                }
            }
            if (!environmentView.hasFinalResult()) {
                environmentView.addRootPackages();
            }
            if (pivot != null && !environmentView.hasFinalResult() && (eResource = pivot.eResource()) != null) {
                URI baseURI = eResource.getURI();
                environmentView.addImportedElement(baseURI);
            }
            if (!environmentView.hasFinalResult()) {
                environmentView.addElementsOfScope((Element)metaModelManager.getOclAnyType().getPackage(), scopeView);
            }
            ScopeView scopeView2 = super.computeLookup((EObject)targetElement, environmentView, scopeView);
            return scopeView2;
        }
        finally {
            environmentView.removeFilter((ScopeFilter)NoImplicitProperties.INSTANCE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NoImplicitProperties
    implements ScopeFilter {
        public static NoImplicitProperties INSTANCE = new NoImplicitProperties();

        public int compareMatches(EObject match1, Map<TemplateParameter, ParameterableElement> bindings1, EObject match2, Map<TemplateParameter, ParameterableElement> bindings2) {
            return 0;
        }

        public boolean matches(EnvironmentView environmentView, Type forType, EObject eObject) {
            return !(eObject instanceof Property) || !((Property)eObject).isImplicit();
        }
    }
}

