/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.scoping;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ConstructorPartCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ContextCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ExpSpecificationCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.InvocationExpCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.LetExpCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.NavigationOperatorCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.TupleLiteralExpCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.EssentialOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TypeNameExpCS;

public class EssentialOCLScoping {
    public static void init() {
        Map registry = Attribution.REGISTRY;
        registry.put(EssentialOCLCSTPackage.Literals.CONSTRUCTOR_PART_CS, ConstructorPartCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSTPackage.Literals.CONTEXT_CS, ContextCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSTPackage.Literals.EXP_SPECIFICATION_CS, ExpSpecificationCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSTPackage.Literals.INVOCATION_EXP_CS, InvocationExpCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSTPackage.Literals.LET_EXP_CS, LetExpCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSTPackage.Literals.NAVIGATION_OPERATOR_CS, NavigationOperatorCSAttribution.INSTANCE);
        registry.put(EssentialOCLCSTPackage.Literals.TUPLE_LITERAL_EXP_CS, TupleLiteralExpCSAttribution.INSTANCE);
        CS2Pivot.addUnresolvedProxyMessageProvider((CS2Pivot.UnresolvedProxyMessageProvider)new PathElementCSUnresolvedProxyMessageProvider());
    }

    private static final class PathElementCSUnresolvedProxyMessageProvider
    extends CS2Pivot.AbstractUnresolvedProxyMessageProvider {
        private PathElementCSUnresolvedProxyMessageProvider() {
            super(BaseCSTPackage.Literals.PATH_ELEMENT_CS__ELEMENT);
        }

        public String getMessage(EObject eObject, String linkText) {
            Type sourceType;
            String messageTemplate;
            PathElementCS csPathElement = (PathElementCS)eObject;
            PathNameCS pathName = csPathElement.getPathName();
            EList path = pathName.getPath();
            int index = path.indexOf(csPathElement);
            int i = 0;
            while (i < index) {
                PathElementCS csElement = (PathElementCS)path.get(i);
                Element element = csElement.basicGetElement();
                if (element == null || element.eIsProxy()) {
                    return null;
                }
                ++i;
            }
            ElementCS csContext = pathName.getContext();
            if (csContext == null) {
                csContext = (ElementCS)pathName.eContainer();
            }
            String argumentText = null;
            ExpCS navigationArgument = null;
            if (index + 1 < path.size()) {
                messageTemplate = OCLMessages.UnresolvedNamespace_ERROR_;
            } else if (csContext instanceof InvocationExpCS) {
                InvocationExpCS csNavigatingExp = (InvocationExpCS)csContext;
                navigationArgument = csNavigatingExp;
                argumentText = this.getOperationArguments(csNavigatingExp);
                messageTemplate = OCLMessages.UnresolvedOperationCall_ERROR_;
            } else if (csContext instanceof TypeNameExpCS) {
                messageTemplate = OCLMessages.UnresolvedType_ERROR_;
            } else if (csContext instanceof TypedTypeRefCS) {
                messageTemplate = OCLMessages.UnresolvedType_ERROR_;
            } else if (csContext instanceof ExpCS) {
                navigationArgument = (ExpCS)csContext;
                messageTemplate = OCLMessages.UnresolvedProperty_ERROR_;
            } else {
                messageTemplate = csContext instanceof ModelElementRefCS ? "Unresolved ModelElement ''{0}''" : "Unresolved ''{1}'' ''{0}''";
            }
            TypedElement source = null;
            ExpCS csSource = navigationArgument;
            while (csSource != null) {
                OperatorCS csOperator = csSource.getParent();
                if (csOperator != null && csOperator.getSource() != csSource) {
                    csSource = csOperator.getSource();
                    break;
                }
                EObject eContainer = csSource.eContainer();
                if (eContainer instanceof NavigatingArgCS) {
                    csSource = ((NavigatingArgCS)eContainer).getNavigatingExp();
                    continue;
                }
                if (eContainer instanceof InfixExpCS) {
                    csSource = (InfixExpCS)eContainer;
                    continue;
                }
                if (eContainer instanceof PrefixExpCS) {
                    csSource = (PrefixExpCS)eContainer;
                    continue;
                }
                if (eContainer instanceof NestedExpCS) {
                    csSource = (NestedExpCS)eContainer;
                    continue;
                }
                if (!(eContainer instanceof SpecificationCS)) break;
                ExpressionInOCL expression = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)((SpecificationCS)eContainer));
                source = expression != null ? expression.getContextVariable() : null;
                break;
            }
            if (source == null && csSource != null && csSource != navigationArgument) {
                source = (TypedElement)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csSource);
            }
            String typeText = "unknown-type";
            if (source != null && (sourceType = source.getType()) != null) {
                OperatorCS csParent = navigationArgument != null ? navigationArgument.getParent() : null;
                typeText = !(sourceType instanceof CollectionType) && csParent instanceof NavigationOperatorCS && "->".equals(((NavigationOperatorCS)csParent).getName()) ? "Set(" + sourceType.toString() + ")" : sourceType.toString();
            }
            if (argumentText == null) {
                return CS2Pivot.getMessageBinder().bind((EObject)csContext, messageTemplate, new Object[]{linkText, typeText});
            }
            return CS2Pivot.getMessageBinder().bind((EObject)csContext, messageTemplate, new Object[]{linkText, typeText, argumentText});
        }

        public String getOperationArguments(InvocationExpCS csNavigatingExp) {
            EList<NavigatingArgCS> arguments = csNavigatingExp.getArgument();
            StringBuilder s = new StringBuilder();
            for (NavigatingArgCS csArgument : arguments) {
                TypedElement pivot = (TypedElement)PivotUtil.getPivot(TypedElement.class, (Pivotable)csArgument);
                if (pivot != null && !pivot.eIsProxy()) {
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    Type type = pivot.getType();
                    if (pivot instanceof TypedMultiplicityElement) {
                        TypedMultiplicityElement typedMultiplicityElement = (TypedMultiplicityElement)pivot;
                        if (typedMultiplicityElement.isOrdered()) {
                            if (typedMultiplicityElement.isUnique()) {
                                s.append("OrderedSet(");
                            } else {
                                s.append("Sequence(");
                            }
                        } else if (typedMultiplicityElement.isUnique()) {
                            s.append("Set(");
                        } else {
                            s.append("Bag(");
                        }
                        s.append(String.valueOf(type));
                        s.append(")");
                        BigInteger lower = typedMultiplicityElement.getLower();
                        BigInteger upper = typedMultiplicityElement.getUpper();
                        PivotUtil.appendMultiplicity((StringBuilder)s, (int)lower.intValue(), (int)upper.intValue());
                        continue;
                    }
                    s.append(String.valueOf(type));
                    continue;
                }
                s.append(csArgument.toString());
            }
            return s.toString();
        }
    }
}

