/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.markup;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.xtext.markup.BulletElement;
import org.eclipse.ocl.examples.xtext.markup.CompoundElement;
import org.eclipse.ocl.examples.xtext.markup.FigureElement;
import org.eclipse.ocl.examples.xtext.markup.FigureRefElement;
import org.eclipse.ocl.examples.xtext.markup.FontElement;
import org.eclipse.ocl.examples.xtext.markup.FootnoteElement;
import org.eclipse.ocl.examples.xtext.markup.HeadingElement;
import org.eclipse.ocl.examples.xtext.markup.MarkupElement;
import org.eclipse.ocl.examples.xtext.markup.NewLineElement;
import org.eclipse.ocl.examples.xtext.markup.NullElement;
import org.eclipse.ocl.examples.xtext.markup.OCLCodeElement;
import org.eclipse.ocl.examples.xtext.markup.OCLEvalElement;
import org.eclipse.ocl.examples.xtext.markup.OCLTextElement;
import org.eclipse.ocl.examples.xtext.markup.TextElement;
import org.eclipse.ocl.examples.xtext.markup.util.MarkupSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupToString
extends MarkupSwitch<StringBuilder> {
    protected final StringBuilder s = new StringBuilder();

    public static String toString(MarkupElement element) {
        MarkupToString toString = new MarkupToString();
        return ((StringBuilder)toString.doSwitch(element)).toString();
    }

    public static String toString(List<MarkupElement> elements) {
        MarkupToString toString = new MarkupToString();
        for (MarkupElement element : elements) {
            toString.doSwitch(element);
        }
        return toString.toString();
    }

    @Override
    public StringBuilder caseBulletElement(BulletElement object) {
        this.s.append("bullet");
        String level = object.getLevel();
        if (level != null) {
            this.s.append(":");
            this.s.append(level);
        }
        this.s.append("[");
        this.caseCompoundElement(object);
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseCompoundElement(CompoundElement object) {
        for (MarkupElement element : object.getElements()) {
            this.doSwitch(element);
        }
        return this.s;
    }

    @Override
    public StringBuilder caseFigureElement(FigureElement object) {
        this.s.append("figure");
        String def = object.getDef();
        if (def != null) {
            this.s.append("#");
            this.s.append(def);
        }
        this.s.append("[");
        this.s.append("\"");
        this.s.append(object.getSrc());
        this.s.append("\"");
        String alt = object.getAlt();
        if (alt != null) {
            this.s.append(",");
            this.s.append(alt);
            String width = object.getRequiredWidth();
            if (width != null) {
                this.s.append(",");
                this.s.append(width);
                String height = object.getRequiredHeight();
                if (height != null) {
                    this.s.append(",");
                    this.s.append(height);
                }
            }
        }
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseFigureRefElement(FigureRefElement object) {
        this.s.append("figure");
        this.s.append("[");
        this.s.append(object.getRef().getDef());
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseFontElement(FontElement object) {
        this.s.append(object.getFont());
        this.s.append("[");
        this.caseCompoundElement(object);
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseFootnoteElement(FootnoteElement object) {
        this.s.append("footnote[");
        this.caseCompoundElement(object);
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseHeadingElement(HeadingElement object) {
        this.s.append("heading");
        String level = object.getLevel();
        if (level != null) {
            this.s.append(":");
            this.s.append(level);
        }
        this.s.append("[");
        this.caseCompoundElement(object);
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseNewLineElement(NewLineElement object) {
        this.s.append(object.getText());
        return this.s;
    }

    @Override
    public StringBuilder caseNullElement(NullElement object) {
        this.s.append("[");
        this.caseCompoundElement(object);
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseOCLCodeElement(OCLCodeElement object) {
        this.s.append("oclCode[");
        this.caseCompoundElement(object);
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseOCLEvalElement(OCLEvalElement object) {
        this.s.append("oclEval[");
        this.caseCompoundElement(object);
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseOCLTextElement(OCLTextElement object) {
        this.s.append("oclText[");
        this.caseCompoundElement(object);
        this.s.append("]");
        return this.s;
    }

    @Override
    public StringBuilder caseTextElement(TextElement object) {
        for (String text : object.getText()) {
            this.s.append(text);
        }
        return this.s;
    }

    @Override
    public StringBuilder defaultCase(EObject object) {
        this.s.append("<Unsupported ");
        this.s.append(object.eClass().getName());
        this.s.append(">");
        return this.s;
    }

    public String toString() {
        return this.s.toString();
    }
}

