/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.ui.model;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.uml.Pivot2UML;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.model.BaseDocument;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OCLinEcoreDocument
extends BaseDocument {
    @Inject
    public OCLinEcoreDocument(DocumentTokenSource tokenSource, ITextEditComposer composer) {
        super(tokenSource, composer);
    }

    protected void checkForErrors(Resource resource) throws CoreException {
        EList errors = resource.getErrors();
        if (errors.size() > 0) {
            StringBuilder s = new StringBuilder();
            for (Resource.Diagnostic diagnostic : errors) {
                s.append("\n");
                if (diagnostic instanceof XtextSyntaxDiagnostic) {
                    s.append("Syntax error: ");
                    String location = diagnostic.getLocation();
                    if (location != null) {
                        s.append(location);
                        s.append(":");
                    }
                    s.append(diagnostic.getLine());
                    s.append(" ");
                    s.append(diagnostic.getMessage());
                    continue;
                }
                s.append(diagnostic.toString());
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", s.toString()));
        }
    }

    protected XMLResource getPivotResouce() throws CoreException {
        return (XMLResource)this.readOnly((IUnitOfWork)new IUnitOfWork<XMLResource, XtextResource>(){

            public XMLResource exec(XtextResource resource) throws Exception {
                CS2PivotResourceAdapter adapter = CS2PivotResourceAdapter.findAdapter((BaseCSResource)((BaseCSResource)resource));
                XMLResource pivotResource = (XMLResource)adapter.getPivotResource((Resource)resource);
                OCLinEcoreDocument.this.checkForErrors((Resource)pivotResource);
                return pivotResource;
            }
        });
    }

    public void saveAsEcore(final Writer writer, final URI ecoreURI) throws IOException, CoreException {
        this.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Object exec(XtextResource resource) throws Exception {
                XMLResource pivotResource = OCLinEcoreDocument.this.getPivotResouce();
                CS2PivotResourceAdapter adapter = CS2PivotResourceAdapter.findAdapter((BaseCSResource)((BaseCSResource)resource));
                Resource csResource = adapter.getTarget();
                OCLinEcoreDocument.this.checkForErrors(csResource);
                XMLResource ecoreResource = Pivot2Ecore.createResource((MetaModelManager)adapter.getMetaModelManager(), (Resource)pivotResource, (URI)ecoreURI, null);
                ecoreResource.save(writer, null);
                OCLinEcoreDocument.this.checkForErrors((Resource)ecoreResource);
                return null;
            }
        });
    }

    public void saveAsPivot(StringWriter writer) throws CoreException, IOException {
        XMLResource pivotResource = this.getPivotResouce();
        pivotResource.save((Writer)writer, null);
    }

    public void saveAsUML(final Writer writer, final URI umlURI) throws IOException, CoreException {
        this.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Object exec(XtextResource resource) throws Exception {
                XMLResource pivotResource = OCLinEcoreDocument.this.getPivotResouce();
                CS2PivotResourceAdapter adapter = CS2PivotResourceAdapter.findAdapter((BaseCSResource)((BaseCSResource)resource));
                List umlContents = Pivot2UML.createResource((MetaModelManager)adapter.getMetaModelManager(), (Resource)pivotResource);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                UMLResource umlResource = (UMLResource)resourceSet.createResource(umlURI);
                umlResource.getContents().addAll((Collection)umlContents);
                OCLinEcoreDocument.this.checkForErrors((Resource)umlResource);
                umlResource.save(writer, null);
                return null;
            }
        });
    }

    public void saveInEcore(final Writer writer, final URI ecoreURI) throws IOException, CoreException {
        this.readOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Object exec(XtextResource resource) throws Exception {
                XMLResource pivotResource = OCLinEcoreDocument.this.getPivotResouce();
                CS2PivotResourceAdapter adapter = CS2PivotResourceAdapter.findAdapter((BaseCSResource)((BaseCSResource)resource));
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("PRIMITIVE_TYPES_URI_PREFIX", "primitives.ecore#//");
                XMLResource ecoreResource = Pivot2Ecore.createResource((MetaModelManager)adapter.getMetaModelManager(), (Resource)pivotResource, (URI)ecoreURI, options);
                ecoreResource.save(writer, null);
                OCLinEcoreDocument.this.checkForErrors((Resource)ecoreResource);
                return null;
            }
        });
    }
}

