/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.generators;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.papyrus.customization.properties.generation.generators.AbstractQVTGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.FileChooser;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.Property;
import org.eclipse.papyrus.views.properties.root.PropertiesRoot;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreGenerator
extends AbstractQVTGenerator {
    private FileChooser sourceFileChooser;
    private EPackage ecorePackage;

    @Override
    public void createControls(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        root.setLayout((Layout)layout);
        Label sourceLabel = new Label(root, 0);
        sourceLabel.setText(Messages.EcoreGenerator_source);
        GridData data = new GridData();
        data.widthHint = 100;
        sourceLabel.setLayoutData((Object)data);
        this.sourceFileChooser = new FileChooser(root, false);
        this.sourceFileChooser.setFilterExtensions(new String[]{"ecore"});
        this.sourceFileChooser.addListener(this);
    }

    @Override
    public String getDescription() {
        return Messages.EcoreGenerator_ecoreGeneratorDescription;
    }

    @Override
    public boolean isReady() {
        return this.sourceFileChooser.getFilePath() != null;
    }

    @Override
    public String getName() {
        return Messages.EcoreGenerator_ecoreGeneratorName;
    }

    @Override
    public boolean isSelectedSingle(Property property) {
        EReference reference;
        EStructuralFeature feature = this.getFeature(property);
        if (feature.isDerived()) {
            return false;
        }
        if (!feature.isChangeable()) {
            return false;
        }
        return !(feature instanceof EReference) || !(reference = (EReference)feature).isContainer() && !reference.isContainment();
    }

    protected EStructuralFeature getFeature(Property property) {
        List<String> path = this.getPath(property);
        path.remove(0);
        EPackage currentPackage = this.ecorePackage;
        EClassifier classifier = this.findClassifier(path, currentPackage);
        if (classifier == null) {
            return null;
        }
        if (!(classifier instanceof EClass)) {
            return null;
        }
        EClass eClass = (EClass)classifier;
        return eClass.getEStructuralFeature(property.getName());
    }

    protected EClassifier findClassifier(List<String> path, EPackage source) {
        String qualifier = path.get(0);
        EClassifier classifier = source.getEClassifier(qualifier);
        if (classifier == null) {
            if ((source = this.findSubPackage(source, qualifier)) == null) {
                return null;
            }
            path.remove(0);
            return this.findClassifier(path, source);
        }
        return classifier;
    }

    protected EPackage findSubPackage(EPackage currentPackage, String packageName) {
        for (EPackage pack : currentPackage.getESubpackages()) {
            if (!pack.getName().equals(packageName)) continue;
            return pack;
        }
        return null;
    }

    private List<String> getPath(Property property) {
        List<String> result = this.getPath(property.getContextElement());
        return result;
    }

    private List<String> getPath(DataContextElement element) {
        List<Object> result = element.getPackage() == null ? new LinkedList() : this.getPath((DataContextElement)element.getPackage());
        result.add(element.getName());
        return result;
    }

    @Override
    public boolean isSelectedMultiple(Property property) {
        if (!this.isSelectedSingle(property)) {
            return false;
        }
        EStructuralFeature feature = this.getFeature(property);
        HashSet<String> validDataTypes = new HashSet<String>(Arrays.asList("int", "boolean", "float", "double"));
        if (feature.getEType() instanceof EDataType && validDataTypes.contains(((EDataType)feature.getEType()).getInstanceTypeName())) {
            return true;
        }
        return feature.getEType() instanceof EEnum;
    }

    @Override
    public boolean isSelectedSingle(Property property, DataContextElement element) {
        return this.isSelectedSingle(property);
    }

    @Override
    public boolean isSelectedMultiple(Property property, DataContextElement element) {
        return this.isSelectedMultiple(property);
    }

    @Override
    protected URI getTransformationURI() {
        return URI.createPlatformPluginURI((String)"org.eclipse.papyrus.customization.properties.generation/transforms/ecore2datacontext.qvto", (boolean)true);
    }

    @Override
    protected List<ModelExtent> getModelExtents() {
        try {
            URI packageURI = URI.createPlatformResourceURI((String)this.sourceFileChooser.getFilePath(), (boolean)true);
            this.ecorePackage = (EPackage)this.loadEMFModel(packageURI);
            BasicModelExtent inPackage = new BasicModelExtent(Collections.singletonList(this.ecorePackage));
            PropertiesRoot root = ConfigurationManager.instance.getPropertiesRoot();
            BasicModelExtent inRoot = new BasicModelExtent(Collections.singletonList(root));
            LinkedList<ModelExtent> result = new LinkedList<ModelExtent>();
            result.add((ModelExtent)inPackage);
            result.add((ModelExtent)inRoot);
            result.add(this.getOutContextExtent());
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

