/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.ui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.customization.properties.messages.Messages;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.catalog.PropertiesURIHandler;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.util.PropertiesUtil;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyContextAction {
    private IStatus result;

    public Context copy(Context source, String targetName, boolean activate) throws IOException {
        IPath targetDirectoryPath = Activator.getDefault().getPreferencesPath().append("/" + targetName);
        File targetDirectory = targetDirectoryPath.toFile();
        if (targetDirectory.exists()) {
            throw new IOException("A context with this name already exists");
        }
        URI targetModelUri = URI.createFileURI((String)(String.valueOf(targetDirectory.toString()) + "/" + targetName + ".ctx"));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Context sourceContext = (Context)EMFHelper.loadEMFModel((ResourceSet)resourceSet, (URI)source.eResource().getURI());
        this.copyAll(sourceContext, new File(targetDirectory, String.valueOf(targetName) + ".ctx"));
        if (this.result.getCode() == 0) {
            Context targetContext = ConfigurationManager.instance.getContext(targetModelUri);
            targetContext.setName(targetName);
            targetContext.eResource().save(Collections.EMPTY_MAP);
            ConfigurationManager.instance.addContext(targetContext, activate);
            if (activate) {
                ConfigurationManager.instance.disableContext(source, true);
            }
            return targetContext;
        }
        return null;
    }

    private void resolveAllResources(Context source) {
        this.resolveAllResources((EObject)source, new HashSet<EObject>());
    }

    private void resolveAllResources(EObject source, Set<EObject> visitedEObjects) {
        if (!visitedEObjects.add(source)) {
            return;
        }
        for (EReference reference : source.eClass().getEAllReferences()) {
            if (reference == ContextsPackage.eINSTANCE.getSection_Widget()) continue;
            Object value = source.eGet((EStructuralFeature)reference);
            if (value instanceof EList) {
                for (Object object : (EList)value) {
                    if (!(object instanceof EObject)) continue;
                    this.resolveAllResources((EObject)object, visitedEObjects);
                }
                continue;
            }
            if (!(value instanceof EObject)) continue;
            this.resolveAllResources((EObject)value, visitedEObjects);
        }
    }

    private void copyAll(final Context source, final File target) {
        final File targetDirectory = target.getParentFile();
        final String targetName = target.getName();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(String.valueOf(Messages.CopyContextAction_InitializingTheCopyOf) + source.getName() + Messages.CopyContextAction_ThisMayTakeSomeTime, -1);
                    CopyContextAction.this.resolveAllResources(source);
                    monitor.done();
                    CopyContextAction.this.result = Status.OK_STATUS;
                }
            });
            dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            if (this.result.getCode() == 0) {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            targetDirectory.mkdirs();
                            int filesToCopy = source.eResource().getResourceSet().getResources().size();
                            LinkedList<Context> contexts = new LinkedList<Context>();
                            for (Context context : PropertiesUtil.getDependencies((Context)source)) {
                                if (!CopyContextAction.this.isRelative((EObject)source, context.eResource())) continue;
                                contexts.add(context);
                                for (Tab tab : context.getTabs()) {
                                    filesToCopy += tab.getSections().size();
                                }
                            }
                            monitor.beginTask(String.valueOf(Messages.CopyContextAction_Copying) + source.getName() + Messages.CopyContextAction_To + targetName, filesToCopy);
                            CopyContextAction.this.copy(source.eResource(), target);
                            monitor.worked(1);
                            for (Resource resource : source.eResource().getResourceSet().getResources()) {
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                if (source.eResource() != resource && CopyContextAction.this.isRelative((EObject)source, resource)) {
                                    CopyContextAction.this.copy(resource, targetDirectory, (EObject)source, targetName);
                                }
                                monitor.worked(1);
                            }
                            for (Context context : contexts) {
                                for (Tab tab : context.getTabs()) {
                                    for (Section section : tab.getSections()) {
                                        if (monitor.isCanceled()) {
                                            return;
                                        }
                                        CopyContextAction.this.copy(section.getSectionFile(), targetDirectory, source);
                                        monitor.worked(1);
                                    }
                                }
                            }
                            monitor.done();
                        }
                        catch (IOException ex) {
                            Activator.log.error((Throwable)ex);
                            CopyContextAction.this.result = (IStatus)new Status(4, "org.eclipse.papyrus.views.properties", "An error occured during the copy of " + source.getName(), (Throwable)ex);
                            return;
                        }
                        CopyContextAction.this.result = Status.OK_STATUS;
                    }
                });
            }
        }
        catch (InvocationTargetException ex) {
            Activator.log.error((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    protected void copy(String xwtFileName, File targetDirectory, Context source) {
        File target = new File(targetDirectory, xwtFileName);
        PropertiesURIHandler uriHandler = new PropertiesURIHandler();
        URI sourceURI = URI.createURI((String)xwtFileName).resolve(source.eResource().getURI());
        if (uriHandler.canHandle(sourceURI)) {
            sourceURI = uriHandler.getConvertedURI(sourceURI);
        }
        try {
            URL netURL = new URL(sourceURI.toString());
            InputStream is = netURL.openStream();
            this.copy(is, target);
        }
        catch (MalformedURLException ex) {
            Activator.log.error((Throwable)ex);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    protected void copy(Resource resource, File target) throws IOException {
        PropertiesURIHandler uriHandler = new PropertiesURIHandler();
        URI uri = resource.getURI();
        if (uriHandler.canHandle(uri)) {
            uri = uriHandler.getConvertedURI(uri);
        }
        this.copy(new URL(uri.toString()).openStream(), target);
    }

    private void copy(Resource resource, File directory, EObject source, String targetName) throws IOException {
        URI relativeURI = resource.getURI().deresolve(source.eResource().getURI());
        if (relativeURI.toString().equals("")) {
            relativeURI = URI.createURI((String)(String.valueOf(targetName) + ".ctx"));
        }
        File target = new File(directory, relativeURI.toString());
        this.copy(resource, target);
    }

    private boolean isRelative(EObject source, Resource resource) {
        URI baseURI = source.eResource().getURI();
        URI resourceURI = resource.getURI();
        URI uri = resourceURI.deresolve(baseURI);
        return uri.isRelative() && !uri.toString().startsWith("..") && !uri.toString().startsWith("/");
    }

    private void copy(InputStream source, File target) throws IOException {
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        FileWriter out = new FileWriter(target);
        try {
            int c;
            while ((c = source.read()) != -1) {
                out.write(c);
            }
        }
        finally {
            source.close();
            out.close();
        }
    }
}

