/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.ContentChangedEventProvider;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageMngrImpl
implements IPageMngr {
    private SashWindowsMngr diSashModel;
    ContentChangedEventProvider contentChangedEventProvider;

    public PageMngrImpl(SashWindowsMngr diSashModel, ContentChangedEventProvider contentChangedEventProvider) {
        this.diSashModel = diSashModel;
        this.contentChangedEventProvider = contentChangedEventProvider;
    }

    public void addPage(Object pageIdentifier) {
        this.diSashModel.getPageList().addPage(pageIdentifier);
    }

    public List<Object> allPages() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (PageRef pageRef : this.diSashModel.getPageList().getAvailablePage()) {
            list.add(pageRef.getPageIdentifier());
        }
        return list;
    }

    public void closePage(Object pageIdentifier) {
        this.contentChangedEventProvider.setDeliver(false);
        this.diSashModel.getSashModel().removePageAndEmptyFolder(pageIdentifier);
        this.contentChangedEventProvider.setDeliver(true);
    }

    public void closeAllOpenedPages() {
        this.contentChangedEventProvider.setDeliver(false);
        this.diSashModel.getSashModel().removeAllPages();
        this.contentChangedEventProvider.setDeliver(true);
    }

    public void closeOtherPages(Object pageIdentifier) {
        this.contentChangedEventProvider.setDeliver(false);
        this.diSashModel.getSashModel().removeOtherPages(pageIdentifier);
        this.contentChangedEventProvider.setDeliver(true);
    }

    public void openPage(Object pageIdentifier) {
        Iterator iterator = this.diSashModel.getPageList().getAvailablePage().iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            if (!pageIdentifier.equals(((PageRef)iterator.next()).getPageIdentifier())) continue;
            found = true;
        }
        if (!found) {
            this.diSashModel.getPageList().addPage(pageIdentifier);
        }
        this.diSashModel.getSashModel().addPage(pageIdentifier);
    }

    public void removePage(Object pageIdentifier) {
        this.diSashModel.getPageList().removePage(pageIdentifier);
        this.contentChangedEventProvider.setDeliver(false);
        this.diSashModel.getSashModel().removePageAndEmptyFolder(pageIdentifier);
        this.contentChangedEventProvider.setDeliver(true);
    }

    public boolean isOpen(Object pageIdentifier) {
        return this.diSashModel.getSashModel().lookupPage(pageIdentifier) != null;
    }
}

