/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IAbstractPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple.AbstractModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple.RootModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple.SashPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.simple.TabFolderModel;

public class SimpleSashWindowsContentProvider
implements ISashWindowsContentProvider,
IContentChangedProvider {
    private TabFolderModel currentTabFolder;
    private RootModel rootModel;
    private ContentChangeListenerManager contentChangedListenerManager = new ContentChangeListenerManager();

    public SimpleSashWindowsContentProvider() {
        this.currentTabFolder = new TabFolderModel(this);
        this.rootModel = new RootModel(this.currentTabFolder);
    }

    public void addListener(IContentChangedListener listener) {
        this.contentChangedListenerManager.addContentChangedListener(listener);
    }

    public void removeListener(IContentChangedListener listener) {
        this.contentChangedListenerManager.removeContentChangedListener(listener);
    }

    protected void firePropertyChanged(IContentChangedListener.ContentEvent event) {
        this.contentChangedListenerManager.fireContentChanged(event);
    }

    public void addPage(Object newModel) {
        this.addPage((IPageModel)newModel);
    }

    public void addPage(Object newModel, int index) {
        this.addPage((IPageModel)newModel, index);
    }

    public void addPage(IPageModel newModel) {
        this.currentTabFolder.doAddItem(newModel);
        this.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, newModel));
    }

    public void addPage(int index, IPageModel newModel) {
        this.currentTabFolder.doAddItem(index, newModel);
        this.firePropertyChanged(new IContentChangedListener.ContentEvent(0, this, newModel));
    }

    public void movePage(ITabFolderModel folderModel, int oldIndex, int newIndex) {
        Activator.log.debug("movePage()");
        ((TabFolderModel)folderModel).moveTab(oldIndex, newIndex);
    }

    public void movePage(ITabFolderModel srcFolderModel, int sourceIndex, ITabFolderModel targetFolderModel, int targetIndex) {
        Activator.log.debug("movePage()");
        if (sourceIndex == -1) {
            this.moveAllPages(srcFolderModel, targetFolderModel);
            return;
        }
        IPageModel movedTab = this.doMoveTab((TabFolderModel)srcFolderModel, sourceIndex, (TabFolderModel)targetFolderModel, targetIndex);
        this.removeEmptyFolder((TabFolderModel)srcFolderModel);
        this.doSetCurrentFolder((TabFolderModel)targetFolderModel);
        this.contentChangedListenerManager.fireContentChanged(new IContentChangedListener.ContentEvent(3, this, movedTab));
    }

    public void moveAllPages(ITabFolderModel srcFolderModel, ITabFolderModel targetFolderModel) {
        TabFolderModel srcFolder = (TabFolderModel)srcFolderModel;
        TabFolderModel targetFolder = (TabFolderModel)targetFolderModel;
        List<IPageModel> toMove = srcFolder.doRemoveAll();
        targetFolder.doAddAllTab(toMove);
        this.removeEmptyFolder((TabFolderModel)srcFolderModel);
        this.doSetCurrentFolder((TabFolderModel)targetFolderModel);
        this.contentChangedListenerManager.fireContentChanged(new IContentChangedListener.ContentEvent(3, this, srcFolderModel));
    }

    private void doSetCurrentFolder(TabFolderModel newCurrentFolder) {
        this.currentTabFolder = newCurrentFolder;
    }

    public void createFolder(ITabFolderModel sourceFolder, int tabIndex, ITabFolderModel referenceFolder, int side) {
        Activator.log.debug("createFolder()");
        TabFolderModel newFolder = this.doCreateFolder((TabFolderModel)sourceFolder, tabIndex, (TabFolderModel)referenceFolder, side);
        this.contentChangedListenerManager.fireContentChanged(new IContentChangedListener.ContentEvent(2, this, sourceFolder));
    }

    public ITabFolderModel createFolder(ITabFolderModel referenceFolder, int side) {
        Activator.log.debug("createFolder()");
        TabFolderModel newFolder = this.doCreateFolder((TabFolderModel)referenceFolder, side);
        this.contentChangedListenerManager.fireContentChanged(new IContentChangedListener.ContentEvent(2, this, referenceFolder));
        return newFolder;
    }

    private IPageModel doMoveTab(TabFolderModel srcFolderModel, int sourceIndex, TabFolderModel targetFolderModel, int targetIndex) {
        IPageModel tab = srcFolderModel.doRemoveTab(sourceIndex);
        targetFolderModel.doAddItem(targetIndex, tab);
        return tab;
    }

    private void doMoveTab(TabFolderModel srcFolderModel, int sourceIndex, TabFolderModel targetFolderModel) {
        IPageModel tab = srcFolderModel.doRemoveTab(sourceIndex);
        targetFolderModel.doAddItem(tab);
    }

    private TabFolderModel doCreateFolder(TabFolderModel tabFolder, int tabIndex, TabFolderModel targetFolder, int side) {
        TabFolderModel newFolder = new TabFolderModel(this);
        this.doInsertFolder(newFolder, targetFolder, side);
        this.doMoveTab(tabFolder, tabIndex, newFolder);
        this.removeEmptyFolder(tabFolder);
        this.doSetCurrentFolder(targetFolder);
        return newFolder;
    }

    private TabFolderModel doCreateFolder(TabFolderModel referenceFolder, int side) {
        TabFolderModel newFolder = new TabFolderModel(this);
        this.doInsertFolder(newFolder, referenceFolder, side);
        this.doSetCurrentFolder(referenceFolder);
        return newFolder;
    }

    private void removeEmptyFolder(TabFolderModel tabFolder) {
        if (tabFolder.getChildren().size() > 0) {
            return;
        }
        AbstractModel parent = tabFolder.getParent();
        if (parent == this.rootModel) {
            return;
        }
        ((SashPanelModel)parent).delete(tabFolder);
    }

    private void doInsertFolder(TabFolderModel folderToInsert, TabFolderModel refFolder, int side) {
        AbstractModel refParent = refFolder.getParent();
        int direction = side == 16384 || side == 131072 ? 256 : 512;
        SashPanelModel newSash = side == 16384 || side == 128 ? new SashPanelModel(refParent, folderToInsert, refFolder, direction) : new SashPanelModel(refParent, refFolder, folderToInsert, direction);
        refFolder.setParent(newSash);
        folderToInsert.setParent(newSash);
        refParent.replaceChild(refFolder, newSash);
    }

    public IAbstractPanelModel getRootModel() {
        return this.rootModel.getChild();
    }

    public IAbstractPanelModel createChildSashModel(Object root) {
        return (IAbstractPanelModel)root;
    }

    public void removePage(int index) {
        this.currentTabFolder.removeTab(index);
    }

    public void removePage(Object page) {
        this.removePage((IPageModel)page);
    }

    public void removePage(IPageModel tabItem) {
        TabFolderModel folder = this.lookupPageFolder(tabItem);
        if (folder != null) {
            folder.removeTab(tabItem);
        }
    }

    public void removePage(ITabFolderModel parentFolder, int tabIndex) {
        TabFolderModel folder = (TabFolderModel)parentFolder;
        IPageModel removed = folder.doRemoveTab(tabIndex);
        this.removeEmptyFolder(folder);
        this.doSetCurrentFolder(this.lookupPageFolder());
        this.contentChangedListenerManager.fireContentChanged(new IContentChangedListener.ContentEvent(1, this, removed));
    }

    private TabFolderModel lookupPageFolder(IPageModel tabItem) {
        return this.rootModel.lookupTabFolder(tabItem);
    }

    private TabFolderModel lookupPageFolder() {
        return this.rootModel.lookupTabFolder(null);
    }

    public ITabFolderModel getParentFolder(IPageModel tabItem) {
        return this.lookupPageFolder(tabItem);
    }

    public ITabFolderModel getCurrentTabFolder() {
        return this.currentTabFolder;
    }

    public void setCurrentFolder(Object rawModel) {
        if (!(rawModel instanceof TabFolderModel)) {
            return;
        }
        this.doSetCurrentFolder((TabFolderModel)rawModel);
    }

    protected class ContentChangeListenerManager {
        private List<IContentChangedListener> listeners;

        protected ContentChangeListenerManager() {
        }

        public void addContentChangedListener(IContentChangedListener listener) {
            if (this.listeners == null) {
                this.createListeners();
            }
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }

        public void removeContentChangedListener(IContentChangedListener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        private void createListeners() {
            if (this.listeners == null) {
                this.listeners = new ArrayList<IContentChangedListener>();
            }
        }

        public void fireContentChanged(IContentChangedListener.ContentEvent event) {
            if (this.listeners == null) {
                return;
            }
            for (IContentChangedListener listener : this.listeners) {
                listener.contentChanged(event);
            }
        }
    }
}

