/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Geometry;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IComponentModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageLifeCycleEventsListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPanelPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ActiveEditorServicesSwitcher;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ActivePageTracker;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ComponentPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.EditorPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IMultiEditorManager;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.LookupIPageByIEditorPartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.LookupModelPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PTabFolder;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PageVisitorWrapper;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartLists;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.RootPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.SashContainerEventsProvider;
import org.eclipse.papyrus.infra.core.sasheditor.internal.ShowPartStatusVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SashWindowsContainer
implements ISashWindowsContainer {
    private ISashWindowsContentProvider contentProvider;
    private IMultiEditorManager multiEditorManager;
    private ActivePageTracker activePageTracker;
    private SashContainerEventsProvider lifeCycleEventProvider;
    private RootPart rootPart;
    private Composite container;
    protected DropTarget dropTarget;
    private AtomicBoolean isRefreshing = new AtomicBoolean(false);
    private MenuManager folderTabMenuManager;
    private DisposeListener widgetDisposedListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            SashWindowsContainer.this.dispose();
        }
    };
    IDragOverListener dragOverListener = new IDragOverListener(){

        public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
            TabFolderPart sourcePart = (TabFolderPart)SashWindowsContainer.this.rootPart.findPart(draggedObject);
            int srcTabIndex = PTabFolder.getDraggedObjectTabIndex(draggedObject);
            Rectangle containerDisplayBounds = DragUtil.getDisplayBounds((Control)SashWindowsContainer.this.container);
            AbstractPanelPart targetPart = null;
            if (containerDisplayBounds.contains(position)) {
                if (SashWindowsContainer.this.rootPart != null) {
                    targetPart = (AbstractPanelPart)SashWindowsContainer.this.rootPart.findPart(position);
                }
                if (targetPart != null) {
                    IDropTarget target;
                    int side;
                    Composite targetControl = targetPart.getControl();
                    Rectangle targetBounds = DragUtil.getDisplayBounds((Control)targetControl);
                    int distance = Geometry.getDistanceFromEdge((Rectangle)targetBounds, (Point)position, (int)(side = Geometry.getClosestSide((Rectangle)targetBounds, (Point)position)));
                    if (distance >= 5 && (target = targetPart.getDropTarget(draggedObject, sourcePart, position)) != null) {
                        return target;
                    }
                    if (distance > 30) {
                        side = 0x1000000;
                    }
                    boolean pointlessDrop = false;
                    if (sourcePart == targetPart) {
                        pointlessDrop = true;
                    }
                    return SashWindowsContainer.this.createDropTarget(sourcePart, srcTabIndex, side, side, targetPart);
                }
            } else {
                int side = Geometry.getClosestSide((Rectangle)containerDisplayBounds, (Point)position);
                boolean pointlessDrop = false;
                int cursor = Geometry.getOppositeSide((int)side);
                if (pointlessDrop) {
                    side = 0;
                }
                return SashWindowsContainer.this.createDropTarget(sourcePart, srcTabIndex, side, cursor, null);
            }
            return null;
        }
    };

    public SashWindowsContainer() {
        this(null);
    }

    public SashWindowsContainer(IMultiEditorManager multiEditorManager) {
        this.multiEditorManager = multiEditorManager;
        this.activePageTracker = new ActivePageTracker();
        if (multiEditorManager != null) {
            this.activePageTracker.addActiveEditorChangedListener(new ActiveEditorServicesSwitcher(multiEditorManager.getEditorSite()));
        }
        this.lifeCycleEventProvider = new SashContainerEventsProvider();
    }

    protected ISashWindowsContentProvider getContentProvider() {
        assert (this.contentProvider != null);
        if (this.contentProvider == null) {
            throw new IllegalStateException("ContentProvider should be set before calling any method requiring it.");
        }
        return this.contentProvider;
    }

    public void setContentProvider(ISashWindowsContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void createPartControl(Composite parent) {
        this.container = parent;
        this.rootPart = this.createRootPart();
        this.rootPart.createPartControl(this.container);
        this.refreshTabs();
        this.selectPage(this.lookupFirstValidPage());
        this.initDrag(this.container);
        this.container.addDisposeListener(this.widgetDisposedListener);
    }

    private RootPart createRootPart() {
        RootPart part = new RootPart(this);
        return part;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.container.dispose();
        this.rootPart.disposeThisAndChildren();
        this.activePageTracker = null;
        this.container = null;
        this.contentProvider = null;
        this.dragOverListener = null;
        this.folderTabMenuManager = null;
        this.lifeCycleEventProvider = null;
        this.multiEditorManager = null;
        this.rootPart = null;
    }

    public boolean isDisposed() {
        return this.activePageTracker == null;
    }

    protected void pageChanged(PagePart childPart) {
        this.activePageTracker.setActiveEditor(childPart);
        this.lifeCycleEventProvider.firePageActivatedEvent(childPart);
    }

    protected void pageChangedEvent(PagePart childPart) {
        if (this.getActivePage() == childPart) {
            return;
        }
        this.contentProvider.setCurrentFolder(childPart.getParent().getRawModel());
        this.pageChanged(childPart);
    }

    protected void setActivePage(PagePart childPart) {
        this.pageChanged(childPart);
    }

    protected void firePropertyChange(int propertyId) {
    }

    protected PagePart createPagePart(TabFolderPart parent, IPageModel partModel, Object rawModel) {
        if (partModel instanceof IEditorModel) {
            if (this.multiEditorManager == null) {
                throw new IllegalArgumentException("Container can't accept IEditorModel as no IMultiEditorManager is set. Please set a IMultiEditorManager.");
            }
            return new EditorPart(parent, (IEditorModel)partModel, rawModel, this.multiEditorManager);
        }
        if (partModel instanceof IComponentModel) {
            return new ComponentPart(parent, (IComponentModel)partModel, rawModel);
        }
        throw new IllegalArgumentException("No Part found for the model '" + rawModel + "'");
    }

    private PagePart getActivePage() {
        return this.activePageTracker.getActiveEditor();
    }

    @Override
    public IEditorPart getActiveEditor() {
        PagePart pagePart = this.getActivePage();
        if (pagePart instanceof EditorPart) {
            return ((EditorPart)pagePart).getIEditorPart();
        }
        return null;
    }

    @Override
    public IPage getActiveSashWindowsPage() {
        return this.getActivePage();
    }

    @Override
    public List<IPage> getVisiblePages() {
        CollectVisiblePageVisitor visitor = new CollectVisiblePageVisitor();
        this.rootPart.visit(visitor);
        return visitor.getVisiblePages();
    }

    @Override
    public List<IEditorPart> getVisibleIEditorParts() {
        CollectVisibleIEditorPart visitor = new CollectVisibleIEditorPart();
        this.rootPart.visit(visitor);
        return visitor.getVisiblePages();
    }

    @Override
    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    private void setFocus(PagePart part) {
        if (part != null) {
            part.setFocus();
        }
    }

    @Override
    public void refreshTabs() {
        if (this.isRefreshing.compareAndSet(false, true)) {
            try {
                this.refreshTabsInternal();
            }
            finally {
                this.isRefreshing.set(false);
            }
        } else {
            Activator.log.warn("refresh inside refresh !");
        }
    }

    public void refreshPageTab(IPage page) {
        if (page instanceof PagePart) {
            ((PagePart)page).refreshTab();
        }
    }

    private void refreshTabsInternal() {
        PagePart oldActivePage = this.getActivePage();
        this.container.setRedraw(false);
        PartLists garbageMaps = new PartLists();
        this.rootPart.fillPartMap(garbageMaps);
        this.rootPart.synchronize2(garbageMaps);
        garbageMaps.garbage();
        this.setActivePage(this.checkAndGetActivePage(oldActivePage, garbageMaps));
        this.container.setRedraw(true);
        this.container.layout(true, true);
    }

    protected void selectPage(PagePart page) {
        if (page == null) {
            return;
        }
        TabFolderPart folder = page.getParent();
        folder.setActiveEditor(page);
    }

    public void selectPage(IPage page) {
        if (page == null) {
            return;
        }
        if (!(page instanceof PagePart)) {
            return;
        }
        this.selectPage((PagePart)page);
    }

    public IPage lookupModelPage(Object rawModel) {
        LookupModelPageVisitor visitor = new LookupModelPageVisitor(rawModel);
        this.rootPart.visit(visitor);
        return visitor.result();
    }

    public IPage lookupIPageByIEditorPart(IEditorPart editor) {
        LookupIPageByIEditorPartVisitor visitor = new LookupIPageByIEditorPartVisitor(editor);
        this.rootPart.visit(visitor);
        return visitor.result();
    }

    private PagePart checkAndGetActivePage(PagePart oldActivePage, PartLists partLists) {
        PagePart activePage = partLists.getFirstCreatedPage();
        if (activePage != null) {
            return activePage;
        }
        if (oldActivePage != null && !oldActivePage.isOrphaned() && !oldActivePage.isUnchecked()) {
            return oldActivePage;
        }
        return this.lookupFirstValidPage();
    }

    private PagePart lookupFirstValidPage() {
        PartLists garbageMaps = new PartLists();
        this.rootPart.fillPartMap(garbageMaps);
        return garbageMaps.getFirstValidPage();
    }

    @Override
    public void setFolderTabMenuManager(MenuManager menuManager) {
        this.folderTabMenuManager = menuManager;
        SetFolderTabMenuVisitor visitor = new SetFolderTabMenuVisitor(menuManager);
        this.rootPart.visit(visitor);
    }

    protected MenuManager getFolderTabMenuManager() {
        return this.folderTabMenuManager;
    }

    public void showTilesStatus() {
        ShowPartStatusVisitor visitor = new ShowPartStatusVisitor();
        this.rootPart.visit(visitor);
    }

    public void visit(IPageVisitor pageVisitor) {
        PageVisitorWrapper visitor = new PageVisitorWrapper(pageVisitor);
        this.rootPart.visit(visitor);
    }

    protected void visit(IPartVisitor visitor) {
        this.rootPart.visit(visitor);
    }

    private void initDrag(Composite container) {
        DragUtil.addDragTarget((Control)container, (IDragOverListener)this.dragOverListener);
    }

    private DropTarget createDropTarget(TabFolderPart sourcePart, int srcTabIndex, int side, int cursor, AbstractPart targetPart) {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(sourcePart, srcTabIndex, side, cursor, targetPart);
        } else {
            this.dropTarget.setTarget(sourcePart, srcTabIndex, side, cursor, targetPart);
        }
        return this.dropTarget;
    }

    protected SashContainerEventsProvider getLifeCycleEventProvider() {
        return this.lifeCycleEventProvider;
    }

    @Override
    public void addPageChangedListener(IPageChangedListener pageChangedListener) {
        this.activePageTracker.addPageChangedListener(pageChangedListener);
    }

    @Override
    public void removePageChangedListener(IPageChangedListener pageChangedListener) {
        this.activePageTracker.removePageChangedListener(pageChangedListener);
    }

    @Override
    public void addPageLifeCycleListener(IPageLifeCycleEventsListener listener) {
        this.lifeCycleEventProvider.addListener(listener);
    }

    @Override
    public void removePageLifeCycleListener(IPageLifeCycleEventsListener listener) {
        this.lifeCycleEventProvider.removeListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AbstractCollectIEditorPart
    extends PartVisitor {
        protected List<IEditorPart> editorParts = new ArrayList<IEditorPart>();

        public List<IEditorPart> getVisiblePages() {
            return this.editorParts;
        }
    }

    private class CollectIEditorParts
    extends AbstractCollectIEditorPart {
        private CollectIEditorParts() {
        }

        public boolean accept(EditorPart part) {
            IEditorPart editorPart = part.getIEditorPart();
            if (editorPart != null) {
                this.editorParts.add(editorPart);
            }
            return true;
        }
    }

    private class CollectVisibleIEditorPart
    extends AbstractCollectIEditorPart {
        private CollectVisibleIEditorPart() {
        }

        public boolean accept(TabFolderPart part) {
            PagePart page = part.getVisiblePagePart();
            if (page != null && page instanceof IEditorPage) {
                IEditorPage editorPage = (IEditorPage)((Object)page);
                this.editorParts.add(editorPage.getIEditorPart());
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectVisiblePageVisitor
    extends PartVisitor {
        private List<IPage> visiblePages = new ArrayList<IPage>();
        private Class<? extends IPage> expectedClass;

        public CollectVisiblePageVisitor() {
        }

        public CollectVisiblePageVisitor(Class<? extends IPage> expectedClass) {
            this.expectedClass = expectedClass;
        }

        public <T> List<T> getVisiblePages() {
            return this.visiblePages;
        }

        @Override
        public boolean accept(TabFolderPart part) {
            PagePart page = part.getVisiblePagePart();
            if (part != null) {
                if (this.expectedClass != null && this.expectedClass.isInstance(page)) {
                    this.visiblePages.add(page);
                } else {
                    this.visiblePages.add(page);
                }
            }
            return true;
        }
    }

    protected class DropTarget
    implements IDropTarget {
        int count = 0;
        int cursor = 128;
        private int side;
        private AbstractPanelPart targetPart;
        private int srcTabIndex;
        private TabFolderPart sourcePart;

        public DropTarget(TabFolderPart sourcePart, int srcTabIndex, int cursor, int side, AbstractPart targetPart) {
            this.cursor = cursor;
            this.side = side;
            this.sourcePart = sourcePart;
            this.srcTabIndex = srcTabIndex;
            this.targetPart = (AbstractPanelPart)targetPart;
        }

        public void setTarget(TabFolderPart sourcePart, int srcTabIndex, int cursor, int side, AbstractPart targetPart) {
            this.cursor = cursor;
            this.side = side;
            this.sourcePart = sourcePart;
            this.srcTabIndex = srcTabIndex;
            this.targetPart = (AbstractPanelPart)targetPart;
        }

        public void drop() {
            if (this.side == 0x1000000) {
                SashWindowsContainer.this.contentProvider.movePage(this.sourcePart.getPartModel(), this.srcTabIndex, ((TabFolderPart)this.targetPart).getPartModel(), -1);
            } else {
                SashWindowsContainer.this.contentProvider.createFolder(this.sourcePart.getPartModel(), this.srcTabIndex, ((TabFolderPart)this.targetPart).getPartModel(), this.side);
            }
        }

        public Cursor getCursor() {
            return DragCursors.getCursor((int)DragCursors.positionToDragCursor((int)this.cursor));
        }

        public Rectangle getSnapRectangle() {
            Rectangle targetDisplayBounds = this.targetPart != null ? DragUtil.getDisplayBounds((Control)this.targetPart.getControl()) : DragUtil.getDisplayBounds((Control)SashWindowsContainer.this.container);
            if (this.side == 0x1000000 || this.side == 0) {
                return targetDisplayBounds;
            }
            int distance = Geometry.getDimension((Rectangle)targetDisplayBounds, (!Geometry.isHorizontal((int)this.side) ? 1 : 0) != 0);
            return Geometry.getExtrudedEdge((Rectangle)targetDisplayBounds, (int)((int)((float)distance * this.getDockingRatio(this.sourcePart, this.targetPart))), (int)this.side);
        }

        protected float getDockingRatio(AbstractPart dragged, AbstractPart target) {
            return 0.5f;
        }
    }

    private class SetFolderTabMenuVisitor
    extends PartVisitor {
        private MenuManager menuManager;

        public SetFolderTabMenuVisitor(MenuManager menuManager) {
            this.menuManager = menuManager;
        }

        public boolean accept(TabFolderPart part) {
            part.setFolderTabMenuManager(this.menuManager);
            return true;
        }
    }
}

