/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.extension;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.extension.BadClassNameException;
import org.eclipse.papyrus.infra.core.extension.BadNameExtensionException;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensionUtils {
    public static ExtensionUtils INSTANCE = new ExtensionUtils(){};

    protected void checkTagName(IConfigurationElement element, String tagName) throws BadNameExtensionException {
        String name = element.getName();
        if (!tagName.equals(name)) {
            throw new BadNameExtensionException("Expected '" + tagName + "', found '" + name + "'.");
        }
    }

    protected Class<?> parseClass(IConfigurationElement element, String attributeName, String extensionPointName) throws BadClassNameException {
        Class factoryClass;
        String className = element.getAttribute(attributeName);
        element.getContributor().getName();
        if (className == null || className.length() == 0) {
            throw new BadClassNameException(String.valueOf(attributeName) + "=null ", extensionPointName, attributeName);
        }
        try {
            factoryClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                String declaringID = element.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)declaringID);
                factoryClass = bundle.loadClass(className);
            }
            catch (ClassNotFoundException e1) {
                throw new BadClassNameException(String.valueOf(className) + " can not be loaded ", extensionPointName, attributeName, e1);
            }
        }
        return factoryClass;
    }
}

