/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.readonly.Activator;
import org.eclipse.papyrus.infra.emf.readonly.IReadOnlyHandler;

public class ReadOnlyManager {
    protected static final IReadOnlyHandler[] orderedHandlersArray;

    static {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.emf.readonly", "readOnlyHandler");
        LinkedList<HandlerPriorityPair> handlerPriorityPairs = new LinkedList<HandlerPriorityPair>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if ("readOnlyHandler".equals(elem.getName())) {
                try {
                    HandlerPriorityPair handlerPriorityPair = new HandlerPriorityPair();
                    handlerPriorityPair.handler = (IReadOnlyHandler)elem.createExecutableExtension("class");
                    handlerPriorityPair.priority = Integer.parseInt(elem.getAttribute("priority"));
                    handlerPriorityPairs.add(handlerPriorityPair);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
            ++n2;
        }
        Collections.sort(handlerPriorityPairs);
        orderedHandlersArray = new IReadOnlyHandler[handlerPriorityPairs.size()];
        int i = 0;
        while (i < orderedHandlersArray.length) {
            ReadOnlyManager.orderedHandlersArray[i] = ((HandlerPriorityPair)handlerPriorityPairs.get((int)i)).handler;
            ++i;
        }
    }

    public static boolean isReadOnly(Resource resource, EditingDomain editingDomain) {
        URI uri = null;
        if (resource != null && resource.getURI() != null) {
            uri = resource.getURI();
        }
        return ReadOnlyManager.isReadOnly(uri, editingDomain);
    }

    private static URI getURI(IFile iFile) {
        return URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
    }

    private static URI[] getURIs(IFile[] iFiles) {
        URI[] uris = new URI[iFiles.length];
        int i = 0;
        IFile[] iFileArray = iFiles;
        int n = iFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile iFile = iFileArray[n2];
            uris[i++] = ReadOnlyManager.getURI(iFile);
            ++n2;
        }
        return uris;
    }

    public static boolean isReadOnly(URI uri, EditingDomain editingDomain) {
        URI[] uRIArray;
        if (uri != null) {
            URI[] uRIArray2 = new URI[1];
            uRIArray = uRIArray2;
            uRIArray2[0] = uri;
        } else {
            uRIArray = new URI[]{};
        }
        URI[] uris = uRIArray;
        return ReadOnlyManager.isReadOnly(uris, editingDomain);
    }

    public static boolean isReadOnly(URI[] uris, EditingDomain editingDomain) {
        int i = 0;
        while (i < orderedHandlersArray.length) {
            if (orderedHandlersArray[i].isReadOnly(uris, editingDomain)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean enableWrite(URI[] uris, EditingDomain editingDomain) {
        int i = 0;
        while (i < orderedHandlersArray.length) {
            boolean ok;
            if (orderedHandlersArray[i].isReadOnly(uris, editingDomain) && !(ok = orderedHandlersArray[i].enableWrite(uris, editingDomain))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isReadOnly(IFile[] iFiles, EditingDomain editingDomain) {
        return ReadOnlyManager.isReadOnly(ReadOnlyManager.getURIs(iFiles), editingDomain);
    }

    public static boolean enableWrite(IFile[] iFiles, EditingDomain editingDomain) {
        return ReadOnlyManager.enableWrite(ReadOnlyManager.getURIs(iFiles), editingDomain);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HandlerPriorityPair
    implements Comparable<HandlerPriorityPair> {
        public IReadOnlyHandler handler;
        public int priority;

        protected HandlerPriorityPair() {
        }

        @Override
        public int compareTo(HandlerPriorityPair o) {
            if (o.priority > this.priority) {
                return 1;
            }
            if (o.priority < this.priority) {
                return -1;
            }
            return 0;
        }
    }
}

