/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.core.utils.OpenDiagramCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractPapyrusGmfCreateDiagramCommandHandler
extends AbstractHandler
implements IHandler,
ICreationCommand {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject container = null;
        if (this.getMultiDiagramEditor() != null) {
            container = this.getSelectedElement();
        }
        this.runAsTransaction(container);
        return null;
    }

    protected void runAsTransaction(EObject container) throws ExecutionException {
        DiResourceSet diResourceSet;
        try {
            diResourceSet = (DiResourceSet)EditorUtils.getServiceRegistry().getService(DiResourceSet.class);
        }
        catch (ServiceException e) {
            throw new ExecutionException("Can't get diResourceSet", (Throwable)e);
        }
        this.runAsTransaction(diResourceSet, container, null);
    }

    protected void runAsTransaction(DiResourceSet diResourceSet, EObject container, String name) {
        TransactionalEditingDomain dom = diResourceSet.getTransactionalEditingDomain();
        CompositeCommand cmd = new CompositeCommand("Create diagram");
        ICommand createCmd = this.getCreateDiagramCommand(diResourceSet, container, name);
        cmd.add((IUndoableOperation)createCmd);
        cmd.add((IUndoableOperation)new OpenDiagramCommand(dom, createCmd));
        dom.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
    }

    protected EObject getRootElement(Resource modelResource) {
        Object root;
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0 && (root = modelResource.getContents().get(0)) instanceof EObject) {
            rootElement = (EObject)root;
        }
        return rootElement;
    }

    protected void attachModelToResource(EObject root, Resource resource) {
        resource.getContents().add((Object)root);
    }

    public String getCreatedDiagramType() {
        return this.getDiagramNotationID();
    }

    protected abstract String getDiagramNotationID();

    protected abstract PreferencesHint getPreferenceHint();

    protected abstract String getDefaultDiagramName();

    protected EObject getSelectedElement() {
        Object businessObject;
        EObject eObject = null;
        Object selection = this.getCurrentSelection();
        if (selection != null && (businessObject = BusinessModelResolver.getInstance().getBusinessModel(selection)) instanceof EObject) {
            eObject = (EObject)businessObject;
        }
        return eObject;
    }

    private Object getCurrentSelection() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.getFirstElement();
        }
        return null;
    }

    protected Diagram createDiagram(Resource diagramResource, EObject owner, String name) {
        Diagram diagram = ViewService.createDiagram((EObject)owner, (String)this.getDiagramNotationID(), (PreferencesHint)this.getPreferenceHint());
        if (diagram != null) {
            diagram.setName(name);
            diagram.setElement(owner);
            this.initializeDiagram((EObject)diagram);
            diagramResource.getContents().add((Object)diagram);
        }
        return diagram;
    }

    protected void initializeDiagram(EObject diagram) {
    }

    protected IMultiDiagramEditor getMultiDiagramEditor() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        return (IMultiDiagramEditor)editorPart;
    }

    protected String openDiagramNameDialog(String defaultValue) {
        InputDialog inputDialog;
        int result;
        if (defaultValue == null) {
            defaultValue = "";
        }
        if ((result = (inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.AbstractPapyrusGmfCreateDiagramCommandHandler_SelectNewDiagramName, Messages.AbstractPapyrusGmfCreateDiagramCommandHandler_NewDiagramName, defaultValue, null)).open()) == 0) {
            String name = inputDialog.getValue();
            if (name == null || name.length() == 0) {
                name = defaultValue;
            }
            return name;
        }
        return null;
    }

    public void createDiagram(final DiResourceSet diResourceSet, final EObject container, final String diagramName) {
        TransactionalEditingDomain transactionalEditingDomain = diResourceSet.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(transactionalEditingDomain){

            protected void doExecute() {
                AbstractPapyrusGmfCreateDiagramCommandHandler.this.runAsTransaction(diResourceSet, container, diagramName);
            }
        };
        transactionalEditingDomain.getCommandStack().execute((Command)command);
    }

    public ICommand getCreateDiagramCommand(DiResourceSet diResourceSet, final EObject container, final String diagramName) {
        final Resource modelResource = diResourceSet.getAssociatedModelResource(container);
        final Resource notationResource = diResourceSet.getAssociatedNotationResource(container);
        final Resource diResource = diResourceSet.getAssociatedDiResource(container);
        ArrayList<IFile> modifiedFiles = new ArrayList<IFile>();
        modifiedFiles.add(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(modelResource.getURI().toPlatformString(true))));
        modifiedFiles.add(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(notationResource.getURI().toPlatformString(true))));
        modifiedFiles.add(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(diResource.getURI().toPlatformString(true))));
        return new AbstractTransactionalCommand(diResourceSet.getTransactionalEditingDomain(), Messages.AbstractPapyrusGmfCreateDiagramCommandHandler_CreateDiagramCommandLabel, modifiedFiles){
            protected Diagram diagram;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.diagram = null;
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                String name = diagramName;
                if (name == null) {
                    name = AbstractPapyrusGmfCreateDiagramCommandHandler.this.openDiagramNameDialog(AbstractPapyrusGmfCreateDiagramCommandHandler.this.getDefaultDiagramName());
                }
                if (name == null) {
                    return CommandResult.newCancelledCommandResult();
                }
                EObject model = container;
                if (model == null) {
                    model = AbstractPapyrusGmfCreateDiagramCommandHandler.this.getRootElement(modelResource);
                    AbstractPapyrusGmfCreateDiagramCommandHandler.this.attachModelToResource(model, modelResource);
                }
                this.diagram = AbstractPapyrusGmfCreateDiagramCommandHandler.this.createDiagram(notationResource, model, name);
                if (this.diagram != null) {
                    IPageMngr pageMngr = EditorUtils.getIPageMngr((Resource)diResource);
                    pageMngr.addPage((Object)this.diagram);
                    return CommandResult.newOKCommandResult((Object)this.diagram);
                }
                return CommandResult.newErrorCommandResult((String)"Error during diagram creation");
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                DestroyElementPapyrusCommand depc = this.diagram != null ? new DestroyElementPapyrusCommand(new DestroyElementRequest((EObject)this.diagram, false)) : null;
                IStatus status = super.doUndo(monitor, info);
                if (depc != null) {
                    depc.execute(null, null);
                }
                return status;
            }
        };
    }

    protected ServicesRegistry getServiceRegistry() {
        return EditorUtils.getServiceRegistry();
    }

    protected ISashWindowsContentProvider getISashWindowsContentProvider() {
        return EditorUtils.getISashWindowsContentProvider();
    }

    public boolean isParentReassignable() {
        return true;
    }
}

