/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;

public class ObservableGradientData
extends GradientData {
    private IObservableValue source;
    private GradientData encapsulated;
    private boolean activate;

    public ObservableGradientData(IObservableValue source, GradientData encapsulated) {
        this.encapsulated = new GradientData(encapsulated);
        this.source = source;
        this.activate = encapsulated != null;
    }

    public int getGradientColor1() {
        return this.encapsulated.getGradientColor1();
    }

    public int getGradientColor2() {
        return this.encapsulated.getGradientColor2();
    }

    public int getGradientStyle() {
        return this.encapsulated.getGradientStyle();
    }

    protected void notifySource() {
        if (this.activate) {
            this.source.setValue((Object)new GradientData(this.encapsulated));
        } else {
            this.source.setValue(null);
        }
    }

    public void setGradientColor1(int color) {
        this.encapsulated.setGradientColor1(color);
        this.notifySource();
    }

    public void setGradientColor2(int color) {
        this.encapsulated.setGradientColor2(color);
        this.notifySource();
    }

    public void setGradientStyle(int style) {
        this.encapsulated.setGradientStyle(style);
        this.notifySource();
    }

    public int hashCode() {
        return this.encapsulated.hashCode();
    }

    public boolean equals(Object other) {
        return this.encapsulated.equals(other);
    }

    public boolean getActivate() {
        return this.activate;
    }

    public void setActivate(boolean value) {
        this.activate = value;
        this.notifySource();
    }
}

