/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.strategy;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.swt.graphics.Image;

public abstract class MoveDropStrategy
extends TransactionalDropStrategy {
    protected EStructuralFeature feature;

    public String getLabel() {
        return "Move element";
    }

    public String getDescription() {
        return "Move the selected element in one of the target's properties";
    }

    public Image getImage() {
        return null;
    }

    protected EStructuralFeature getTargetFeature(Request request, EditPart targetEditPart) {
        return this.feature;
    }

    public void setTargetFeature(EStructuralFeature targetFeature) {
        this.feature = targetFeature;
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        Object newValue;
        List<EObject> objectsToDrop = this.getSourceEObjects(request);
        if (objectsToDrop.isEmpty()) {
            return null;
        }
        EObject targetElement = this.getTargetSemanticElement(targetEditPart);
        EStructuralFeature targetFeature = this.getTargetFeature(request, targetEditPart);
        if (targetFeature == null) {
            return null;
        }
        if (targetFeature.getUpperBound() == 1) {
            newValue = objectsToDrop.get(0);
        } else {
            EList currentValues = (EList)targetElement.eGet(targetFeature);
            LinkedList<EObject> values = new LinkedList<EObject>((Collection<EObject>)currentValues);
            values.addAll(objectsToDrop);
            newValue = values;
        }
        EditingDomain domain = this.getEditingDomain(targetEditPart);
        SetRequest setRequest = new SetRequest((TransactionalEditingDomain)domain, targetElement, targetFeature, newValue);
        SetValueCommand command = new SetValueCommand(setRequest);
        Command graphicalCommand = this.getGraphicalCommand(request, targetEditPart);
        if (graphicalCommand != null) {
            command = command.compose((IUndoableOperation)new CommandProxy(graphicalCommand));
        }
        return new ICommandProxy((ICommand)command);
    }

    protected Command getGraphicalCommand(Request request, EditPart targetEditPart) {
        return null;
    }
}

