/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.hyperlink.helper.EditorHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractEditHyperlinkDocumentShell;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorLookForEditorShell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;

public class EditorHyperLinkEditorShell
extends AbstractEditHyperlinkDocumentShell {
    protected boolean usedefaultTooltip = true;
    protected HyperLinkEditor hyperLinkEditor;
    private IPageIconsRegistry editorRegistry;
    protected final EObject amodel;

    public void open() {
        Display display = Display.getCurrent();
        this.getEditHyperlinkShell().pack();
        this.getEditHyperlinkShell().open();
        while (!this.getEditHyperlinkShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public EditorHyperLinkEditorShell(IPageIconsRegistry editorFactoryRegistry, EObject model) {
        this.amodel = model;
        this.editorRegistry = editorFactoryRegistry;
        this.createEditHyperlinkShell();
        this.getObjectcLabel().setText(Messages.EditorHyperLinkEditorShell_View);
        this.getUseDefaultCheckBox().setSelection(this.usedefaultTooltip);
        this.getObjectLabeltext().setEditable(false);
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabeltext().getText());
        }
        this.getUseDefaultCheckBox().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                EditorHyperLinkEditorShell.this.usedefaultTooltip = EditorHyperLinkEditorShell.this.getUseDefaultCheckBox().getSelection();
                if (EditorHyperLinkEditorShell.this.usedefaultTooltip) {
                    EditorHyperLinkEditorShell.this.getTooltipInputText().setEditable(false);
                    EditorHyperLinkEditorShell.this.getTooltipInputText().setText(EditorHyperLinkEditorShell.this.getObjectLabeltext().getText());
                } else {
                    EditorHyperLinkEditorShell.this.getTooltipInputText().setEditable(true);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getChooseDiagramButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForEditorShell editorLookForDiagram = new EditorLookForEditorShell(EditorHyperLinkEditorShell.this.editorRegistry, EditorHyperLinkEditorShell.this.amodel);
                editorLookForDiagram.open();
                Object selection = editorLookForDiagram.getSelectedEditor();
                if (selection != null) {
                    EditorHyperLinkHelper helper = new EditorHyperLinkHelper();
                    EditorHyperLinkEditorShell.this.hyperLinkEditor = helper.getHyperLinkObjectFor(selection);
                    Assert.isNotNull((Object)EditorHyperLinkEditorShell.this.hyperLinkEditor, (String)NLS.bind((String)Messages.EditorHyperLinkEditorShell_ICanFindTheHyperLinkEditorObject, (Object)selection));
                    EditorHyperLinkEditorShell.this.hyperLinkEditor.setObject(selection);
                    EditorHyperLinkEditorShell.this.getObjectLabeltext().setText(EditorHyperLinkEditorShell.this.hyperLinkEditor.getText(selection));
                    if (EditorHyperLinkEditorShell.this.usedefaultTooltip) {
                        EditorHyperLinkEditorShell.this.getTooltipInputText().setText(EditorHyperLinkEditorShell.this.getObjectLabeltext().getText());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getCancelButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                EditorHyperLinkEditorShell.this.hyperLinkEditor = null;
                EditorHyperLinkEditorShell.this.getEditHyperlinkShell().close();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.getOkButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (EditorHyperLinkEditorShell.this.hyperLinkEditor != null) {
                    EditorHyperLinkEditorShell.this.hyperLinkEditor.setTooltipText(EditorHyperLinkEditorShell.this.getTooltipInputText().getText().trim());
                    if (EditorHyperLinkEditorShell.this.hyperLinkEditor.getObject() == null) {
                        EditorHyperLinkEditorShell.this.hyperLinkEditor = null;
                    }
                }
                EditorHyperLinkEditorShell.this.getEditHyperlinkShell().close();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public HyperLinkEditor getHyperLinkEditor() {
        return this.hyperLinkEditor;
    }

    public void setHyperLinkEditor(HyperLinkEditor hyperLinkEditor) {
        this.getTooltipInputText().setText(hyperLinkEditor.getTooltipText());
        this.hyperLinkEditor = hyperLinkEditor;
    }
}

