/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistryExtended;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.extension.NotFoundException;
import org.eclipse.papyrus.infra.core.extension.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.infra.core.extension.commands.CreationCommandRegistry;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkEditorHelper;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractLookForEditorShell;
import org.eclipse.papyrus.infra.hyperlink.util.EditorListContentProvider;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkEditorHelpersRegistrationUtil;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.views.modelexplorer.DecoratingLabelProviderWTooltips;
import org.eclipse.papyrus.views.modelexplorer.MoDiscoLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EditorLookForEditorShell
extends AbstractLookForEditorShell {
    protected AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    protected Object selectedEditor;
    protected EObject model;
    protected Menu diagramMenuButton;
    protected TreeViewer diagramListTreeViewer;
    protected TreeViewer treeViewer;

    protected Object getSelectedEditor() {
        return this.selectedEditor;
    }

    protected void setSelectedEditor(Object selectedEditor) {
        this.selectedEditor = selectedEditor;
    }

    public EditorLookForEditorShell(IPageIconsRegistry editorFactoryRegistry, EObject amodel) {
        this.model = amodel;
        this.createLookforShell();
        this.treeViewer = this.getModeFilteredTree().getViewer();
        this.treeViewer.setUseHashlookup(true);
        LocalLabelProvider labelProvider = new LocalLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)new SemanticEMFContentProvider(new EObject[]{amodel}));
        this.treeViewer.setInput((Object)EditorUtils.getServiceRegistry());
        this.diagramListTreeViewer = this.getDiagramfilteredTree().getViewer();
        this.diagramListTreeViewer.setUseHashlookup(true);
        labelProvider = new LocalLabelProvider();
        this.diagramListTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.diagramListTreeViewer.setContentProvider((IContentProvider)new EditorListContentProvider());
        this.diagramListTreeViewer.setInput((Object)" ");
        this.diagramMenuButton = new Menu((Control)this.getNewDiagrambutton());
        this.getNewDiagrambutton().setMenu(this.diagramMenuButton);
        CreationCommandRegistry commandRegistry = CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.core");
        for (CreationCommandDescriptor desc : commandRegistry.getCommandDescriptors()) {
            MenuItem menuItem = new MenuItem(this.diagramMenuButton, 8);
            menuItem.addSelectionListener((SelectionListener)new DiagramCreateListener(desc, null, (ICreationCommandRegistry)commandRegistry));
            menuItem.setText(desc.getLabel());
        }
        this.getNewDiagrambutton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForEditorShell.this.diagramMenuButton.setVisible(true);
            }
        });
        this.getRemoveDiagrambutton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection iSelection = (IStructuredSelection)EditorLookForEditorShell.this.getModeFilteredTree().getViewer().getSelection();
                Iterator iterator = iSelection.iterator();
                while (iterator.hasNext()) {
                    IPageMngr pageMngr = EditorUtils.getIPageMngr();
                    pageMngr.removePage(iterator.next());
                }
                EditorLookForEditorShell.this.getDiagramfilteredTree().getViewer().setInput(null);
                EditorLookForEditorShell.this.getDiagramfilteredTree().getViewer().setInput((Object)"");
                EditorLookForEditorShell.this.getModeFilteredTree().getViewer().setInput(null);
                EditorLookForEditorShell.this.getModeFilteredTree().getViewer().setInput((Object)EditorLookForEditorShell.this.model.eResource());
            }
        });
        this.getModeFilteredTree().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)EditorLookForEditorShell.this.getModeFilteredTree().getViewer().getSelection()).getFirstElement();
                EditorLookForEditorShell.this.refresh(selection);
            }
        });
        this.getDiagramfilteredTree().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)EditorLookForEditorShell.this.getDiagramfilteredTree().getViewer().getSelection()).getFirstElement();
                EditorLookForEditorShell.this.refresh(selection);
            }
        });
        this.getOKbutton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForEditorShell.this.getLookforShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getCancelbutton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForEditorShell.this.setSelectedEditor(null);
                EditorLookForEditorShell.this.getLookforShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void open() {
        Display display = Display.getCurrent();
        this.getLookforShell().pack();
        this.getLookforShell().pack();
        this.getLookforShell().open();
        while (!this.getLookforShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void refresh(Object selectedElement) {
        selectedElement = EMFHelper.getEObject((Object)selectedElement);
        Button but = this.getOKbutton();
        if (this.isAValidEditor(selectedElement)) {
            but = this.getOKbutton();
            but.setEnabled(true);
            this.selectedEditor = selectedElement;
        } else {
            but.setEnabled(false);
            this.selectedEditor = null;
        }
    }

    protected boolean isAValidEditor(Object object) {
        Collection<AbstractHyperLinkEditorHelper> helpers = HyperLinkEditorHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkEditorHelper();
        for (AbstractHyperLinkEditorHelper current : helpers) {
            HyperLinkEditor editor = current.getHyperLinkObjectFor(object);
            if (editor == null) continue;
            return true;
        }
        return false;
    }

    public class DiagramCreateListener
    extends SelectionAdapter {
        private final CreationCommandDescriptor commandDescriptor;
        private EObject container;
        private final ICreationCommandRegistry iCreationCommandRegistry;

        public void widgetSelected(SelectionEvent e) {
            try {
                EObject elt = (EObject)((IStructuredSelection)EditorLookForEditorShell.this.treeViewer.getSelection()).getFirstElement();
                this.setContainer(elt);
                ServicesRegistry servicesRegistry = EditorUtils.getServiceRegistry();
                DiResourceSet diResourceSet = (DiResourceSet)servicesRegistry.getService(DiResourceSet.class);
                ICreationCommand creationCommand = this.iCreationCommandRegistry.getCommand(this.commandDescriptor.getCommandId());
                creationCommand.createDiagram(diResourceSet, this.container, null);
                EditorLookForEditorShell.this.getDiagramfilteredTree().getViewer().setInput(null);
                EditorLookForEditorShell.this.getDiagramfilteredTree().getViewer().setInput((Object)"");
                EditorLookForEditorShell.this.getModeFilteredTree().getViewer().setInput(null);
                EditorLookForEditorShell.this.getModeFilteredTree().getViewer().setInput((Object)EditorLookForEditorShell.this.model.eResource());
            }
            catch (NotFoundException ex) {
                ex.printStackTrace();
            }
            catch (BackboneException ex) {
                ex.printStackTrace();
            }
            catch (ServiceException ex) {
                ex.printStackTrace();
            }
        }

        public DiagramCreateListener(CreationCommandDescriptor commandDescriptor, EObject container, ICreationCommandRegistry iCreationCommandRegistry) {
            this.commandDescriptor = commandDescriptor;
            this.container = container;
            this.iCreationCommandRegistry = iCreationCommandRegistry;
        }

        public void setContainer(EObject container) {
            this.container = container;
        }
    }

    private class LocalLabelProvider
    extends DecoratingLabelProviderWTooltips {
        private IPageIconsRegistry editorRegistry;

        public LocalLabelProvider() {
            super((ILabelProvider)new MoDiscoLabelProvider());
        }

        protected IPageIconsRegistry createEditorRegistry() {
            try {
                return (IPageIconsRegistry)EditorUtils.getServiceRegistry().getService(IPageIconsRegistry.class);
            }
            catch (ServiceException e) {
                return new PageIconsRegistry();
            }
        }

        protected IPageIconsRegistryExtended getEditorRegistry() {
            if (this.editorRegistry == null) {
                this.editorRegistry = this.createEditorRegistry();
            }
            if (!(this.editorRegistry instanceof IPageIconsRegistryExtended)) {
                throw new RuntimeException("The editor registry do not implement IPageIconsRegistryExtended");
            }
            return (IPageIconsRegistryExtended)this.editorRegistry;
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof PapyrusTableInstance) {
                return new StyledString(((PapyrusTableInstance)element).getName());
            }
            return super.getStyledText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof PapyrusTableInstance) {
                return this.getEditorRegistry().getEditorIcon(element);
            }
            return super.getImage(element);
        }
    }
}

