/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.action;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.controlmode.action.PapyrusControlAction;

public class PapyrusControlHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEvaluationContext context;
        Object selection;
        Object evaluationContext = event.getApplicationContext();
        if (evaluationContext instanceof IEvaluationContext && (selection = (context = (IEvaluationContext)evaluationContext).getVariable("selection")) instanceof IStructuredSelection) {
            IStructuredSelection currentSelection = (IStructuredSelection)selection;
            EditingDomain domain = null;
            Iterator iterator = currentSelection.iterator();
            while (iterator.hasNext()) {
                domain = EMFHelper.resolveEditingDomain(iterator.next());
                if (domain != null) break;
            }
            PapyrusControlAction action = new PapyrusControlAction(domain);
            action.updateSelection(currentSelection);
            if (action.isEnabled()) {
                action.run();
            }
        }
        return null;
    }
}

