/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.EditingDomainUndoContext;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.notation.NotationUtils;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.resource.uml.UmlUtils;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.controlmode.commands.ControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.IUncontrolCommand;
import org.eclipse.papyrus.infra.services.controlmode.history.utils.HistoryUtils;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.ControledResource;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.historyPackage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncontrolCommand
extends AbstractTransactionalCommand {
    private static final String CONTROL_EXTENSION_POINT_ID = "org.eclipse.papyrus.infra.services.controlmode.customControlCommand";
    private static final String UNCONTROL_CMD_ATTRIBUTE_EXTENSION_POINT = "uncontrolCommand";
    private static final String UNCONTROL_CMD_ELEMENT_EXTENSION_POINT = "customUncontrolCommand";
    private EObject eObject;
    private ModelSet modelSet;
    private Resource controlledModel;
    private Resource controlledNotation;
    private Resource controlledDI;
    private List<IUncontrolCommand> commands;
    private List<ControledResource> controlledResourceToRemove;
    private List<ControledResource> addedControlledResource;
    private boolean deleteResources;

    public UncontrolCommand(TransactionalEditingDomain domain, EObject selectedObject, String label, List<?> affectedFiles) {
        this(domain, selectedObject, label, affectedFiles, false);
    }

    public UncontrolCommand(TransactionalEditingDomain domain, EObject selectedObject, String label, List<?> affectedFiles, boolean deleteUncontrolledResources) {
        super(domain, label, affectedFiles);
        this.eObject = selectedObject;
        this.addContext((IUndoContext)new EditingDomainUndoContext((EditingDomain)domain));
        this.controlledResourceToRemove = new LinkedList<ControledResource>();
        this.addedControlledResource = new LinkedList<ControledResource>();
        this.deleteResources = deleteUncontrolledResources;
        ResourceSet set = domain.getResourceSet();
        if (set instanceof ModelSet) {
            this.modelSet = (ModelSet)set;
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.commands = this.getCommandExtensions();
        IStatus status = this.doRedo(monitor, info);
        CommandResult result = status.equals(Status.OK_STATUS) ? CommandResult.newOKCommandResult() : (status.equals(Status.CANCEL_STATUS) ? CommandResult.newErrorCommandResult((String)"Unable to execute uncontrol command") : CommandResult.newCancelledCommandResult());
        return result;
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ControlCommand transactionalCommand = new ControlCommand(this.modelSet.getTransactionalEditingDomain(), this.controlledModel, this.eObject, "Control", null);
        this.modelSet.getTransactionalEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)transactionalCommand));
        return Status.OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.eObject != null) {
            this.controlledModel = this.eObject.eResource();
            URI newNotationURI = URI.createURI((String)this.controlledModel.getURI().trimFileExtension().appendFileExtension("notation").toString());
            this.controlledNotation = this.getEditingDomain().getResourceSet().getResource(newNotationURI, true);
            URI newDiURI = URI.createURI((String)this.controlledModel.getURI().trimFileExtension().appendFileExtension("di").toString());
            this.controlledDI = this.getEditingDomain().getResourceSet().getResource(newDiURI, true);
        }
        if (this.modelSet == null) {
            this.modelSet = EditorUtils.getDiResourceSet();
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        this.uncontrolNotation(compoundCommand);
        this.uncontrolModel(compoundCommand);
        EcoreUtil.resolveAll((ResourceSet)this.getEditingDomain().getResourceSet());
        if (compoundCommand.canExecute()) {
            compoundCommand.execute();
            this.deleteControlledResources();
            return Status.OK_STATUS;
        }
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to uncontrol", (String)"Unable to execute uncontrol command");
        return Status.CANCEL_STATUS;
    }

    private void uncontrolModel(CompoundCommand compoundCommand) {
        Resource resource = UmlUtils.getUmlModel((ModelSet)this.modelSet).getResource();
        this.uncontrol((EditingDomain)this.getEditingDomain(), this.eObject, this.controlledModel, resource, compoundCommand, IUncontrolCommand.STATE_CONTROL.PRE_MODEL);
        compoundCommand.append((Command)new RemoveCommand((EditingDomain)this.getEditingDomain(), this.eObject.eResource().getContents(), (Object)this.eObject));
        this.unassignControlledResourceOfCurrentElement((EditingDomain)this.getEditingDomain(), compoundCommand, this.getDIResource(this.eObject), this.eObject.eResource().getURI().toString(), resource.getURI().toString());
        this.uncontrol((EditingDomain)this.getEditingDomain(), this.eObject, this.controlledModel, resource, compoundCommand, IUncontrolCommand.STATE_CONTROL.POST_MODEL);
    }

    private void uncontrolNotation(CompoundCommand compoundCommand) {
        List controlledDiagrams = NotationUtils.getDiagrams((Resource)this.controlledNotation, (EObject)this.eObject);
        if (!controlledDiagrams.isEmpty()) {
            Resource notationResource = NotationUtils.getNotationModel((ModelSet)this.modelSet).getResource();
            for (Diagram diag : controlledDiagrams) {
                this.uncontrol((EditingDomain)this.getEditingDomain(), (EObject)diag, this.controlledNotation, notationResource, compoundCommand, IUncontrolCommand.STATE_CONTROL.PRE_NOTATION);
            }
            compoundCommand.append((Command)new AddCommand((EditingDomain)this.getEditingDomain(), notationResource.getContents(), (Collection)controlledDiagrams));
            HashSet<Resource> resources = new HashSet<Resource>(controlledDiagrams.size());
            for (Diagram d : controlledDiagrams) {
                resources.add(d.eResource());
            }
            for (Resource r : resources) {
                this.unassignControlledResourceOfCurrentElement((EditingDomain)this.getEditingDomain(), compoundCommand, this.getDIResource(this.eObject), r.getURI().toString(), notationResource.getURI().toString());
            }
            for (Diagram diag : controlledDiagrams) {
                this.uncontrol((EditingDomain)this.getEditingDomain(), (EObject)diag, this.controlledNotation, notationResource, compoundCommand, IUncontrolCommand.STATE_CONTROL.POST_NOTATION);
            }
            this.uncontrol((EditingDomain)this.getEditingDomain(), this.eObject, this.controlledNotation, notationResource, compoundCommand, IUncontrolCommand.STATE_CONTROL.POST_NOTATION);
        }
    }

    private void unassignControlledResourceOfCurrentElement(EditingDomain domain, CompoundCommand compoundCommand, Resource model, String oldURL, String newURL) {
        this.controlledResourceToRemove.clear();
        this.addedControlledResource.clear();
        if (model != null) {
            URI uriPath = HistoryUtils.getURIFullPath((String)newURL);
            newURL = HistoryUtils.resolve((URI)uriPath, (String)newURL);
            oldURL = HistoryUtils.resolve((URI)uriPath, (String)oldURL);
            HashSet controledOldURL = new HashSet(HistoryUtils.getControledResourcesForURL((ModelSet)this.modelSet, (String)oldURL));
            controledOldURL.addAll(HistoryUtils.getControledResourcesForURL((ModelSet)this.modelSet, (String)oldURL.substring(oldURL.lastIndexOf("/") + 1, oldURL.length())));
            List controledNewURL = HistoryUtils.getControledResourcesForURL((ModelSet)this.modelSet, (String)newURL);
            for (ControledResource resourceOldURL : controledOldURL) {
                if (resourceOldURL.getChildren().isEmpty()) {
                    this.controlledResourceToRemove.add(resourceOldURL);
                    continue;
                }
                if (resourceOldURL.eContainer() instanceof ControledResource) {
                    compoundCommand.append(AddCommand.create((EditingDomain)domain, (Object)resourceOldURL.eContainer(), (Object)historyPackage.Literals.CONTROLED_RESOURCE__CHILDREN, Collections.singleton(resourceOldURL)));
                    continue;
                }
                for (ControledResource resourceNewURL : controledNewURL) {
                    compoundCommand.append(AddCommand.create((EditingDomain)domain, (Object)resourceNewURL, (Object)historyPackage.Literals.CONTROLED_RESOURCE__CHILDREN, (Collection)resourceOldURL.getChildren()));
                    this.addedControlledResource.addAll((Collection<ControledResource>)resourceOldURL.getChildren());
                    for (ControledResource c : resourceOldURL.getChildren()) {
                        String childRelativeUrl = c.getResourceURL();
                        URI absoluteChildPath = URI.createURI((String)(String.valueOf(c.eResource().getURI().trimSegments(1).toString()) + "/"));
                        URI absoluteChildURI = URI.createURI((String)childRelativeUrl).resolve(absoluteChildPath);
                        String urlResolved = absoluteChildURI.deresolve(uriPath).toString();
                        compoundCommand.append(SetCommand.create((EditingDomain)domain, (Object)c, (Object)historyPackage.Literals.CONTROLED_RESOURCE__RESOURCE_URL, (Object)urlResolved));
                    }
                }
            }
            for (ControledResource parent : controledNewURL) {
                if (this.controlledResourceToRemove.containsAll((Collection<?>)parent.getChildren()) && this.addedControlledResource.isEmpty()) {
                    compoundCommand.append((Command)new RemoveCommand(domain, parent.eResource().getContents(), (Object)parent));
                    continue;
                }
                for (ControledResource r : this.controlledResourceToRemove) {
                    compoundCommand.append(RemoveCommand.create((EditingDomain)domain, (Object)r.eContainer(), (Object)historyPackage.Literals.CONTROLED_RESOURCE__CHILDREN, (Object)r));
                }
            }
        }
    }

    private Resource getDIResource(EObject eObject) {
        return SashModelUtils.getSashModel((ModelSet)this.modelSet).getResource();
    }

    public void uncontrol(EditingDomain domain, EObject selection, Resource source, Resource target, CompoundCommand command, IUncontrolCommand.STATE_CONTROL state) {
        for (IUncontrolCommand cmd : this.commands) {
            if (!cmd.provides(selection, state, source, target)) continue;
            cmd.uncontrol(domain, selection, state, source, target, command);
        }
    }

    private List<IUncontrolCommand> getCommandExtensions() {
        IConfigurationElement[] extensions;
        LinkedList<IUncontrolCommand> commands = new LinkedList<IUncontrolCommand>();
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTROL_EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (UNCONTROL_CMD_ELEMENT_EXTENSION_POINT.equals(e.getName())) {
                try {
                    IUncontrolCommand uncontrolCmd = (IUncontrolCommand)e.createExecutableExtension(UNCONTROL_CMD_ATTRIBUTE_EXTENSION_POINT);
                    commands.add(uncontrolCmd);
                }
                catch (CoreException exception) {
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        return commands;
    }

    private void deleteControlledResources() {
        EList resources = this.getEditingDomain().getResourceSet().getResources();
        resources.remove((Object)this.controlledModel);
        resources.remove((Object)this.controlledNotation);
        resources.remove((Object)this.controlledDI);
        ArrayList<IResource> todelete = new ArrayList<IResource>();
        this.addFileResource(this.controlledModel, todelete);
        this.addFileResource(this.controlledNotation, todelete);
        this.addFileResource(this.controlledDI, todelete);
        if (this.deleteResources) {
            for (IResource file : todelete) {
                try {
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException exception) {
                    EMFEditUIPlugin.INSTANCE.log((Object)exception);
                }
            }
        }
    }

    private void addFileResource(Resource emfRes, Collection<IResource> fileResources) {
        URI uri;
        URI uRI = uri = emfRes != null ? emfRes.getURI() : null;
        if (uri != null && uri.isPlatformResource()) {
            Path path = new Path(uri.toPlatformString(false));
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (r != null) {
                fileResources.add(r);
            }
        }
    }
}

