/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.util;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModePlugin;
import org.eclipse.papyrus.infra.services.controlmode.commands.IControlCondition;
import org.eclipse.papyrus.infra.services.controlmode.commands.IControlUncontrolCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlModeUtil {
    private static final String CONTROL_CONDITION_EXTENSION_POINT_ID = "org.eclipse.papyrus.infra.services.controlmode.customControlCommand";
    private static final String CONTROL_CONDITION_ATTRIBUTE_EXTENSION_POINT = "controlCondition";
    private static final String CONTROL_CONDITION_ELEMENT_EXTENSION_POINT = "enableControlCommand";
    private static List<IControlCondition> commands = ControlModeUtil.getCommandConditionsExtensions();

    public static boolean canControl(EObject eObject) {
        boolean enableControl = true;
        for (IControlCondition cond : commands) {
            enableControl &= cond.enableControl(eObject);
        }
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)eObject);
        return enableControl && domain.isControllable((Object)eObject) && !AdapterFactoryEditingDomain.isControlled((Object)eObject);
    }

    public static boolean canUncontrol(EObject eObject) {
        boolean enableUnControl = true;
        for (IControlCondition cond : commands) {
            if (!(cond instanceof IControlUncontrolCondition)) continue;
            IControlUncontrolCondition controlUnControl = (IControlUncontrolCondition)cond;
            enableUnControl &= controlUnControl.enableUnControl(eObject);
        }
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)eObject);
        return enableUnControl && domain.isControllable((Object)eObject) && AdapterFactoryEditingDomain.isControlled((Object)eObject);
    }

    private static List<IControlCondition> getCommandConditionsExtensions() {
        IConfigurationElement[] extensions;
        LinkedList<IControlCondition> commands = new LinkedList<IControlCondition>();
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTROL_CONDITION_EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (CONTROL_CONDITION_ELEMENT_EXTENSION_POINT.equals(e.getName())) {
                try {
                    IControlCondition controlCondition = (IControlCondition)e.createExecutableExtension(CONTROL_CONDITION_ATTRIBUTE_EXTENSION_POINT);
                    commands.add(controlCondition);
                }
                catch (CoreException exception) {
                    ControlModePlugin.log.error((Throwable)exception);
                }
            }
            ++n2;
        }
        return commands;
    }
}

